/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Option;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.BookYearField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ReportAdapterHelper;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.ProofDepreciationToCSV;
import nl.ibs.fac.reports.ProofDepreciationToCSVForET;
import nl.ibs.fac.reports.ProofDepreciationToPDF;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class ProofDepreciationReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -7871395110412682950L;
    public static final String PAGE = ProofDepreciationReportAdapter.class.getName();
    private static final String SUBMIT = "submit";
    private String title = "Title.ProofDepreciationReport";
    private String classNameCSV = ProofDepreciationToCSV.CLASSNAME;
    private String classNameCSVForET = ProofDepreciationToCSVForET.CLASSNAME;
    private String classNamePDF = ProofDepreciationToPDF.CLASSNAME;
    private String jobName = "Job.ProofDepreciation";
    private Panel panel = new HeaderPanel();
    private Panel selectionPanel = null;
    private Field bookYearFrom = new Field("Label.BookYearFrom", "number");
    private ComboBox numberOfYears = new ComboBox("Label.NumberOfYears");
    private FieldGroup subPanel = new FieldGroup("Label.Common");
    private ComboBox periodType = new ComboBox("Label.PrintPer");
    private ComboBox accountingPrinciple = new ComboBox("Label.AccountingPrinciple");
    private AccountingPrincipleChangeAction accountingPrincipleChangeAction;
    private ComboBox reportType;
    private CheckBox generalTotal;
    private CheckBox inclDisinvested;
    private CheckBox forETransaction;
    private ETransactionChangeAction eTransactionChangeAction;
    private ReportTypeChangeAction reportTypeChangeAction;
    private AssetSelection assetSelection = null;
    private boolean[] asda = new boolean[]{true, true, true, false, false, false, false, false, false, true, true, false, false};
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbShowContinued = new FloatBar();
    private FloatBar fbShowSelectionPanel = new FloatBar();

    public ProofDepreciationReportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Company company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.panel.setWidth(590);
        this.bookYearFrom = new BookYearField("Label.StartYear", this.bookYear, this.bookYearMin, "9999");
        if (company.getLastDepreciationRunYear() != 0) {
            this.bookYearFrom.setValue("" + (company.getLastDepreciationRunYear() + 1));
        }
        this.panel.addUIObject((UIObject)this.bookYearFrom);
        this.periodType.addOption(LanguageHelper.getString("nl.ibs.fac.language", "Label.BookYear"), "B");
        this.periodType.addOption(LanguageHelper.getString("nl.ibs.fac.language", "Label.Period"), "P");
        this.periodType.setSelectedOptionValue("B");
        this.panel.addUIObject((UIObject)this.periodType);
        this.reportType = ReportAdapterHelper.retrieveReportTypeComboBox(false);
        this.reportTypeChangeAction = new ReportTypeChangeAction();
        this.reportType.add((Action)this.reportTypeChangeAction);
        this.panel.addUIObject((UIObject)this.reportType);
        this.forETransaction = new CheckBox("Label.ForETransaction", false);
        this.eTransactionChangeAction = new ETransactionChangeAction();
        this.forETransaction.setAction((Action)this.eTransactionChangeAction);
        this.panel.addUIObject((UIObject)this.forETransaction);
        this.numberOfYears.addOption("1", "1");
        this.numberOfYears.addOption("2", "2");
        this.numberOfYears.addOption("3", "3");
        this.numberOfYears.addOption("4", "4");
        this.numberOfYears.addOption("5", "5");
        this.numberOfYears.addOption("6", "6");
        this.numberOfYears.setSelectedOptionValue("1");
        this.numberOfYears.setSortThreshold(11);
        this.subPanel.add(this.numberOfYears);
        this.accountingPrinciple = ReportAdapterHelper.retrieveAccountingPrincipleComboBox(this.env, company, this.governmentActivated);
        if (this.accountingPrinciple.getOptions().size() > 1) {
            if (this.governmentActivated) {
                this.accountingPrincipleChangeAction = new AccountingPrincipleChangeAction();
                this.accountingPrinciple.add((Action)this.accountingPrincipleChangeAction);
            }
            this.subPanel.add(this.accountingPrinciple);
        }
        this.generalTotal = new CheckBox("Label.PrintGeneralTotal", false);
        this.subPanel.add(this.generalTotal);
        this.inclDisinvested = new CheckBox("Label.IncludePreliminaryCredits", false);
        if (this.governmentActivated) {
            this.subPanel.add(this.inclDisinvested);
        }
        Action next1 = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showContinued");
        next1.setValidationEnabled(true);
        next1.setDefault(true);
        this.fbShow.addAction(next1);
        this.fbShow.addAction(this.finish);
        this.fbShowContinued.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show"));
        Action next2 = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showSelectionPanel");
        next2.setValidationEnabled(true);
        next2.setDefault(true);
        this.fbShowContinued.addAction(next2);
        this.fbShowContinued.addAction(this.finish);
        this.fbShowSelectionPanel.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showContinued"));
        Action ok = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShowSelectionPanel.addAction(ok);
        this.fbShowSelectionPanel.addAction(this.finish);
        if (this.accountingPrincipleChangeAction != null) {
            this.accountingPrincipleChangeAction.execute(object);
        }
        this.reportTypeChangeAction.execute(object);
        this.eTransactionChangeAction.execute(object);
        this.assetSelection = new AssetSelection(object, false);
        this.assetSelection.hideFieldGroup = true;
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(false);
        this.eTransactionChangeAction.execute(object);
        object.addUIObject((UIObject)this.panel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject showContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(true);
        object.addUIObject((UIObject)this.panel);
        this.subPanel.setReadonly(false);
        object.addUIObject((UIObject)this.subPanel);
        object.addUIObject((UIObject)this.fbShowContinued);
        return object;
    }

    public DataObject showSelectionPanel(DataObject object) throws Exception {
        if ("P".equals(this.periodType.getSelectedOptionValue()) && (!"1".equals(this.accountingPrinciple.getSelectedOptionValue()) && !"2".equals(this.accountingPrinciple.getSelectedOptionValue()) || "PDF".equals(this.reportType.getSelectedOptionValue()))) {
            if (this.governmentActivated) {
                object.addUIObject((UIObject)new Message("Error.AmountsPerPeriodOnlyWithAssetsAndCSV", "error"));
            } else {
                object.addUIObject((UIObject)new Message("Error.AmountsPerPeriodOnlyWithCSV", "error"));
            }
            return object;
        }
        this.assetSelection.setDisplayAttributes(this.asda[0], this.asda[1], this.asda[2], this.asda[3], this.asda[4], this.asda[5], this.asda[6], this.asda[7], this.asda[8], this.asda[9], this.asda[10], this.asda[11], this.asda[12]);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(true);
        object.addUIObject((UIObject)this.panel);
        this.subPanel.setReadonly(true);
        object.addUIObject((UIObject)this.subPanel);
        this.selectionPanel = this.assetSelection.getSelectionPanel(this.loginHelper);
        object.addUIObject((UIObject)this.selectionPanel);
        object.addUIObject((UIObject)this.fbShowSelectionPanel);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("governmentActivated", "" + this.governmentActivated));
        list.add(new NameValuePair("BookYearFrom", this.bookYearFrom.getValue()));
        list.add(new NameValuePair("NumberOfYears", this.numberOfYears.getSelectedOptionValue()));
        list.add(new NameValuePair("PeriodType", this.periodType.getSelectedOptionValue()));
        list.add(new NameValuePair("AccountingPrinciple", this.accountingPrinciple.getSelectedOptionValue()));
        this.assetSelection.fldInclDisinvested.setValue(this.inclDisinvested.getValueAsBoolean());
        this.assetSelection.fldGrandTotal.setValue(this.generalTotal.getValueAsBoolean());
        list.add(new NameValuePair(AssetSelection.ASSETSELECTION, this.assetSelection.getStringRepresentation()[0]));
        list.add(new NameValuePair(AssetSelection.ASSETSELECTION + "2", this.assetSelection.getStringRepresentation()[1]));
        this.assetSelection.save();
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("title", (Object)this.title);
        this.getProcess().removeAttribute("classNameCSV");
        this.getProcess().removeAttribute("classNamePDF");
        if ("CSV".equals(this.reportType.getValue())) {
            if (this.forETransaction.getValueAsBoolean()) {
                this.getProcess().setAttribute("classNameCSV", (Object)this.classNameCSVForET);
            } else {
                this.getProcess().setAttribute("classNameCSV", (Object)this.classNameCSV);
            }
        } else {
            this.getProcess().setAttribute("classNamePDF", (Object)this.classNamePDF);
        }
        this.getProcess().setAttribute("jobName", (Object)this.jobName);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("backMethod", (Object)"showSelectionPanel");
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        return object;
    }

    private class ETransactionChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public boolean execute(DataObject dataObject) throws Exception {
            if (ProofDepreciationReportAdapter.this.forETransaction.getValueAsBoolean()) {
                ProofDepreciationReportAdapter.this.reportType.setValueAsString("CSV");
                ProofDepreciationReportAdapter.this.reportType.setReadonly(true);
                ProofDepreciationReportAdapter.this.periodType.setSelectedOptionValue("B");
                ProofDepreciationReportAdapter.this.periodType.setReadonly(true);
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[11] = false;
            } else {
                ProofDepreciationReportAdapter.this.reportType.setReadonly(false);
                ProofDepreciationReportAdapter.this.periodType.setReadonly(false);
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[11] = true;
            }
            return true;
        }
    }

    private class AccountingPrincipleChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("1".equals(ProofDepreciationReportAdapter.this.accountingPrinciple.getValue()) || "2".equals(ProofDepreciationReportAdapter.this.accountingPrinciple.getValue())) {
                ProofDepreciationReportAdapter.this.inclDisinvested.setValue(false);
                ProofDepreciationReportAdapter.this.inclDisinvested.setHidden(true);
                if (!"CSV".equals(ProofDepreciationReportAdapter.this.reportType.getValue())) {
                    ProofDepreciationReportAdapter.this.generalTotal.setHidden(false);
                    ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[0] = true;
                    ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[1] = true;
                }
            } else {
                ProofDepreciationReportAdapter.this.inclDisinvested.setHidden(false);
                ProofDepreciationReportAdapter.this.generalTotal.setValue(false);
                ProofDepreciationReportAdapter.this.generalTotal.setHidden(true);
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[0] = false;
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[1] = false;
            }
            return true;
        }
    }

    private class ReportTypeChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;
        private Option option7 = new Option("7", "7");
        private Option option8 = new Option("8", "8");
        private Option option9 = new Option("9", "9");
        private Option option10 = new Option("10", "10");

        public boolean execute(DataObject dataObject) throws Exception {
            if ("CSV".equals(ProofDepreciationReportAdapter.this.reportType.getValue())) {
                ProofDepreciationReportAdapter.this.generalTotal.setValue(false);
                ProofDepreciationReportAdapter.this.generalTotal.setHidden(true);
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[9] = false;
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[10] = false;
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[11] = true;
                ProofDepreciationReportAdapter.this.numberOfYears.addOption(this.option7);
                ProofDepreciationReportAdapter.this.numberOfYears.addOption(this.option8);
                ProofDepreciationReportAdapter.this.numberOfYears.addOption(this.option9);
                ProofDepreciationReportAdapter.this.numberOfYears.addOption(this.option10);
            } else if ("1".equals(ProofDepreciationReportAdapter.this.accountingPrinciple.getValue()) || "2".equals(ProofDepreciationReportAdapter.this.accountingPrinciple.getValue())) {
                ProofDepreciationReportAdapter.this.generalTotal.setHidden(false);
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[9] = true;
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[10] = true;
                ((ProofDepreciationReportAdapter)ProofDepreciationReportAdapter.this).asda[11] = false;
                ProofDepreciationReportAdapter.this.numberOfYears.removeOption(this.option7);
                ProofDepreciationReportAdapter.this.numberOfYears.removeOption(this.option8);
                ProofDepreciationReportAdapter.this.numberOfYears.removeOption(this.option9);
                ProofDepreciationReportAdapter.this.numberOfYears.removeOption(this.option10);
            }
            return true;
        }
    }
}

