/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.ProofDisInvestmentBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;

public class ProofDisInvestmentAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -3737010940090461944L;
    public static final String PAGE = ProofDisInvestmentAdapter.class.getName();
    public static final String RETURNPAGE = "ProofDisinvestmentAdapterReturnPage";
    public static final String RETURNMETHOD = "ProofDisinvestmentAdapterReturnMethod";
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private String[] fgTexts = new String[2];
    private Company company;
    private Window window;
    private FieldGroup fgAP2;
    private Panel headerPanel;
    private AssetReferenceField assetReferenceField;
    private FieldGroup floatBar;

    public ProofDisInvestmentAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.fgTexts[0] = this.env.getAPShortName1();
        this.fgTexts[1] = this.env.getAPShortName2();
        Action disinvestmentOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("disinvest");
        disinvestmentOK.setDefault(true);
        FloatBar fb = new FloatBar();
        fb.addAction(disinvestmentOK);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.floatBar = new FieldGroup();
        this.floatBar.forceBorder(false);
        this.floatBar.add(fb);
    }

    public DataObject disinvest(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return object;
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        return object;
    }

    public DataObject show(DataObject object) throws Exception {
        Asset asset = (Asset)this.getProcess().getAttribute("assetToDisInvest");
        ProofDisInvestmentBP businessProcess = (ProofDisInvestmentBP)this.getProcess().getAttribute("proofDisInvestmentProcess");
        BigDecimal[] values = businessProcess.getProofDisInvestmentValues();
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Title.DisInvestmentProposal");
        this.headerPanel = new HeaderPanel();
        this.assetReferenceField = new AssetReferenceField(this.company, null, null, false, false);
        this.assetReferenceField.setLabel("Label.Asset");
        this.assetReferenceField.setReadonly(true);
        this.assetReferenceField.setValue(asset.getId());
        this.assetReferenceField.setDescription(asset.getDescription());
        this.headerPanel.addUIObject((UIObject)this.assetReferenceField);
        int[] yp = businessProcess.retrieveDisinvestmentPeriod();
        BookYearPeriodGrid disinvestmentPeriod = new BookYearPeriodGrid("Label.DisInvestmentPeriod", "" + yp[0], "" + yp[1], true);
        this.headerPanel.addUIObject((UIObject)disinvestmentPeriod);
        Field field = new Field("Label.YieldValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(values[0]), 15);
        field.setType("decimal");
        field.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)field);
        this.window.add(this.headerPanel);
        FieldGroup fg = new FieldGroup(this.fgTexts[0]);
        this.addFields(fg, values, 1);
        this.window.add(fg);
        if (values[3] != null) {
            this.fgAP2 = new FieldGroup(this.fgTexts[1]);
            this.addFields(this.fgAP2, values, 3);
            this.window.add(this.fgAP2);
        }
        this.window.add(this.floatBar);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    private FieldGroup addFields(FieldGroup fg, BigDecimal[] values, int startIndex) throws Exception {
        Field field = new Field("Label.AcquisitionValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(values[startIndex]), 15);
        field.setType("decimal");
        field.setReadonly(true);
        fg.add(field);
        field = new Field("Label.AggregatedDepreciation.short", "decimal", null, (String)DECIMALTRANSFORMER.transform(values[startIndex + 1]), 15);
        field.setType("decimal");
        field.setReadonly(true);
        fg.add(field);
        BigDecimal result = new BigDecimal("0").subtract(values[startIndex]).add(values[startIndex + 1].subtract(values[0]));
        field = new Field("Label.Result", "decimal", null, (String)DECIMALTRANSFORMER.transform(result), 15);
        field.setType("decimal");
        field.setReadonly(true);
        fg.add(field);
        return fg;
    }
}

