/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Collection;
import java.util.List;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.BinaryObject;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Option;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.PropertiesHelper;

public class PropertyAdapter
extends Adapter {
    private static final long serialVersionUID = -7747499718525501111L;
    public static final String PAGE = PropertyAdapter.class.getName();
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private CollectionTable table = null;
    private static final String[] LABELS = new String[]{"Label.Name", "Label.Value"};
    private static final short[] SIZES = new short[]{200, 500};
    private NameValuePair pair;
    private Field name = new Field("Label.Name");
    private Field value = new Field("Label.Value");
    private HeaderPanel headerPanel = new HeaderPanel();
    private static final String[] FILES = new String[]{"DocumentViewer", "jeeLog"};
    private ComboBox files;

    public PropertyAdapter(DataObject object) throws Exception {
        super(object);
        this.showTaskBar(false);
        Option[] options = new Option[FILES.length];
        for (int i = 0; i < FILES.length; ++i) {
            options[i] = new Option(FILES[i], FILES[i] + ".properties");
        }
        this.files = new ComboBox("Label.PropertiesFile", options);
        this.files.setWidth("200");
        FileChangeAction fileChangeAction = new FileChangeAction();
        this.files.add((Action)fileChangeAction);
        this.headerPanel.addUIObject((UIObject)this.files);
        this.value.setLength(60);
        Action download = new Action("Button.Download", (Adapter)this, "download");
        download.setIsDownloadAction(true);
        this.fbShow.addAction(download);
        Action edit = new Action("Button.Edit", (Adapter)this, "edit");
        this.rowActions = new Action[]{edit};
        this.headerActions = new Action[]{download};
        Action save = new Action("Button.OK", (Adapter)this, "save");
        save.setDefault(true);
        Action cancel = new Action("Button.Cancel", (Adapter)this, "show");
        this.fbEdit.addAction(save);
        this.fbEdit.addAction(cancel);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Properties", "screen_name", null));
        object.addUIObject((UIObject)this.headerPanel);
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        this.table = new CollectionTable(NameValuePair.class, (Collection)PropertiesHelper.getPropertyList((String)this.files.getSelectedOptionValue()), 12);
        this.table.setName(PAGE);
        this.table.setColumnNames(NameValuePair.NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.orderByColumn("name");
        this.table.setSortable(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.table.reload();
    }

    public DataObject edit(DataObject object) throws Exception {
        this.pair = (NameValuePair)TableHelper.getSelectedItem((DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Properties", "screen_name", null));
        FieldGroup fg = new FieldGroup();
        this.name.setValue(this.pair.getName());
        this.name.setReadonly(true);
        this.value.setValue(this.pair.getValue());
        fg.add(this.name);
        fg.add(this.value);
        object.addUIObject((UIObject)fg);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject save(DataObject object) throws Exception {
        this.pair.setValue(this.value.getValue());
        this.table.updateRow((Object)this.pair);
        this.table.reloadPage();
        String message = PropertiesHelper.savePropertyList((List)((List)this.table.getCollection()), (String)this.files.getSelectedOptionValue());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message));
        }
        return this.show(object);
    }

    public DataObject download(DataObject object) throws Exception {
        BinaryObject bobj = new BinaryObject(PropertiesHelper.getBytes((List)((List)this.table.getCollection())), "text/plain", object);
        bobj.openSaveAsDialog(this.files.getSelectedOptionValue());
        return bobj;
    }

    public String getDescription() {
        return this.translate("Process.Properties");
    }

    public String getShortDescription() {
        return "Process.Properties.short";
    }

    private class FileChangeAction
    extends Action {
        private static final long serialVersionUID = -5754487294837754394L;

        private FileChangeAction() {
        }

        public boolean execute(DataObject dataObject) throws Exception {
            dataObject.clearScreen();
            PropertyAdapter.this.table = null;
            PropertyAdapter.this.show(dataObject);
            return true;
        }
    }
}

