/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.fac.adapters.BookYearField;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;

public abstract class ReportAdapterHelper {
    public static NumberField retrieveFromPeriodNumberField(Company company, int numberOfPeriods) throws Exception {
        BookYearField fromPeriodNumberField = new BookYearField("Label.StartPeriod", "1", "1", "" + (numberOfPeriods + company.getNumberOfCorrectionPeriods()));
        fromPeriodNumberField.setLength(2);
        fromPeriodNumberField.setMaxLength(2);
        return fromPeriodNumberField;
    }

    public static NumberField retrieveToPeriodNumberField(Company company, int numberOfPeriods) throws Exception {
        int toPeriod = company.getLastDepreciationRunPeriod();
        if (toPeriod == 0) {
            ++toPeriod;
        }
        BookYearField toPeriodNumberField = new BookYearField("Label.PeriodUntilIncluding", "" + toPeriod, "1", "" + (numberOfPeriods + company.getNumberOfCorrectionPeriods()));
        toPeriodNumberField.setLength(2);
        toPeriodNumberField.setMaxLength(2);
        return toPeriodNumberField;
    }

    public static ComboBox retrieveAccountingPrincipleComboBox(Environment env, Company company, boolean governmentActivated) throws Exception {
        ComboBox accountingPrincipleComboBox = new ComboBox("Label.AccountingPrinciple");
        accountingPrincipleComboBox.addOption(env.getAPName1(), "1");
        accountingPrincipleComboBox.setSelectedOptionValue("1");
        if (governmentActivated) {
            accountingPrincipleComboBox.addOption(env.getAPName3(), "3");
            accountingPrincipleComboBox.addOption("Label.Both", "9");
        } else {
            int ap2Usage = company.getAccountingPrinciple2Usage();
            if (ap2Usage < 0) {
                ap2Usage = company.getAccountingPrinciple2Usage();
            }
            if (ap2Usage != 0) {
                accountingPrincipleComboBox.addOption(env.getAPName2(), "2");
            }
        }
        return accountingPrincipleComboBox;
    }

    public static ComboBox retrieveReportTypeComboBox(boolean includeEmptyOption) throws Exception {
        ComboBox reportTypeComboBox = new ComboBox("Label.ReportType");
        if (includeEmptyOption) {
            reportTypeComboBox.addOption("", "");
        }
        reportTypeComboBox.addOption("CSV", "CSV");
        reportTypeComboBox.addOption("PDF", "PDF");
        return reportTypeComboBox;
    }
}

