/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.ColumnDefinition;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.ReportDefinitionTypeEnum;
import nl.ibs.fac.ReportDefinitionUsageEnum;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ReportDefinitionTypeTransformer;
import nl.ibs.fac.adapters.ReportDefinitionUsageTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.reports.ReportDefinitionHelper;
import nl.ibs.jsql.UserSetting;
import nl.ibs.jsql.UserSettings;

public class ReportDefinitionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -5426783790459101251L;
    public static final String PAGE = ReportDefinitionAdapter.class.getName();
    public static final String ONTHEFLY_RETURNPAGE = "OnTheFlyReturnPage";
    public static final String ONTHEFLY_RETURNMETHOD = "OnTheFlyReturnMethod";
    public static final String ONTHEFLY_USER = "OnTheFlyUser";
    public static final String ONTHEFLY_ID = "OnTheFlyId";
    public static final String ONTHEFLY_DESCRIPTION = "OnTheFlyDescription";
    public static final String ONTHEFLY_TYPE = "OnTheFlyType";
    public static final String ONTHEFLY_USAGE = "OnTheFlyUsage";
    private static final String[] NAMES = new String[]{"key1", "value", "key2", "key3"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.Usage"};
    private static final short[] SIZES = new short[]{120, 250, 150, 150};
    private static final String[] TYPES = new String[]{null, null, null, null};
    private static final Transformer[] TRANSFORMERS = new Transformer[]{null, null, new ReportDefinitionTypeTransformer(), new ReportDefinitionUsageTransformer()};
    private CommonTable.SearchPanel searchPanel;
    private static final String[] SEARCH_NAMES = new String[]{"key1", "value"};
    private static final String[] SEARCH_LABELS = new String[]{"Label.Id", "Label.Description"};
    private static final String REFRESH = "refresh";
    private static final String CREATEFORM = "createForm";
    private static final String CREATE = "create";
    private static final String INITEDITFORM = "initEditForm";
    private static final String EDIT = "edit";
    private static final String UPDATE = "updateColumnDefinitions";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private HeaderPanel headerPanel;
    private Field hpId;
    private Field hpName;
    private Field hpType;
    private Field hpUsage;
    private TabbedPanel tabbedPanel;
    private ESPGridLayout grid1;
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbUpdate = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Window createWindow;
    private Field id;
    private Field name;
    private ComboBox cobType;
    private ComboBox cobUsage;
    private Company company;
    private boolean isFMS = false;
    private UserSettings userSettings;
    private CollectionTable definitionTable = null;
    private UserSetting reportDefinition;
    private boolean newDefinition = false;
    private boolean onTheFly = false;
    private int usage;
    private Vector columnDefinitions;
    private NumberField[] inputs;
    private Label[] labels;
    private Label legend = new Label("Label.ReportDefinitionLegend");

    public ReportDefinitionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        if (this.env.getOperationArea().trim().length() > 0) {
            this.isFMS = true;
        }
        this.userSettings = new UserSettings("fac", "FACSYSBEH", this.env.getFacLib());
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(INITEDITFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(this.finish);
        this.rowActions = new Action[]{edit, confirmDelete};
        this.headerActions = new Action[]{refresh, create};
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK.setValidationEnabled(true);
        createOK.setDefault(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        Action returnToSender = new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("returnToSender");
        editOK.setValidationEnabled(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(returnToSender);
        Action update = new Action("Button.Update").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(UPDATE);
        update.setDefault(true);
        this.fbUpdate.alignment(1);
        this.fbUpdate.addAction(update);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.headerPanel = new HeaderPanel("");
        this.headerPanel.setForceBorder(true);
        this.headerPanel.setWidth(800);
        this.hpId = new Field("Label.Id");
        this.hpId.setLength(10);
        this.hpId.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.hpId);
        this.hpName = new Field("Label.Description");
        this.hpName.setLength(40);
        this.headerPanel.addUIObject((UIObject)this.hpName);
        this.hpType = new Field("Label.Type");
        this.hpType.setLength(40);
        this.hpType.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.hpType);
        this.hpUsage = new Field("Label.Usage");
        this.hpUsage.setLength(40);
        this.hpUsage.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.hpUsage);
        this.tabbedPanel = new TabbedPanel();
        Tab tab1 = new Tab("Label.FieldSelection");
        FieldGroup fg1 = new FieldGroup("", 800, 0);
        fg1.forceBorder(false);
        this.grid1 = new ESPGridLayout();
        this.grid1.setColumnWidths(new short[]{40, 220, 40, 220, 40, 220});
        fg1.add(this.grid1);
        tab1.add(fg1);
        tab1.add(this.fbUpdate);
        this.tabbedPanel.add(tab1);
        this.legend.setColor("blue");
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.MaintainReportDefinitions", "screen_name"));
        if (this.definitionTable == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.definitionTable);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        Collection reportDefinitions = this.userSettings.getSettings("FACReportDefinition", "RT");
        Iterator rdi = reportDefinitions.iterator();
        while (rdi.hasNext()) {
            UserSetting reportDefinition = (UserSetting)rdi.next();
            if (reportDefinition.getKey3() == null || reportDefinition.getKey3().length() <= 0 || reportDefinition.getKey3().equals(this.companyId)) continue;
            rdi.remove();
        }
        this.definitionTable = new CollectionTable(UserSetting.class, reportDefinitions, 12);
        this.definitionTable.setName(PAGE);
        this.definitionTable.setColumnNames(NAMES);
        this.definitionTable.setColumnLabels(LABELS);
        this.definitionTable.setColumnSizes(SIZES);
        this.definitionTable.setColumnTypes(TYPES);
        this.definitionTable.setDisplayTransformers(TRANSFORMERS);
        this.definitionTable.setSortable(true);
        this.definitionTable.setSelectable(false);
        TableHelper.createMenu((Table)this.definitionTable, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.definitionTable.createSearch(SEARCH_NAMES, SEARCH_LABELS);
        this.definitionTable.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.definitionTable = null;
        return this.show(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.createWindow = new Window();
        this.createWindow.setLabel("Title.CreateReportDefinition");
        FieldGroup fg1 = new FieldGroup("");
        this.id = new Field("Label.Id", "upper");
        this.id.setLength(10);
        this.id.setMaxLength(10);
        this.id.setMandatory(true);
        fg1.add(this.id);
        this.name = new Field("Label.Description");
        this.name.setLength(40);
        this.name.setMaxLength(40);
        this.name.setMandatory(true);
        fg1.add(this.name);
        this.cobType = EnumHelper.createComboBox("Label.Type", ReportDefinitionTypeEnum.getCollection(this.governmentActivated), false);
        fg1.add(this.cobType);
        this.cobUsage = EnumHelper.createComboBox("Label.Usage", ReportDefinitionUsageEnum.getCollection(), false);
        fg1.add(this.cobUsage);
        this.createWindow.add(fg1);
        FieldGroup fg2 = new FieldGroup();
        fg2.add(this.fbCreate);
        this.createWindow.add(fg2);
        object.addUIObject((UIObject)this.createWindow);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        Collection dummy = this.userSettings.getSettings("FACReportDefinition", "RT", this.id.getValue());
        this.id.removeInvalidTag();
        if (dummy != null && !dummy.isEmpty()) {
            this.id.setInvalidTag();
            this.createWindow.add(new Message("duplicate_key", "error"));
            return object;
        }
        this.newDefinition = true;
        this.reportDefinition = null;
        this.hpId.setValue(this.id.getValue());
        this.hpName.setValue(this.name.getValue());
        this.hpName.setReadonly(false);
        this.hpType.setValue(ReportDefinitionTypeEnum.getValue(Integer.parseInt(this.cobType.getSelectedOptionValue())));
        this.usage = Integer.parseInt(this.cobUsage.getSelectedOptionValue());
        this.hpUsage.setValue(ReportDefinitionUsageEnum.getValue(Integer.parseInt(this.cobUsage.getSelectedOptionValue())));
        this.columnDefinitions = ReportDefinitionHelper.retrieveAllColumnDefinitions(this.env, this.isFMS, this.company, Integer.parseInt(this.cobType.getSelectedOptionValue()), Integer.parseInt(this.cobUsage.getSelectedOptionValue()));
        this.initializeEditForm(object, true);
        return this.editForm(object);
    }

    public DataObject createOnTheFly(DataObject object) throws Exception {
        String user = this.getProcess().getAttributeAsString(ONTHEFLY_USER);
        this.userSettings = new UserSettings("fac", user, this.env.getFacLib());
        this.userSettings.remove("FACReportDefinition", "RT", false);
        this.userSettings.remove("FACReportDefinition", "RS", false);
        String key1 = this.getProcess().getAttributeAsString(ONTHEFLY_ID);
        String key2 = this.getProcess().getAttributeAsString(ONTHEFLY_TYPE);
        String key3 = this.getProcess().getAttributeAsString(ONTHEFLY_USAGE);
        String description = this.getProcess().getAttributeAsString(ONTHEFLY_DESCRIPTION);
        this.userSettings.setValue(description, "FACReportDefinition", "RT", key1, key2, key3, false);
        Collection dummy = this.userSettings.getSettings("FACReportDefinition", "RT", false);
        for (UserSetting this.reportDefinition : dummy) {
        }
        this.newDefinition = false;
        this.onTheFly = true;
        this.hpId.setValue(this.reportDefinition.getKey1());
        this.hpName.setValue(this.reportDefinition.getValue());
        this.hpName.setReadonly(true);
        this.hpType.setValue(ReportDefinitionTypeEnum.getValue(Integer.parseInt(this.reportDefinition.getKey2())));
        this.usage = this.companyId.equals(this.reportDefinition.getKey3()) ? 0 : 1;
        this.hpUsage.setValue(ReportDefinitionUsageEnum.getValue(this.usage));
        this.columnDefinitions = ReportDefinitionHelper.retrieveAllColumnDefinitions(this.env, this.isFMS, this.company, Integer.parseInt(this.reportDefinition.getKey2()), this.usage);
        this.initializeEditForm(object, true);
        this.updateInputs();
        this.updateColumnDefinitions();
        this.initializeEditForm(object, false);
        return this.editForm(object);
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.newDefinition = false;
        this.reportDefinition = (UserSetting)TableHelper.getSelectedItem((DataObject)object);
        this.hpId.setValue(this.reportDefinition.getKey1());
        this.hpName.setValue(this.reportDefinition.getValue());
        this.hpName.setReadonly(false);
        this.hpType.setValue(ReportDefinitionTypeEnum.getValue(Integer.parseInt(this.reportDefinition.getKey2())));
        this.usage = this.companyId.equals(this.reportDefinition.getKey3()) ? 0 : 1;
        this.hpUsage.setValue(ReportDefinitionUsageEnum.getValue(this.usage));
        this.columnDefinitions = ReportDefinitionHelper.retrieveAllColumnDefinitions(this.env, this.isFMS, this.company, Integer.parseInt(this.reportDefinition.getKey2()), this.usage);
        this.initializeEditForm(object, true);
        this.updateInputs();
        this.updateColumnDefinitions();
        this.initializeEditForm(object, false);
        return this.editForm(object);
    }

    private void updateInputs() throws Exception {
        int index = 0;
        int seqNr = 10;
        Collection columns = this.userSettings.getSettings("FACReportDefinition", "RS", this.reportDefinition.getKey1());
        for (UserSetting updates : columns) {
            String value = updates.getValue();
            String[] values = value.split(",");
            block1: for (int i = 0; i < values.length; ++i) {
                index = 0;
                for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                    if (columnDefinition.getDdsName().equals(values[i])) {
                        this.inputs[index].setValue((long)seqNr);
                        seqNr += 10;
                        continue block1;
                    }
                    ++index;
                }
            }
        }
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        if (this.newDefinition) {
            object.addUIObject((UIObject)new Header("Title.CreateReportDefinition", "screen_name"));
        } else if (this.onTheFly) {
            object.addUIObject((UIObject)new Header("Title.CreateCSVFile", "screen_name"));
        } else {
            object.addUIObject((UIObject)new Header("Title.EditReportDefinition", "screen_name"));
        }
        this.headerPanel.setWidth(800);
        object.addUIObject((UIObject)this.headerPanel);
        object.addUIObject((UIObject)this.tabbedPanel);
        if (this.hpType.getValue().equals(ReportDefinitionTypeEnum.getValue(1)) || this.hpType.getValue().equals(ReportDefinitionTypeEnum.getValue(4))) {
            object.addUIObject((UIObject)this.legend);
        }
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    private void initializeEditForm(DataObject object, boolean firstTime) throws Exception {
        this.inputs = new NumberField[this.columnDefinitions.size()];
        this.labels = new Label[this.columnDefinitions.size()];
        Iterator cdi = this.columnDefinitions.iterator();
        int index = 0;
        int seqNr = 0;
        while (cdi.hasNext()) {
            ColumnDefinition columnDefinition = (ColumnDefinition)cdi.next();
            this.inputs[index] = new NumberField("", 3, true);
            if (index == 0) {
                this.inputs[index].requestFocus(true);
            }
            this.labels[index] = new Label(object.translate(columnDefinition.getLabel(), object.getLocale()) + "&nbsp;" + columnDefinition.getSuffix());
            this.labels[index].setHelpId(null);
            if (columnDefinition.getType().equals("CC") || columnDefinition.getType().equals("CT")) {
                this.labels[index].setColor("blue");
            }
            if (columnDefinition.getDdsName().equals("ID")) {
                this.labels[index].setColor("red");
            }
            if (firstTime) {
                columnDefinition.setSort_2(index);
            }
            if (columnDefinition.getSort_1() != 0 && columnDefinition.getSort_1() != 999) {
                this.inputs[index].setValue((long)(seqNr += 10));
            }
            columnDefinition.setSort_1(999);
            ++index;
        }
        int a = this.columnDefinitions.size() / 3;
        int b = this.columnDefinitions.size() % 3;
        if (a == 0) {
            a = b;
        } else if (b > 0) {
            ++a;
        }
        this.grid1.removeAllChildUIObjects();
        for (int i = 0; i < a; ++i) {
            this.grid1.add((UIObject)this.inputs[i], i, 0);
            this.grid1.add((UIObject)this.labels[i], i, 1);
            if (i + a < this.columnDefinitions.size()) {
                this.grid1.add((UIObject)this.inputs[i + a], i, 2);
                this.grid1.add((UIObject)this.labels[i + a], i, 3);
            }
            if (i + 2 * a >= this.columnDefinitions.size()) continue;
            this.grid1.add((UIObject)this.inputs[i + 2 * a], i, 4);
            this.grid1.add((UIObject)this.labels[i + 2 * a], i, 5);
        }
    }

    public DataObject updateColumnDefinitions(DataObject object) throws Exception {
        this.updateColumnDefinitions();
        this.initializeEditForm(object, false);
        return this.editForm(object);
    }

    private void updateColumnDefinitions() throws Exception {
        Iterator cdi = this.columnDefinitions.iterator();
        int index = 0;
        while (cdi.hasNext()) {
            ColumnDefinition columnDefinition = (ColumnDefinition)cdi.next();
            if (this.inputs[index].getIntValue() > 0) {
                columnDefinition.setSort_1(this.inputs[index].getIntValue());
            }
            ++index;
        }
        Collections.sort(this.columnDefinitions, new ColumnDefinitionsComparator());
    }

    public DataObject edit(DataObject object) throws Exception {
        this.updateColumnDefinitions();
        String key1 = this.hpId.getValue();
        String key2 = this.newDefinition ? this.cobType.getSelectedOptionValue() : this.reportDefinition.getKey2();
        String key3 = "";
        if (this.usage == 0) {
            key3 = this.companyId;
        }
        this.userSettings.setValue(this.hpName.getValue(), "FACReportDefinition", "RT", key1, key2, key3, false);
        String value = "";
        String comma = "";
        for (ColumnDefinition columnDefinition : this.columnDefinitions) {
            if (columnDefinition.getSort_1() == 0 || columnDefinition.getSort_1() == 999) continue;
            value = value + comma + columnDefinition.getDdsName();
            comma = ",";
        }
        this.userSettings.setValue(value, "FACReportDefinition", "RS", key1, key2, key3, false);
        if (this.onTheFly) {
            object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(ONTHEFLY_RETURNPAGE).toString(), this.getProcess().getAttribute(ONTHEFLY_RETURNMETHOD).toString(), this.getProcess().getProcessId()));
            return object;
        }
        return this.refresh(object);
    }

    public DataObject returnToSender(DataObject object) throws Exception {
        if (this.onTheFly) {
            object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(ONTHEFLY_RETURNPAGE).toString(), "show", this.getProcess().getProcessId()));
            return object;
        }
        return this.refresh(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.reportDefinition = (UserSetting)TableHelper.getSelectedItem((DataObject)object);
        Window deleteWindow = new Window();
        deleteWindow.setLabel("Title.DeleteReportDefinition");
        this.headerPanel.setWidth(550);
        deleteWindow.add(this.headerPanel);
        this.hpId.setValue(this.reportDefinition.getKey1());
        this.hpName.setValue(this.reportDefinition.getValue());
        this.hpName.setReadonly(true);
        this.hpType.setValue(ReportDefinitionTypeEnum.getValue(Integer.parseInt(this.reportDefinition.getKey2())));
        this.usage = this.companyId.equals(this.reportDefinition.getKey3()) ? 0 : 1;
        this.hpUsage.setValue(ReportDefinitionUsageEnum.getValue(this.usage));
        FieldGroup fg = new FieldGroup();
        fg.add(this.fbDelete);
        deleteWindow.add(fg);
        object.addUIObject((UIObject)deleteWindow);
        return object;
    }

    public DataObject delete(DataObject object) throws Exception {
        this.userSettings.remove("FACReportDefinition", "RT", this.hpId.getValue(), false);
        this.userSettings.remove("FACReportDefinition", "RS", this.hpId.getValue(), false);
        return this.refresh(object);
    }

    public class ColumnDefinitionsComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 8359768855140619392L;

        public int compare(Object o1, Object o2) {
            int returnCode = 0;
            try {
                returnCode = ((ColumnDefinition)o1).getSort_1() - ((ColumnDefinition)o2).getSort_1();
                if (returnCode == 0) {
                    returnCode = ((ColumnDefinition)o1).getSort_2() - ((ColumnDefinition)o2).getSort_2();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return returnCode;
        }
    }
}

