/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.uiobjects.APITable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.DisinvestmentReasonCodeEnum;
import nl.ibs.fac.JournalingsTermEnum;
import nl.ibs.fac.MainTransactionTypeEnum;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReasonCodeEnum;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FISBookingsTable;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSBookingsTable;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;

public class TransactionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3222365021538547885L;
    public static final String PAGE = TransactionAdapter.class.getName();
    private Company company;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private String[] finTexts = new String[5];
    private Transaction transaction;
    private Panel panel;
    private FieldGroup fg;
    private Field field;
    private TransactionBatch transactionBatch;
    private static final String SHOWBOOKINGS = "showBookings";
    private String[] mainAccountDescriptions = new String[4];

    public TransactionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        this.finTexts[4] = this.env.getName5();
    }

    public DataObject show(DataObject object) throws Exception {
        this.transaction = (Transaction)TableHelper.getSelectedItem((DataObject)object);
        Window window = new Window();
        window.setTop("15%");
        window.setWidth(580);
        window.setLabel(object.translate("Title.Transaction", object.getLocale()) + " " + this.transaction.getDocumentNr() + '/' + this.transaction.getSeqNr());
        this.panel = new Panel();
        window.add(this.panel);
        boolean hideFinGroup = false;
        this.addCommonFieldGroup();
        block0 : switch (this.transaction.getMainTransactionType()) {
            case 1: {
                this.initializeMainAccountDescriptions(1);
                this.addAmountsForInvestment();
                this.addDimensionFieldGroup("", this.transaction);
                break;
            }
            case 2: {
                this.initializeMainAccountDescriptions(2);
                this.addAmountsForDisinvestment();
                this.addDimensionFieldGroup("", this.transaction);
                break;
            }
            case 3: {
                this.initializeMainAccountDescriptions(3);
                this.addAmountsForDepreciationAndInterest();
                this.addDimensionFieldGroup("", this.transaction);
                break;
            }
            case 4: {
                this.initializeMainAccountDescriptions(4);
                this.addAmountsForLedgerCorrection();
                this.addDimensionFieldGroup("", this.transaction);
                break;
            }
            case 5: {
                this.initializeMainAccountDescriptions(5);
                this.addAmountsForDepreciationAndInterest();
                this.addDimensionFieldGroup("", this.transaction);
                break;
            }
            case 9: {
                if (this.transaction.getTransactionType() == 10 || this.transaction.getTransactionType() == 15) {
                    this.addAmountsForInvestment();
                    this.addDimensionFieldGroup("", this.transaction);
                    break;
                }
                if (this.transaction.getTransactionType() == 90) {
                    this.addAmountsForDepreciationAndInterest();
                    this.addDimensionFieldGroup("", this.transaction);
                    break;
                }
                if (this.transaction.getTransactionType() == 145 || this.transaction.getTransactionType() == 140) break;
                if (this.transaction.getTransactionType() == 150) {
                    this.addAggregatedAmounts();
                    break;
                }
                if (this.transaction.getTransactionType() == 40) {
                    if (this.transaction.getState() == 0) break;
                    this.addDimensionFieldGroup("Label.BeforeChange", this.transaction);
                    Collection transactions = TransactionBO.getTransactionsForDocument(this.transaction);
                    Iterator ti = transactions.iterator();
                    Transaction investmentTransaction = null;
                    while (ti.hasNext()) {
                        investmentTransaction = (Transaction)ti.next();
                        if (investmentTransaction.getMainTransactionType() != 1 || this.transaction.getFinDimId1().trim().equals(investmentTransaction.getFinDimId1().trim()) && this.transaction.getFinDimId2().trim().equals(investmentTransaction.getFinDimId2().trim()) && this.transaction.getFinDimId3().trim().equals(investmentTransaction.getFinDimId3().trim()) && this.transaction.getFinDimId4().trim().equals(investmentTransaction.getFinDimId4().trim()) && this.transaction.getFinDimId5().trim().equals(investmentTransaction.getFinDimId5().trim())) continue;
                        this.addDimensionFieldGroup("Label.AfterChange", investmentTransaction);
                        break block0;
                    }
                    break;
                }
                if (this.transaction.getTransactionType() == 60) {
                    this.addValuationAttributeFieldGroup("Label.BeforeChange", true);
                    this.addValuationAttributeFieldGroup("Label.AfterChange", false);
                    hideFinGroup = true;
                    break;
                }
                if (this.transaction.getTransactionType() != 100) break;
                this.addTypeAttributeFieldGroup("Label.BeforeChange", true);
                this.addTypeAttributeFieldGroup("Label.AfterChange", false);
                hideFinGroup = true;
            }
        }
        if (!hideFinGroup && this.transaction.getVoucherId().trim().length() > 0 || this.transaction.getMainTransactionType() == 4) {
            this.addFinancialFieldGroup();
        }
        this.addCreationFieldGroup();
        if (this.transaction.getState() == 1 && this.transaction.getVoucherId().length() > 0) {
            this.transactionBatch = (TransactionBatch)TransactionBatchBO.get(this.dbData, this.companyId, this.transaction.getBatchId())[0];
            if (this.transactionBatch != null && this.transactionBatch.getState() == 2) {
                window.add(new Action("Button.Bookings").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SHOWBOOKINGS).setDefault(true));
            }
        }
        object.addUIObject((UIObject)window);
        return object;
    }

    private void addFinancialFieldGroup() throws Exception {
        this.fg = new FieldGroup();
        FinancialReferenceField frf = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, "Label.Daybook", -1, this.company.getId(), "" + this.company.getCurrentBookYear(), false) : new FMSReferenceField(this.loginHelper, "Label.Daybook", -1, false);
        frf.setValue(this.transaction.getDaybookId());
        frf.setReadonly(true);
        this.fg.add((Field)frf);
        this.field = new Field("Label.VoucherId", "text", null, this.transaction.getVoucherId(), 10);
        this.field.setReadonly(true);
        this.fg.add(this.field);
        DateSelectionField dsField = new DateSelectionField("Label.VoucherDate");
        dsField.setLength(10);
        dsField.setReadonly(true);
        dsField.setValue(this.transaction.getVoucherDate());
        this.fg.add((Field)dsField);
        if (this.transaction.getMainAccount1().trim().length() > 0) {
            this.addMainAccount(this.transaction.getMainAccount1(), 0);
        }
        if (this.transaction.getMainAccount2().trim().length() > 0) {
            this.addMainAccount(this.transaction.getMainAccount2(), 1);
        }
        if (this.transaction.getMainAccount3().trim().length() > 0) {
            this.addMainAccount(this.transaction.getMainAccount3(), 2);
        }
        if (this.transaction.getMainAccount4().trim().length() > 0) {
            this.addMainAccount(this.transaction.getMainAccount4(), 3);
        }
        if (this.transaction.getAmount1().doubleValue() != 0.0 || this.transaction.getAmount2().doubleValue() != 0.0 || this.transaction.getAmount3().doubleValue() != 0.0) {
            this.panel.addUIObject((UIObject)this.fg);
        }
    }

    private void addMainAccount(String mainAccount, int index) throws Exception {
        FinancialReferenceField frf = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, this.mainAccountDescriptions[index], 0, this.company.getId(), "" + this.company.getCurrentBookYear(), false) : new FMSReferenceField(this.loginHelper, this.mainAccountDescriptions[index], 0, false);
        frf.setValue(mainAccount);
        frf.setReadonly(true);
        this.fg.add((Field)frf);
    }

    private void initializeMainAccountDescriptions(int mainTransactionType) throws Exception {
        switch (mainTransactionType) {
            case 1: {
                this.mainAccountDescriptions[0] = JournalingsTermEnum.getValue(10);
                this.mainAccountDescriptions[1] = JournalingsTermEnum.getValue(20);
                this.mainAccountDescriptions[2] = "";
                this.mainAccountDescriptions[3] = JournalingsTermEnum.getValue(40);
                if (this.transaction.getTransactionType() != 50) break;
                this.mainAccountDescriptions[3] = JournalingsTermEnum.getValue(90);
                break;
            }
            case 2: {
                this.mainAccountDescriptions[0] = JournalingsTermEnum.getValue(10);
                this.mainAccountDescriptions[1] = JournalingsTermEnum.getValue(20);
                this.mainAccountDescriptions[2] = TranslationHelperImpl.getInstance().translate("Label.Result");
                this.mainAccountDescriptions[3] = JournalingsTermEnum.getValue(40);
                if (this.transaction.getTransactionType() != 50) break;
                this.mainAccountDescriptions[3] = JournalingsTermEnum.getValue(90);
                break;
            }
            case 3: {
                this.mainAccountDescriptions[0] = JournalingsTermEnum.getValue(30);
                this.mainAccountDescriptions[1] = JournalingsTermEnum.getValue(20);
                this.mainAccountDescriptions[2] = JournalingsTermEnum.getValue(80);
                this.mainAccountDescriptions[3] = JournalingsTermEnum.getValue(70);
                break;
            }
            case 4: {
                this.mainAccountDescriptions[0] = TranslationHelperImpl.getInstance().translate("Label.MainAccount");
                this.mainAccountDescriptions[1] = "";
                this.mainAccountDescriptions[2] = "";
                this.mainAccountDescriptions[3] = JournalingsTermEnum.getValue(40);
                break;
            }
            case 5: {
                this.mainAccountDescriptions[0] = JournalingsTermEnum.getValue(110);
                this.mainAccountDescriptions[1] = JournalingsTermEnum.getValue(100);
                this.mainAccountDescriptions[2] = JournalingsTermEnum.getValue(80);
                this.mainAccountDescriptions[3] = JournalingsTermEnum.getValue(70);
            }
        }
    }

    private void addCreationFieldGroup() throws Exception {
        this.fg = new FieldGroup();
        DateSelectionField dsField = new DateSelectionField("Label.CreationDate");
        dsField.setLength(10);
        dsField.setReadonly(true);
        dsField.setValue(this.transaction.getCreationDate());
        this.fg.add((Field)dsField);
        this.field = new Field("Label.User");
        this.field.setLength(10);
        this.field.setReadonly(true);
        this.field.setValue(this.transaction.getCreatedByUser());
        this.fg.add(this.field);
        if (this.transaction.getRevCode() > 0) {
            String label = this.transaction.getRevCode() == 2 ? "Label.ReversedBy" : "Label.IsReversionOf";
            this.field = new Field(label, "text", null, "" + this.transaction.getRevDocumentNr() + "/" + this.transaction.getRevSeqNr(), 10);
            this.field.setReadonly(true);
            this.fg.add(this.field);
        }
        this.panel.addUIObject((UIObject)this.fg);
    }

    private void addCommonFieldGroup() throws Exception {
        this.fg = new FieldGroup();
        this.fg.forceBorder(true);
        this.field = this.transaction.getMainTransactionType() == 4 && this.transaction.getTransactionType() != 120 ? new Field("Label.MainTransactionType", "text", null, MainTransactionTypeEnum.getValue(this.transaction.getMainTransactionType()), 50) : new Field("Label.TransactionType", "text", null, TransactionTypeEnum.getValue(this.transaction.getTransactionType()), 50);
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.field = new Field("Label.Description", "text", null, this.transaction.getDescription(), 50);
        this.field.setReadonly(true);
        this.fg.add(this.field);
        if (this.transaction.getReasonCode() > 0) {
            this.field = new Field("Label.ReasonCode", "text", null, ReasonCodeEnum.getValue(this.transaction.getReasonCode()), 50);
            this.field.setReadonly(true);
            this.fg.add(this.field);
        }
        if (this.transaction.getDisinvestmentReasonCode() > 0) {
            this.field = new Field("Label.DisinvestmentReason", "text", null, DisinvestmentReasonCodeEnum.getValue(this.transaction.getDisinvestmentReasonCode(), this.env), 50);
            this.field.setReadonly(true);
            this.fg.add(this.field);
        }
        if (this.transaction.getBookYear() > 0) {
            this.field = new Field("Label.StartPeriod", "text", null, PeriodHelper.toString(this.transaction.getBookYear(), this.transaction.getPeriod()), 10);
            this.field.setReadonly(true);
            this.fg.add(this.field);
        }
        if (this.transaction.getBookYearForJournalization() > 0 && (this.transaction.getBookYearForJournalization() != this.transaction.getBookYear() || this.transaction.getPeriodForJournalization() != this.transaction.getPeriod())) {
            this.field = new Field("Label.FinancialPeriod", "text", null, PeriodHelper.toString(this.transaction.getBookYearForJournalization(), this.transaction.getPeriodForJournalization()), 10);
            this.field.setReadonly(true);
            this.fg.add(this.field);
        }
        if (this.transaction.getBatchId() > 0) {
            this.field = new Field("Label.BatchId", "text", null, "" + this.transaction.getBatchId(), 10);
            this.field.setReadonly(true);
            this.fg.add(this.field);
        }
        this.panel.addUIObject((UIObject)this.fg);
    }

    private void addValuationAttributeFieldGroup(String fgHeader, boolean before) throws Exception {
        BigDecimal value;
        BigDecimal percentage;
        int depreciatableLife;
        BigDecimal hundred = new BigDecimal("100");
        if (before) {
            depreciatableLife = Integer.parseInt(this.transaction.getDaybookId().trim());
            percentage = new BigDecimal("" + Integer.parseInt(this.transaction.getMainAccount1().trim())).divide(hundred, 2, 6);
            value = new BigDecimal("" + Integer.parseInt(this.transaction.getMainAccount3().trim())).divide(hundred, 2, 6);
        } else {
            depreciatableLife = Integer.parseInt(this.transaction.getVoucherId().trim());
            percentage = new BigDecimal("" + Integer.parseInt(this.transaction.getMainAccount2().trim())).divide(hundred, 2, 6);
            value = new BigDecimal("" + Integer.parseInt(this.transaction.getMainAccount4().trim())).divide(hundred, 2, 6);
        }
        this.fg = new FieldGroup(fgHeader);
        this.field = new Field("Label.DepreciationLife", "text", null, "" + depreciatableLife, 10);
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.field = new Field("Label.ResidualValuePercentage", "decimal", null, (String)DECIMALTRANSFORMER.transform(percentage), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.field = new Field("Label.ResidualValueAmount", "decimal", null, (String)DECIMALTRANSFORMER.transform(value), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.panel.addUIObject((UIObject)this.fg);
    }

    private void addTypeAttributeFieldGroup(String fgHeader, boolean before) throws Exception {
        String typeId;
        if (before) {
            typeId = this.transaction.getMainAccount1() + this.transaction.getMainAccount2();
            typeId = typeId.trim();
        } else {
            typeId = this.transaction.getProFormaTypeId();
        }
        this.fg = new FieldGroup(fgHeader);
        ReferenceField field = new ReferenceField("Label.Type");
        field.setReadonly(true);
        field.setValue(typeId);
        Object[] result = AssetTypeBO.get(this.dbData, this.companyId, typeId);
        AssetType assetType = (AssetType)result[0];
        if (assetType != null) {
            field.setDescription(assetType.getDescription());
        }
        this.fg.add((Field)field);
        this.panel.addUIObject((UIObject)this.fg);
    }

    private void addDimensionFieldGroup(String fgHeader, Transaction baseTransaction) throws Exception {
        this.fg = new FieldGroup(fgHeader);
        this.fg.forceBorder(true);
        boolean transactionHasFinDims = false;
        for (int i = 0; i < this.finTexts.length; ++i) {
            if (this.finTexts[i].length() == 0) continue;
            FinancialReferenceField frf = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company.getId(), "" + this.company.getCurrentBookYear(), false) : new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, false);
            String value = null;
            switch (i) {
                case 0: {
                    value = baseTransaction.getFinDimId1();
                    break;
                }
                case 1: {
                    value = baseTransaction.getFinDimId2();
                    break;
                }
                case 2: {
                    value = baseTransaction.getFinDimId3();
                    break;
                }
                case 3: {
                    value = baseTransaction.getFinDimId4();
                    break;
                }
                case 4: {
                    value = baseTransaction.getFinDimId5();
                }
            }
            if ("".equals(value)) continue;
            transactionHasFinDims = true;
            frf.setValue(value);
            frf.setReadonly(true);
            this.fg.add((Field)frf);
        }
        if (transactionHasFinDims) {
            this.panel.addUIObject((UIObject)this.fg);
        }
    }

    private void addAmountsForInvestment() throws Exception {
        this.fg = new FieldGroup();
        this.field = new Field("Label.AcquisitionValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount1()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        if (this.transaction.getAmount2().doubleValue() != 0.0) {
            this.field = new Field("Label.AggregatedDepreciation.short", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount2()), 15);
            this.field.setType("decimal");
            this.field.setReadonly(true);
            this.fg.add(this.field);
        }
        this.panel.addUIObject((UIObject)this.fg);
    }

    private void addAggregatedAmounts() throws Exception {
        this.fg = new FieldGroup();
        this.field = new Field("Label.AcquisitionValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount1()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.field = new Field("Label.AggregatedDepreciation.short", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount2()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.field = new Field("Label.InterestCosts", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount3()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.panel.addUIObject((UIObject)this.fg);
    }

    private void addAmountsForDisinvestment() throws Exception {
        this.fg = new FieldGroup();
        this.field = new Field("Label.AcquisitionValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount1()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.field = new Field("Label.AggregatedDepreciation.short", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount2()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        if (this.transaction.getTransactionType() == 30 || this.transaction.getTransactionType() == 130) {
            this.field = new Field("Label.YieldValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount3()), 15);
            this.field.setType("decimal");
            this.field.setReadonly(true);
            this.fg.add(this.field);
            BigDecimal result = new BigDecimal("0").subtract(this.transaction.getAmount1()).add(this.transaction.getAmount2().subtract(this.transaction.getAmount3()));
            this.field = new Field("Label.Result", "decimal", null, (String)DECIMALTRANSFORMER.transform(result), 15);
            this.field.setType("decimal");
            this.field.setReadonly(true);
            this.fg.add(this.field);
        }
        this.panel.addUIObject((UIObject)this.fg);
    }

    private void addAmountsForDepreciationAndInterest() throws Exception {
        this.fg = new FieldGroup();
        this.field = new Field("Label.DepreciationCosts", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount2()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.field = new Field("Label.InterestCosts", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount3()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.panel.addUIObject((UIObject)this.fg);
    }

    private void addAmountsForLedgerCorrection() throws Exception {
        this.fg = new FieldGroup();
        this.field = new Field("Label.Amount", "decimal", null, (String)DECIMALTRANSFORMER.transform(this.transaction.getAmount1()), 15);
        this.field.setType("decimal");
        this.field.setReadonly(true);
        this.fg.add(this.field);
        this.panel.addUIObject((UIObject)this.fg);
    }

    public DataObject showBookings(DataObject object) throws Exception {
        Window window = new Window();
        window.setTop("10%");
        window.setRight("1%");
        window.setLabel(this.translate("Label.VoucherId") + " " + this.transaction.getVoucherId());
        int year = this.transactionBatch.getEndYear();
        if (this.transactionBatch.getFinYear() > 0) {
            year = this.transactionBatch.getFinYear();
        }
        APITable table = this.env.getOperationArea().length() == 0 ? new FISBookingsTable(this.loginHelper, this.transactionBatch.getCompanyId(), year, this.transactionBatch.getFinancialBatchId(), this.transaction.getVoucherId()) : new FMSBookingsTable(this.loginHelper, this.transactionBatch.getCompanyId(), year, this.transaction.getDaybookId(), this.transaction.getVoucherId());
        table.setName("BookingsTable");
        table.reloadPage();
        window.add((Table)table);
        object.addUIObject((UIObject)window);
        return object;
    }
}

