/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionImageTransformer;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.TransactionStateImageTransformer;
import nl.ibs.fac.adapters.TransactionTypeTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.queries.TransactionQuery;

public class TransactionAggregationInfoAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -2177238138672381881L;
    public static final String PAGE = TransactionAggregationInfoAdapter.class.getName();
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"FACYearAndPeriod", "transactionType", "valueForAmount1", "valueForAmount2", "valueForAmount3", "description", "documentAndSequenceNumber", "state", "incomingFinancialTransaction"};
    private static final String[] LABELS = new String[]{"Label.Period", "Label.TransactionType", "Label.Acquisition", "Label.Depreciation", "Label.Interest", "Label.Description", "Label.TransNbrShort", "Label.State", "Label.IncomingFinancialTransaction"};
    private static final String[] TOOLTIPS = new String[]{"Label.State", "Label.IncomingFinancialTransaction"};
    private static final short[] SIZES = new short[]{80, 150, 120, 120, 120, 200, 100, 20, 20};
    private static final String[] TYPES = new String[]{null, "text", null, null, null, null, null, null};
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static final Transformer[] TRANSFORMERS = new Transformer[]{null, new TransactionTypeTransformer(), DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, null, null, new TransactionStateImageTransformer(), new IncomingFinancialTransactionImageTransformer()};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final boolean[] SORTABLE = new boolean[]{false, true, false, false, false, true, false, true, true};
    private static final String[] SEARCH_NAMES = new String[]{"bookYear", "transactionType", "description", "documentNr"};
    private static final String[] SEARCH_LABELS = new String[]{"Label.Year", "Label.TransactionType", "Label.Description", "Label.Transaction"};
    private static final int NUMBEROFTABLEROWS = 15;
    private Action[] rowActions;
    private Action[] headerActions;
    private Transaction transaction;

    public TransactionAggregationInfoAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details};
    }

    public DataObject show(DataObject object) throws Exception {
        this.transaction = (Transaction)TableHelper.getSelectedItem((DataObject)object);
        Window window = new Window();
        window.setTop("15%");
        window.setWidth(720);
        window.setLabel(object.translate("Title.AggregatedTransactions", object.getLocale()) + " " + this.transaction.getBookYear());
        window.add((Table)this.createTable(object));
        object.addUIObject((UIObject)window);
        return object;
    }

    private ODBTable createTable(DataObject object) throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.transaction.getAsset(), this.transaction.getAccountingPrinciple(), this.transaction.getDocumentNr());
        ODBTable table = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"bookYear", "period", "documentNr", "seqNr"}, 15);
        table.setName(PAGE);
        table.setCounter((ODBCounter)query);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.setColumnSizes(SIZES);
        table.setColumnTypes(TYPES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.setColumnNoWraps(COLUMNNOWRAPS);
        table.setColumnSortable(SORTABLE);
        table.setSortable(true);
        table.setSelectable(false);
        TableHelper.createMenu((Table)table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = table.createSearch(SEARCH_NAMES, SEARCH_LABELS);
        Action filterAction = table.createFilterAction(SEARCH_NAMES, SEARCH_LABELS, 3);
        this.searchPanel.addAction(filterAction);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }
}

