/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.DateField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.TransactionBatchCodeEnum;
import nl.ibs.fac.TransactionBatchStateEnum;
import nl.ibs.fac.adapters.BatchCodeTransformer;
import nl.ibs.fac.adapters.BatchStateTransformer;
import nl.ibs.fac.adapters.DepreciationProposalReportAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.TransactionBatchReportAdapter;
import nl.ibs.fac.adapters.TransactionBatchTransactionAdapter;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.commands.CompanyCurrentBatchCreateCommand;
import nl.ibs.fac.commands.TransactionBatchBookCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.queries.TransactionBatchQuery;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.util.Scrambler;

public class TransactionBatchAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 4098454908068146102L;
    public static final String PAGE = TransactionBatchAdapter.class.getName();
    private static final String SHOWINFO = "showInfo";
    private Company company;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"batchId", "batchCode", "state", "endYear", "endPeriod", "originatingFACBatchId"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Type", "Label.State", "Label.Year", "Label.Period", "Label.OriginatingId"};
    private static final short[] SIZES = new short[]{100, 200, 140, 60, 60, 120};
    private static final String[] TYPES = new String[]{null, "text", "text", null, null, null, null};
    private static final Transformer[] TRANSFORMERS = new Transformer[]{null, new BatchCodeTransformer(), new BatchStateTransformer(), new ZeroIntegerToBlankTransformer(), new ZeroIntegerToBlankTransformer(), new ZeroIntegerToBlankTransformer()};
    private Map<String, ComboBox> inputComponents = new HashMap<String, ComboBox>();
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbAgain = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    public static final String TRANSACTIONBATCH = "TransactionBatch";
    private TransactionBatch transactionBatch;
    private FieldGroup fgHeader;
    private String title;
    private CheckBox refreshMainAccounts = new CheckBox("Label.RefreshMainAccounts");
    private String[][] theSelections;
    private static final String TITLE = "Title.CreateFinancialTransactions";
    private static final String WINDOWWIDTH = "410";
    private static final String PREPROCESSOR = CompanyCurrentBatchCreateCommand.CLASSNAME;
    private static final String JOBNAME = "Job.BookTransactionBatch";
    private static final String CLASSNAME = TransactionBatchBookCommand.CLASSNAME;

    public TransactionBatchAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.refreshMainAccounts.setAction((Action)new ChangeAction());
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        this.fbShow.addAction(refresh);
        Action report = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("report");
        this.fbShow.addAction(report);
        Action submit = new Action("Button.Submit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("submit");
        this.fbShow.addAction(submit);
        Action info = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SHOWINFO);
        this.fbShow.addAction(info);
        this.fbShow.addAction(this.finish);
        this.headerActions = new Action[]{refresh};
        Action transactions = new Action("Button.Transactions").setAdapter(this.getProcessAdapterPageName(TransactionBatchTransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{transactions, report, submit, info};
        ComboBox code = EnumHelper.createComboBox("Label.Type", TransactionBatchCodeEnum.getCollection(), true);
        code.setWidth("220");
        this.inputComponents.put("batchCode", code);
        ComboBox state = EnumHelper.createComboBox("Label.State", TransactionBatchStateEnum.getCollection(), true);
        state.setWidth("150");
        this.inputComponents.put("state", state);
        this.fbAgain.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("submit"));
        this.fbAgain.addAction(this.cancel);
        this.fbAgain.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.transactionBatch = null;
        this.getProcess().removeAttribute(TRANSACTIONBATCH);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.TransactionBatches", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        TransactionBatchQuery query = new TransactionBatchQuery(this.dbData, this.companyId);
        this.table = new ODBTable(TransactionBatch.class, (ODBQuery)query, new String[]{"batchId"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        this.table.setDescending(true);
        this.table.setSingleSelect(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerpanel");
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject submit(DataObject object) throws Exception {
        Object[] batches = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (batches.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        this.transactionBatch = (TransactionBatch)batches[0];
        if (TransactionBO.getFirstTransaction(this.transactionBatch) == null) {
            object.addUIObject((UIObject)new Message(LanguageHelper.getString("nl.ibs.fac.language", "batch_is_empty"), "error"));
            this.transactionBatch = null;
            return object;
        }
        if (this.transactionBatch.getState() == 0) {
            object.addUIObject((UIObject)new Message(TransactionBatchCodeEnum.getValue(this.transactionBatch.getBatchCode()) + " " + this.translate("ProcessingNotAllowed"), "error"));
            this.transactionBatch = null;
            return object;
        }
        this.title = TITLE;
        this.fgHeader = new FieldGroup();
        Field field = new Field("Label.BatchId", "text", null, "" + this.transactionBatch.getBatchId(), 10);
        field.setReadonly(true);
        this.fgHeader.add(field);
        field = new Field("Label.Type", "text", null, TransactionBatchCodeEnum.getValue(this.transactionBatch.getBatchCode()), 25);
        field.setReadonly(true);
        this.fgHeader.add(field);
        field = new Field("Label.State", "text", null, TransactionBatchStateEnum.getValue(this.transactionBatch.getState()), 25);
        field.setReadonly(true);
        this.fgHeader.add(field);
        if (this.transactionBatch.getEndYear() > 0) {
            field = new Field("Label.Period", "text", null, PeriodHelper.toString(this.transactionBatch.getEndYear(), this.transactionBatch.getEndPeriod()), 10);
            field.setReadonly(true);
            this.fgHeader.add(field);
        }
        this.fgHeader.add(this.refreshMainAccounts);
        this.refreshMainAccounts.setReadonly(true);
        this.refreshMainAccounts.setHidden(true);
        if (this.transactionBatch.getState() == 2) {
            this.title = "Title.TransactionBatchBookAgain";
            this.refreshMainAccounts.setReadonly(false);
            this.refreshMainAccounts.setHidden(false);
        }
        this.getProcess().removeAttribute("preprocessor");
        this.getProcess().removeAttribute("classNamePDF");
        this.getProcess().removeAttribute("classNameCSV");
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        Integer currentBatchId = this.company.getCurrentBatchId();
        if (currentBatchId != null && currentBatchId.intValue() == this.transactionBatch.getBatchId()) {
            this.getProcess().setAttribute("preprocessor", (Object)PREPROCESSOR);
        }
        String[][] selections = new String[][]{{"facLib", this.dbData.getSchema()}, {"System", this.loginHelper.getSystem()}, {"User", this.loginHelper.getUser()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"operationArea", this.env.getOperationArea().trim()}, {"dataLib", this.env.getDataLib().trim()}, {"programLib", this.env.getProgramLib().trim()}, {"object_lib", StartStopServlet.getObjectLibrary()}, {"Environment", this.env.getId()}, {"Company", this.companyId}, {"batchId", "" + this.transactionBatch.getBatchId()}, {"RefreshMainAccounts", "false"}};
        this.theSelections = selections;
        this.getProcess().setAttribute("title", (Object)this.title);
        this.getProcess().setAttribute("windowWidth", (Object)WINDOWWIDTH);
        this.getProcess().setAttribute("selections", (Object)this.theSelections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        this.getProcess().setAttribute("header", (Object)this.fgHeader);
        return object;
    }

    public DataObject showInfo(DataObject object) throws Exception {
        this.transactionBatch = (TransactionBatch)this.getProcess().getAttribute(TRANSACTIONBATCH);
        if (this.transactionBatch == null) {
            Object[] batches = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
            if (batches.length == 0) {
                object.addUIObject((UIObject)new Message("NothingSelected", "error"));
                return object;
            }
            if (batches.length > 1) {
                object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
                return object;
            }
            this.transactionBatch = (TransactionBatch)batches[0];
        }
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Label.Details");
        this.fgHeader = new FieldGroup();
        Field field = new Field("Label.BatchId", "text", null, "" + this.transactionBatch.getBatchId(), 10);
        field.setReadonly(true);
        this.fgHeader.add(field);
        window.add(this.fgHeader);
        FieldGroup fg = new FieldGroup("Label.Common");
        field = new Field("Label.Type", "text", null, TransactionBatchCodeEnum.getValue(this.transactionBatch.getBatchCode()), 25);
        field.setReadonly(true);
        fg.add(field);
        if (this.transactionBatch.getBatchCode() != 0) {
            if (this.transactionBatch.getCodeFiscal()) {
                field = new Field("Label.AccountingPrinciple", "text", null, this.env.getAPName1(), 25);
                field.setReadonly(true);
                fg.add(field);
            }
            if (this.transactionBatch.getCodeAccountingPrinciple2()) {
                field = new Field("Label.AccountingPrinciple", "text", null, this.env.getAPName2(), 25);
                field.setReadonly(true);
                fg.add(field);
            }
        }
        field = new Field("Label.State", "text", null, TransactionBatchStateEnum.getValue(this.transactionBatch.getState()), 25);
        field.setReadonly(true);
        fg.add(field);
        if (this.transactionBatch.getEndYear() > 0) {
            field = new Field("Label.Period", "text", null, PeriodHelper.toString(this.transactionBatch.getEndYear(), this.transactionBatch.getEndPeriod()), 10);
            field.setReadonly(true);
            fg.add(field);
        }
        if (this.transactionBatch.getOriginatingFACBatchId() != 0) {
            field = new Field("Label.OriginatingId", "text", null, "" + this.transactionBatch.getOriginatingFACBatchId(), 10);
            field.setReadonly(true);
            fg.add(field);
        }
        field = new DateField("Label.CreationDate");
        ((DateField)field).setValue(this.transactionBatch.getCreationDate());
        field.setReadonly(true);
        fg.add(field);
        field = new Field("Label.User", "text", null, this.transactionBatch.getCreatedBy(), 10);
        field.setReadonly(true);
        fg.add(field);
        if (this.transactionBatch.getBatchCode() == 3) {
            window.add(fg);
            fg = MassTransactionPanel.getExtraBatchDetails(this.transactionBatch, true);
        }
        if (this.transactionBatch.getProcessingDate() != null) {
            window.add(fg);
            fg = new FieldGroup("Label.Processing");
            field = new DateField("Label.ProcessingDate");
            ((DateField)field).setValue(this.transactionBatch.getProcessingDate());
            field.setReadonly(true);
            fg.add(field);
            field = new Field("Label.User", "text", null, this.transactionBatch.getProcessedBy(), 10);
            field.setReadonly(true);
            fg.add(field);
        }
        if (this.transactionBatch.getMemberNameFIS().length() > 0) {
            field = new Field("Label.MemberNameFIS", "text", null, "" + this.transactionBatch.getMemberNameFIS(), 10);
            field.setReadonly(true);
            fg.add(field);
        }
        if (this.transactionBatch.getFinancialBatchId() != 0) {
            field = new Field("Label.FinancialBatchId", "text", null, "" + this.transactionBatch.getFinancialBatchId(), 10);
            field.setReadonly(true);
            fg.add(field);
        }
        if (this.transactionBatch.getMemberNameFIS().length() > 0 && this.transactionBatch.getVoucherDate() != null) {
            field = new Field("Label.VoucherId", "text", null, "" + this.transactionBatch.getVoucherId(), 10);
            field.setReadonly(true);
            fg.add(field);
            field = new DateField("Label.VoucherDate");
            ((DateField)field).setValue(this.transactionBatch.getVoucherDate());
            field.setReadonly(true);
            fg.add(field);
        }
        window.add(fg);
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject report(DataObject object) throws Exception {
        Object[] batches = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (batches.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        if (batches.length > 1) {
            object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
            return object;
        }
        this.transactionBatch = (TransactionBatch)batches[0];
        if (TransactionBO.getFirstTransaction(this.transactionBatch) == null) {
            object.addUIObject((UIObject)new Message(LanguageHelper.getString("nl.ibs.fac.language", "batch_is_empty"), "error"));
            this.transactionBatch = null;
            return object;
        }
        if (this.transactionBatch.getState() == 0 && this.transactionBatch.getBatchCode() != 0) {
            object.addUIObject((UIObject)new Message(TransactionBatchCodeEnum.getValue(this.transactionBatch.getBatchCode()) + " " + this.translate("ReportingNotAllowed"), "error"));
            this.transactionBatch = null;
            return object;
        }
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        if (this.transactionBatch.getBatchCode() == 0 || this.transactionBatch.getBatchCode() == 3) {
            this.getProcess().setAttribute("tbBackPage", (Object)PAGE);
            this.getProcess().setAttribute("batch", batches[0]);
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(TransactionBatchReportAdapter.PAGE), "show", this.getProcess().getProcessId()));
        }
        if (this.transactionBatch.getBatchCode() == 1) {
            this.getProcess().setAttribute("dpBackPage", (Object)PAGE);
            this.getProcess().setAttribute("batch", batches[0]);
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(DepreciationProposalReportAdapter.PAGE), "show", this.getProcess().getProcessId()));
        }
        this.getProcess().removeAttribute("header");
        this.getProcess().removeAttribute("preprocessor");
        this.getProcess().removeAttribute("className");
        return object;
    }

    private class ChangeAction
    extends Action {
        private static final long serialVersionUID = -778571324984948955L;

        private ChangeAction() {
        }

        public boolean execute(DataObject object) throws Exception {
            ((TransactionBatchAdapter)TransactionBatchAdapter.this).theSelections[11][1] = "" + TransactionBatchAdapter.this.refreshMainAccounts.getValueAsBoolean();
            return true;
        }
    }
}

