/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.fac.adapters.EnvironmentReferenceField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.UserGroupReferenceField;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.UserBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.User;
import nl.ibs.fac.queries.UserQuery;

public class UserAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -4957774808429095445L;
    public static final String PAGE = UserAdapter.class.getName();
    public static final String REFRESH = "refresh";
    private static final String CREATEFORM = "createForm";
    private static final String CREATE = "create";
    private static final String EDITFORM = "editForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"id", "description", "userGroup.description", "admin"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.UserGroup", "Label.Administrator"};
    private static final short[] SIZES = new short[]{140, 400, 200, 80};
    private Map<String, UserGroupReferenceField> inputComponents = new HashMap<String, UserGroupReferenceField>();
    protected Action[] rowActions;
    protected Action[] headerActions;
    private Panel header = new HeaderPanel();
    private FieldGroup group = new FieldGroup();
    private Field id = new Field("Label.Id", "upper");
    private Field desc = new Field("Label.Description");
    private UserGroupReferenceField userGroupReferenceField = new UserGroupReferenceField();
    private CheckBox admin = new CheckBox("Label.Administrator");
    private CheckBox oneEnvironment = new CheckBox("Label.OneEnvironment");
    private CheckBox checkCurrentBatchHasTransactions = new CheckBox("Label.CheckCurrentTransactionBatchHasTransctions");
    private OneEnvironmentChangeAction oneEnvironmentChangeAction = new OneEnvironmentChangeAction();
    private EnvironmentReferenceField environmentReferenceField = new EnvironmentReferenceField();
    private CheckBox selectCompany = new CheckBox("Label.SelectCompany");
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private User user;
    private Object[] users;

    public UserAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.rowActions = new Action[]{edit, confirmDelete};
        this.headerActions = new Action[]{refresh, create};
        this.id.setMandatory(true);
        this.id.setLength(10);
        this.id.setMaxLength(10);
        this.id.setHelpId("Label.UserId");
        this.header.addUIObject((UIObject)this.id);
        this.desc.setLength(50);
        this.desc.setMaxLength(50);
        this.group.add(this.desc);
        this.userGroupReferenceField.setMandatory(true);
        this.group.add((Field)this.userGroupReferenceField);
        this.group.add(this.admin);
        this.oneEnvironment.setAction((Action)this.oneEnvironmentChangeAction);
        this.group.add(this.oneEnvironment);
        this.group.add((Field)this.environmentReferenceField);
        this.group.add(this.selectCompany);
        this.group.add(this.checkCurrentBatchHasTransactions);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK.setValidationEnabled(true);
        createOK.setDefault(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        this.fbCreate.addAction(this.finish);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        this.inputComponents.put("userGroupId", new UserGroupReferenceField());
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.Users", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        UserQuery query = new UserQuery();
        this.table = new ODBTable(User.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setIgnoreContext(Boolean.TRUE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        this.table.setMultipleSelect(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerpanel");
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateUser", "screen_name"));
        this.id.setValue();
        this.id.setReadonly(false);
        this.desc.setHidden(true);
        this.userGroupReferenceField.setValue(null);
        this.admin.setValue(false);
        this.oneEnvironment.setValue(false);
        this.oneEnvironmentChangeAction.execute(object);
        this.environmentReferenceField.setValue(null);
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        String[] strings = this.loginHelper.getUserDescription(this.id.getValue());
        if (strings[1] != null) {
            this.id.setInvalidTag();
            String message = strings[1];
            if (message.startsWith("CPF9801")) {
                message = "user_not_found_on_systeem";
            }
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        Object[] result = UserBO.create(this.id.getValue().trim(), strings[0], this.userGroupReferenceField.getValue(), this.admin.getValueAsBoolean(), this.oneEnvironment.getValueAsBoolean(), this.environmentReferenceField.getEnvironment(), this.selectCompany.getValueAsBoolean(), this.checkCurrentBatchHasTransactions.getValueAsBoolean());
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.createForm(object);
        }
        this.table.setPointer("id", (Object)this.id.getValue().trim(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditUser", "screen_name"));
        this.user = (User)TableHelper.getSelectedItem((DataObject)object);
        this.id.setValue(this.user.getId());
        this.id.setReadonly(true);
        this.desc.setValue(this.user.getDescription());
        this.desc.setHidden(false);
        this.userGroupReferenceField.setValue(this.user.getUserGroupId());
        this.admin.setValue(this.user.getAdmin());
        this.oneEnvironment.setValue(this.user.getOneEnvironment());
        this.oneEnvironmentChangeAction.execute(object);
        this.environmentReferenceField.setValue((Environment)EnvironmentBO.get(this.user.getFacLib())[0]);
        this.selectCompany.setValue(this.user.getSelectCompany());
        this.checkCurrentBatchHasTransactions.setValue(this.user.getCheckCurrentTransactionBatchHasTransactions());
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = UserBO.update(this.user, this.desc.getValue().trim(), this.userGroupReferenceField.getUserGroup(), this.admin.getValueAsBoolean(), this.oneEnvironment.getValueAsBoolean(), this.environmentReferenceField.getEnvironment(), this.selectCompany.getValueAsBoolean(), this.checkCurrentBatchHasTransactions.getValueAsBoolean());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.id.getValue().trim(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.users = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteUsers", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.users.length);
        for (int i = 0; i < this.users.length; ++i) {
            list.add(this.users[i]);
        }
        CollectionTable table = new CollectionTable(User.class, list, 12);
        table.setName(PAGE);
        table.setIgnoreContext(Boolean.TRUE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        for (int i = 0; i < this.users.length; ++i) {
            User user = (User)this.users[i];
            if (user == null || (message = UserBO.delete(user)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    private class OneEnvironmentChangeAction
    extends Action {
        private static final long serialVersionUID = 8890569228923671316L;

        private OneEnvironmentChangeAction() {
        }

        public boolean execute(DataObject dataObject) throws Exception {
            if (!UserAdapter.this.oneEnvironment.getValueAsBoolean()) {
                UserAdapter.this.environmentReferenceField.setHidden(true);
                UserAdapter.this.environmentReferenceField.setMandatory(false);
            } else {
                UserAdapter.this.environmentReferenceField.setHidden(false);
                UserAdapter.this.environmentReferenceField.setMandatory(true);
            }
            return true;
        }
    }
}

