/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.SpooledFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.BinaryObject;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Dialog;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.DateTransformer;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.BatchJob;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.util.AS400Enhanced;
import nl.ibs.util.SpooledFileConverter;
import nl.ibs.util.SpooledFileInfo;

public class WorkManagementAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -647905965152902139L;
    public static final String PAGE = WorkManagementAdapter.class.getName();
    private FloatBar fbShow1 = new FloatBar();
    private FloatBar fbHold1 = new FloatBar();
    private FloatBar fbRelease1 = new FloatBar();
    private FloatBar fbDelete1 = new FloatBar();
    private Action[] rowActions1;
    private Action[] headerActions1;
    private CollectionTable table1 = null;
    private CommonTable.SearchPanel searchPanel1;
    private static final String[] NAMES1 = new String[]{"number", "name", "className", "company", "jobDate", "jobTime", "scheduleDate", "scheduleTime", "status", "statusInJobQueue", "completionStatus"};
    private static final String[] LABELS1 = new String[]{"Label.Number", "Label.Name", "Label.JobDescription", "Label.Company", "Label.JobDate", "Label.JobTime", "Label.ScheduleDate", "Label.ScheduleTime", "Label.Status", "Label.QueueStatus", "Label.CompletionStatus"};
    private static final short[] SIZES1 = new short[]{60, 90, 200, 80, 75, 70, 80, 80, 65, 65, 70};
    private static final Transformer[] TRANSFORMERS1 = new Transformer[]{null, null, null, null, new DateTransformer(), null, new DateTransformer(), null, null, null, null};
    private Object[] jobs;
    private LoginHelper loginHelper;
    private FloatBar fbShow2 = new FloatBar();
    private FloatBar fbDelete2 = new FloatBar();
    private Action[] rowActions2;
    private Action[] headerActions2;
    private CollectionTable table2 = null;
    private CommonTable.SearchPanel searchPanel2;
    private static final String[] NAMES2 = new String[]{"text"};
    private static final String[] LABELS2 = new String[]{"Label.Message"};
    private static final short[] SIZES2 = new short[]{600};
    private MessageQueue messageQueue;
    private Object[] messages;
    private Dialog confirm2;
    private FloatBar fbShow3 = new FloatBar();
    private FloatBar fbDelete3 = new FloatBar();
    private Action[] rowActions3;
    private Action[] headerActions3;
    private CollectionTable table3 = null;
    private CommonTable.SearchPanel searchPanel3;
    private static final String[] NAMES3 = new String[]{"spoolfileName", "jobName", "jobNumber", "date", "time", "pages", "size"};
    private static final String[] LABELS3 = new String[]{"Label.Name", "Label.JobName", "Label.Number", "Label.Date", "Label.Time", "Label.Pages", "Label.Size"};
    private static final short[] SIZES3 = new short[]{90, 90, 60, 80, 70, 60, 60};
    private static final Transformer[] TRANSFORMERS3 = new Transformer[]{null, null, null, new DateTransformer(), null, null, null};
    private Object[] spooledFiles;
    private Dialog confirm3;
    private static final int NUMBER_OF_PAGES = 2;
    private TabbedPanel panel;
    private String activeTabName;
    private FloatBar fbShow = new FloatBar();

    public WorkManagementAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.fbShow.addAction(this.finish);
        this.loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh1");
        Action confirmHold = new Action("Button.Hold").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmHold1");
        Action confirmRelease = new Action("Button.Release").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmRelease");
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete1");
        this.fbShow1.addAction(refresh);
        this.fbShow1.addAction(confirmHold);
        this.fbShow1.addAction(confirmRelease);
        this.fbShow1.addAction(confirmDelete);
        this.rowActions1 = new Action[]{confirmHold, confirmRelease, confirmDelete};
        this.headerActions1 = new Action[]{refresh};
        this.fbHold1.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("hold1"));
        this.fbHold1.addAction(this.back);
        this.fbRelease1.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("release1"));
        this.fbRelease1.addAction(this.back);
        this.fbDelete1.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete1"));
        this.fbDelete1.addAction(this.back);
        refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh2");
        confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete2");
        Action deleteAll = new Action("Button.DeleteAll").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDeleteAll2");
        this.fbShow2.addAction(refresh);
        this.fbShow2.addAction(confirmDelete);
        this.fbShow2.addAction(deleteAll);
        this.rowActions2 = new Action[]{confirmDelete};
        this.headerActions2 = new Action[]{refresh, deleteAll};
        this.fbDelete2.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete2"));
        this.fbDelete2.addAction(this.back);
        refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh3");
        Action download = new Action("Button.Download").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("download3");
        download.setIsDownloadAction(true);
        Action downloadLastPages = new Action("Button.DownloadLastPages").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("downloadLastPages3");
        downloadLastPages.setIsDownloadAction(true);
        confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete3");
        deleteAll = new Action("Button.DeleteAll").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDeleteAll3");
        this.fbShow3.addAction(refresh);
        this.fbShow3.addAction(download);
        this.fbShow3.addAction(downloadLastPages);
        this.fbShow3.addAction(confirmDelete);
        this.fbShow3.addAction(deleteAll);
        this.rowActions3 = new Action[]{download, downloadLastPages, confirmDelete};
        this.headerActions3 = new Action[]{refresh, deleteAll};
        this.fbDelete3.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete3"));
        this.fbDelete3.addAction(this.back);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.panel != null) {
            this.activeTabName = this.panel.getActiveTabName();
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.WorkManagement", "screen_name"));
        this.panel = new TabbedPanel();
        Tab tab = new Tab("Label.Jobs");
        this.panel.add(tab);
        if (this.table1 == null) {
            this.createTable1();
        } else {
            this.table1.undoSelections();
        }
        tab.add((Panel)this.searchPanel1);
        tab.add((Table)this.table1);
        tab.add(this.fbShow1);
        tab = new Tab("Label.Messages");
        this.panel.add(tab);
        if (this.table2 == null) {
            this.createTable2();
        } else {
            this.table2.undoSelections();
        }
        tab.add((Panel)this.searchPanel2);
        tab.add((Table)this.table2);
        tab.add(this.fbShow2);
        tab = new Tab("Label.SpooledFiles");
        this.panel.add(tab);
        if (this.table3 == null) {
            this.createTable3();
        } else {
            this.table3.undoSelections();
        }
        tab.add((Panel)this.searchPanel3);
        tab.add((Table)this.table3);
        tab.add(this.fbShow3);
        if (this.activeTabName != null) {
            this.panel.setActiveTabByName(this.activeTabName);
        }
        object.addUIObject((UIObject)this.panel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable1() throws Exception {
        this.table1 = new CollectionTable(BatchJob.class, (Collection)BatchJobHelper.getBatchJobs(this.loginHelper), 12);
        this.table1.setName("Jobs");
        this.table1.setIgnoreContext(Boolean.TRUE);
        this.table1.setColumnNames(NAMES1);
        this.table1.setColumnLabels(LABELS1);
        this.table1.orderByColumn(NAMES1[0]);
        this.table1.setDescending(true);
        this.table1.setColumnSizes(SIZES1);
        this.table1.setDisplayTransformers(TRANSFORMERS1);
        this.table1.setSortable(true);
        this.table1.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table1, (Action[])this.headerActions1, (Action[])this.rowActions1);
        this.table1.setRowAction(null);
        this.searchPanel1 = this.table1.createSearch(NAMES1, LABELS1);
        this.searchPanel1.setCSSClass("headerpanel");
        this.searchPanel1.setWidth(980);
        this.table1.setWidth(980);
        this.table1.reload();
    }

    public DataObject refresh1(DataObject object) throws Exception {
        this.table1 = null;
        return this.show(object);
    }

    public DataObject confirmHold1(DataObject object) throws Exception {
        this.jobs = TableHelper.getSelectedItems((AbstractTable)this.table1, (DataObject)object);
        Window window = new Window();
        window.setLabel("Title.HoldJobs");
        window.add((Table)this.createConfirmationTable1());
        FieldGroup fgHold = new FieldGroup();
        fgHold.add(this.fbHold1);
        window.add(fgHold);
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject confirmRelease(DataObject object) throws Exception {
        this.jobs = TableHelper.getSelectedItems((AbstractTable)this.table1, (DataObject)object);
        Window window = new Window();
        window.setLabel("Title.ReleaseJobs");
        window.add((Table)this.createConfirmationTable1());
        FieldGroup fgRelease = new FieldGroup();
        fgRelease.add(this.fbRelease1);
        window.add(fgRelease);
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject confirmDelete1(DataObject object) throws Exception {
        this.jobs = TableHelper.getSelectedItems((AbstractTable)this.table1, (DataObject)object);
        Window window = new Window();
        window.setLabel("Title.DeleteJobs");
        window.add((Table)this.createConfirmationTable1());
        FieldGroup fgDelete = new FieldGroup();
        fgDelete.add(this.fbDelete1);
        window.add(fgDelete);
        object.addUIObject((UIObject)window);
        return object;
    }

    private CollectionTable createConfirmationTable1() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.jobs.length);
        for (int i = 0; i < this.jobs.length; ++i) {
            list.add(this.jobs[i]);
        }
        CollectionTable table = new CollectionTable(BatchJob.class, list, 12);
        table.setName("Jobs");
        table.setIgnoreContext(Boolean.TRUE);
        table.setColumnNames(NAMES1);
        table.setColumnLabels(LABELS1);
        table.orderByColumn(NAMES1[0]);
        table.setColumnSizes(SIZES1);
        table.setDisplayTransformers(TRANSFORMERS1);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject hold1(DataObject object) throws Exception {
        for (int i = 0; i < this.jobs.length; ++i) {
            String message;
            BatchJob batchJob = (BatchJob)this.jobs[i];
            if (batchJob == null || (message = BatchJobHelper.holdJob(this.loginHelper, batchJob)) == null) continue;
            object.addUIObject((UIObject)new Message(message));
        }
        return this.refresh1(object);
    }

    public DataObject release1(DataObject object) throws Exception {
        for (int i = 0; i < this.jobs.length; ++i) {
            String message;
            BatchJob batchJob = (BatchJob)this.jobs[i];
            if (batchJob == null || (message = BatchJobHelper.releaseJob(this.loginHelper, batchJob)) == null) continue;
            object.addUIObject((UIObject)new Message(message));
        }
        return this.refresh1(object);
    }

    public DataObject delete1(DataObject object) throws Exception {
        for (int i = 0; i < this.jobs.length; ++i) {
            String message;
            BatchJob batchJob = (BatchJob)this.jobs[i];
            if (batchJob == null || (message = BatchJobHelper.deleteJob(this.loginHelper, batchJob)) == null) continue;
            object.addUIObject((UIObject)new Message(message));
        }
        return this.refresh1(object);
    }

    private void createTable2() throws Exception {
        this.table2 = new CollectionTable(QueuedMessage.class, (Collection)this.getMessages(this.loginHelper), 12);
        this.table2.setName("Messages");
        this.table2.setIgnoreContext(Boolean.TRUE);
        this.table2.setColumnNames(NAMES2);
        this.table2.setColumnLabels(LABELS2);
        this.table2.orderByColumn(NAMES2[0]);
        this.table2.setColumnSizes(SIZES2);
        this.table2.setDescending(true);
        this.table2.setSortable(true);
        this.table2.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table2, (Action[])this.headerActions2, (Action[])this.rowActions2);
        this.table2.setRowAction(null);
        this.searchPanel2 = this.table2.createSearch(NAMES2, LABELS2);
        this.searchPanel2.setCSSClass("headerpanel");
        this.searchPanel2.setWidth(980);
        this.table2.setWidth(980);
        this.table2.reload();
    }

    private List getMessages(LoginHelper loginHelper) throws Exception {
        ArrayList<QueuedMessage> result = new ArrayList<QueuedMessage>();
        AS400Enhanced as400 = loginHelper.getAs400();
        this.messageQueue = new MessageQueue((AS400)as400, "/QSYS.LIB/QUSRSYS.LIB/" + loginHelper.getUser() + ".MSGQ");
        Enumeration jobs = this.messageQueue.getMessages();
        while (jobs.hasMoreElements()) {
            QueuedMessage queuedMessage = (QueuedMessage)jobs.nextElement();
            result.add(queuedMessage);
        }
        return result;
    }

    public DataObject refresh2(DataObject object) throws Exception {
        this.table2 = null;
        return this.show(object);
    }

    public DataObject confirmDeleteAll2(DataObject object) throws Exception {
        this.confirm2 = new Dialog(new Message("remove_all?", "confirm"), new Action("").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("deleteAll2"));
        object.addUIObject((UIObject)this.confirm2);
        return object;
    }

    public DataObject deleteAll2(DataObject object) throws Exception {
        object.getScreen().removeUIObject((UIObject)this.confirm2, false);
        if ("true".equals(object.getDialogAnswer())) {
            this.messageQueue.remove();
            return this.refresh2(object);
        }
        return object;
    }

    public DataObject confirmDelete2(DataObject object) throws Exception {
        this.messages = TableHelper.getSelectedItems((AbstractTable)this.table2, (DataObject)object);
        Window window = new Window();
        window.setLabel("Title.DeleteMessages");
        window.add((Table)this.createConfirmationTable2());
        FieldGroup fgDelete = new FieldGroup();
        fgDelete.add(this.fbDelete2);
        window.add(fgDelete);
        object.addUIObject((UIObject)window);
        return object;
    }

    private CollectionTable createConfirmationTable2() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.messages.length);
        for (int i = 0; i < this.messages.length; ++i) {
            list.add(this.messages[i]);
        }
        CollectionTable table = new CollectionTable(QueuedMessage.class, list, 12);
        table.setName("Messages");
        table.setIgnoreContext(Boolean.TRUE);
        table.setColumnNames(NAMES2);
        table.setColumnLabels(LABELS2);
        table.orderByColumn(NAMES2[0]);
        table.setColumnSizes(SIZES2);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete2(DataObject object) throws Exception {
        for (int i = 0; i < this.messages.length; ++i) {
            QueuedMessage queuedMessage = (QueuedMessage)this.messages[i];
            this.messageQueue.remove(queuedMessage.getKey());
        }
        return this.refresh2(object);
    }

    private void createTable3() throws Exception {
        this.table3 = new CollectionTable(SpooledFileInfo.class, SpooledFileConverter.getSpoolFileList((AS400)this.loginHelper.getAs400(), (String)this.loginHelper.getUser()), 12);
        this.table3.setName("SpooledFiles");
        this.table3.setIgnoreContext(Boolean.TRUE);
        this.table3.setColumnNames(NAMES3);
        this.table3.setColumnLabels(LABELS3);
        this.table3.setColumnSizes(SIZES3);
        this.table3.setDisplayTransformers(TRANSFORMERS3);
        this.table3.orderByColumn(NAMES3[2]);
        this.table3.setDescending(true);
        this.table3.setSortable(true);
        this.table3.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table3, (Action[])this.headerActions3, (Action[])this.rowActions3);
        this.searchPanel3 = this.table3.createSearch(NAMES3, LABELS3);
        this.searchPanel3.setCSSClass("headerpanel");
        this.searchPanel3.setWidth(980);
        this.table3.setWidth(980);
        this.table3.reload();
    }

    public DataObject refresh3(DataObject object) throws Exception {
        this.table3 = null;
        return this.show(object);
    }

    public DataObject confirmDeleteAll3(DataObject object) throws Exception {
        this.confirm3 = new Dialog(new Message("remove_all?", "confirm"), new Action("").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("deleteAll3"));
        object.addUIObject((UIObject)this.confirm3);
        return object;
    }

    public DataObject deleteAll3(DataObject object) throws Exception {
        object.getScreen().removeUIObject((UIObject)this.confirm3, false);
        if ("true".equals(object.getDialogAnswer())) {
            this.spooledFiles = SpooledFileConverter.getSpoolFileList((AS400)this.loginHelper.getAs400(), (String)this.loginHelper.getUser()).toArray();
            return this.delete3(object);
        }
        return object;
    }

    public DataObject confirmDelete3(DataObject object) throws Exception {
        this.spooledFiles = TableHelper.getSelectedItems((AbstractTable)this.table3, (DataObject)object);
        Window window = new Window();
        window.setLabel("Title.DeleteSpooledFiles");
        window.add((Table)this.createConfirmationTable3());
        FieldGroup fgDelete = new FieldGroup();
        fgDelete.add(this.fbDelete3);
        window.add(fgDelete);
        object.addUIObject((UIObject)window);
        return object;
    }

    private CollectionTable createConfirmationTable3() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.spooledFiles.length);
        for (int i = 0; i < this.spooledFiles.length; ++i) {
            list.add(this.spooledFiles[i]);
        }
        CollectionTable table = new CollectionTable(SpooledFileInfo.class, list, 12);
        table.setName("SpooledFiles");
        table.setIgnoreContext(Boolean.TRUE);
        table.setColumnNames(NAMES3);
        table.setColumnLabels(LABELS3);
        table.orderByColumn(NAMES3[2]);
        table.setColumnSizes(SIZES3);
        table.setDisplayTransformers(TRANSFORMERS3);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete3(DataObject object) throws Exception {
        for (int i = 0; i < this.spooledFiles.length; ++i) {
            SpooledFileInfo spooledFileInfo = (SpooledFileInfo)this.spooledFiles[i];
            spooledFileInfo.getSpooledFile().delete();
        }
        return this.refresh3(object);
    }

    public DataObject downloadLastPages3(DataObject object) throws Exception {
        Object[] spooledFiles = TableHelper.getSelectedItems((AbstractTable)this.table3, (DataObject)object);
        if (spooledFiles.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        if (spooledFiles.length > 1) {
            object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
            return object;
        }
        SpooledFileInfo spooledFileInfo = (SpooledFileInfo)spooledFiles[0];
        String type = "text/plain";
        BinaryObject bobj = new BinaryObject(SpooledFileConverter.getLastPages((AS400)this.loginHelper.getAs400(), (SpooledFile)spooledFileInfo.getSpooledFile(), (int)2).toString().getBytes(), type, object);
        bobj.openSaveAsDialog(spooledFileInfo.getSpoolfileName() + ".txt");
        this.table3.undoSelections();
        return bobj;
    }

    public DataObject download3(DataObject object) throws Exception {
        Object[] spooledFiles = TableHelper.getSelectedItems((AbstractTable)this.table3, (DataObject)object);
        if (spooledFiles.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        if (spooledFiles.length > 1) {
            object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
            return object;
        }
        SpooledFileInfo spooledFileInfo = (SpooledFileInfo)spooledFiles[0];
        if (spooledFileInfo.getPages() == 0) {
            object.addUIObject((UIObject)new Message("SpooledFile_in_use", "error"));
            return object;
        }
        if (spooledFileInfo.getPages() > 500) {
            object.addUIObject((UIObject)new Message("Maximum_number_of_pages_exceeded_(500)", "error"));
            return object;
        }
        String type = "text/plain";
        BinaryObject bobj = new BinaryObject(SpooledFileConverter.cvtToText((SpooledFileInfo)spooledFileInfo).toString().getBytes(), type, object);
        bobj.openSaveAsDialog(spooledFileInfo.getSpoolfileName() + ".txt");
        this.table3.undoSelections();
        return bobj;
    }
}

