/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.adapters.YearPercentageTableReportAdapter;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.YearPercentageDetail;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.queries.YearPercentageDetailQuery;
import nl.ibs.fac.queries.YearPercentageTableQuery;

public class YearPercentageTableAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3325091191701275443L;
    public static final String PAGE = YearPercentageTableAdapter.class.getName();
    private static final String REFRESH = "refresh";
    private static final String CREATEFORM = "initCreateForm";
    private static final String CREATE = "create";
    private static final String EDITFORM = "editForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private static final int ELEMENTSPERROW = 6;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"id", "description", "actualYears"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.Years"};
    private static final short[] SIZES = new short[]{120, 400, 72};
    private static final Label[] DETAILLABELS = new Label[]{new Label("Label.rij1"), new Label("Label.rij2"), new Label("Label.rij3"), new Label("Label.rij4"), new Label("Label.rij5"), new Label("Label.rij6"), new Label("Label.rij7"), new Label("Label.rij8"), new Label("Label.rij9"), new Label("Label.rij10")};
    protected Action[] rowActions;
    protected Action[] headerActions;
    private Panel header = new HeaderPanel();
    private Field id = new Field("Label.Id", "upper");
    private Field desc = new Field("Label.Description");
    private NumberField actualYears = new NumberField("Label.NumberOfYears", 3, true);
    private FieldGroup panel;
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private YearPercentageTable yearPercentageTable;
    private Object[] yearPercentageTables;
    private FACDecimalField[] detailFields = new FACDecimalField[50];
    private ESPGridLayout grid;
    private ArrayList list;

    public YearPercentageTableAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.env == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action report = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("report");
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.rowActions = new Action[]{edit, report, confirmDelete};
        Action reportAll = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("reportAll");
        this.headerActions = new Action[]{refresh, create, reportAll};
        this.header.setWidth(620);
        this.id.setMandatory(true);
        this.id.setLength(10);
        this.id.setMaxLength(10);
        this.id.setHelpId("Label.YearPercentageTableId");
        this.header.addUIObject((UIObject)this.id);
        this.desc.setLength(50);
        this.desc.setMaxLength(50);
        this.header.addUIObject((UIObject)this.desc);
        this.actualYears.setMandatory(true);
        this.actualYears.setMinValue(1L, true);
        this.actualYears.setMaxValue(50L, true);
        this.actualYears.setMaxLength(2);
        this.header.addUIObject((UIObject)this.actualYears);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(report);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.back);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.env == null) {
            object.addUIObject((UIObject)new Message("NoActiveEnvironment", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.YearPercentageTables", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        YearPercentageTableQuery query = new YearPercentageTableQuery(this.dbData);
        this.table = new ODBTable(YearPercentageTable.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setSortable(true);
        this.table.setMultipleSelect(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerpanel");
        this.searchPanel.setWidth(620);
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateYearPercentageTable", "screen_name"));
        this.id.setValue();
        this.desc.setValue();
        this.actualYears.setValue();
        object.addUIObject((UIObject)this.header);
        this.list = null;
        this.createGridPercentage(object);
        object.addUIObject((UIObject)this.fbCreate);
        return this.createForm(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.id.setReadonly(false);
        this.desc.setReadonly(false);
        this.actualYears.setReadonly(false);
        this.panel.setHidden(true);
        this.removeActions();
        Action createOK1 = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm2");
        createOK1.setValidationEnabled(true);
        createOK1.setDefault(true);
        this.fbCreate.addAction(this.back);
        this.fbCreate.addAction(createOK1);
        return object;
    }

    public DataObject createForm2(DataObject object) throws Exception {
        Object[] result = YearPercentageTableBO.get(this.dbData, this.id.getValue());
        if (result[0] != null) {
            this.id.setInvalidTag();
            object.addUIObject((UIObject)new Message("duplicate_key", "error"));
            return object;
        }
        this.updateGrid();
        this.id.setReadonly(true);
        this.desc.setReadonly(true);
        this.actualYears.setReadonly(true);
        this.panel.setHidden(false);
        this.removeActions();
        Action previous = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm");
        Action createOK2 = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK2.setValidationEnabled(true);
        createOK2.setDefault(true);
        this.fbCreate.addAction(previous);
        this.fbCreate.addAction(createOK2);
        this.fbCreate.addAction(this.cancel);
        return object;
    }

    private void removeActions() throws Exception {
        this.fbCreate.removeAction("Button.Back");
        this.fbCreate.removeAction("Button.Next");
        this.fbCreate.removeAction("Button.Previous");
        this.fbCreate.removeAction("Button.Complete");
        this.fbCreate.removeAction("Button.Cancel");
    }

    private void updateGrid() throws Exception {
        int limit = this.actualYears.getIntValue();
        for (int i = 0; i < 50; ++i) {
            if (i < limit) {
                this.detailFields[i].setReadonly(false);
                continue;
            }
            this.detailFields[i].setReadonly(true);
        }
        this.detailFields[0].requestFocus(true);
    }

    private String validatePercentages() throws Exception {
        BigDecimal[] dtls = new BigDecimal[50];
        for (int i = 0; i < this.detailFields.length; ++i) {
            dtls[i] = this.detailFields[i].getBigDecimal();
        }
        return YearPercentageTableBO.validatePercentage(dtls);
    }

    private void createGridPercentage(DataObject object) throws Exception {
        this.panel = new FieldGroup();
        this.grid = new ESPGridLayout();
        this.panel.add(this.grid);
        object.addUIObject((UIObject)this.panel);
        this.grid.setColumnWidths(new short[]{100, 100, 100, 100, 100, 100});
        Label label = new Label(this.translate("Label.Year") + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        label.setHelpId("Label.Percentage");
        this.grid.add((UIObject)label, 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.grid.add((UIObject)new Label("Label.Percentage"), 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.grid.add((UIObject)new Label("Label.Percentage"), 0, 2, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.grid.add((UIObject)new Label("Label.Percentage"), 0, 3, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.grid.add((UIObject)new Label("Label.Percentage"), 0, 4, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.grid.add((UIObject)new Label("Label.Percentage"), 0, 5, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        int idx = 0;
        int idxLabel = 0;
        for (int i = 0; i < 60; ++i) {
            if (i % 6 == 0) {
                this.grid.add((UIObject)DETAILLABELS[idxLabel], i / 6 + 1, i % 6, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
                ++idxLabel;
                continue;
            }
            this.detailFields[idx] = new FACDecimalField("", 5, 2);
            if (this.list != null && idx < this.list.size()) {
                YearPercentageDetail detail = (YearPercentageDetail)this.list.get(idx);
                this.detailFields[idx].setValue(detail.getPercentage());
            }
            this.detailFields[idx].setMinValue(new BigDecimal(0), true);
            this.detailFields[idx].setMaxValue(new BigDecimal(100), true);
            this.grid.add((UIObject)this.detailFields[idx], i / 6 + 1, i % 6, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
            ++idx;
        }
    }

    public DataObject create(DataObject object) throws Exception {
        String message = this.validatePercentages();
        if (message != null && message.trim().length() > 0) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        BigDecimal[] details = new BigDecimal[this.detailFields.length];
        for (int i = 0; i < details.length; ++i) {
            details[i] = this.detailFields[i].getBigDecimal();
        }
        Object[] result = YearPercentageTableBO.create(this.dbData, this.id.getValue().trim(), this.desc.getValue().trim(), this.actualYears.getIntValue(), details);
        message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.id.getValue().trim(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditYearPercentageTable", "screen_name"));
        this.yearPercentageTable = (YearPercentageTable)TableHelper.getSelectedItem((DataObject)object);
        this.id.setValue(this.yearPercentageTable.getId());
        this.id.setReadonly(true);
        this.desc.setValue(this.yearPercentageTable.getDescription());
        this.desc.setReadonly(false);
        this.actualYears.setValue("" + this.yearPercentageTable.getActualYears());
        this.actualYears.setReadonly(true);
        object.addUIObject((UIObject)this.header);
        YearPercentageDetailQuery detailQry = new YearPercentageDetailQuery(this.dbData, this.yearPercentageTable.getId().trim());
        this.list = (ArrayList)detailQry.fetchData(null, "lifeCycleYear", null, 50);
        this.createGridPercentage(object);
        this.updateGrid();
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.validatePercentages();
        if (message != null && message.trim().length() > 0) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        BigDecimal[] details = new BigDecimal[this.detailFields.length];
        for (int i = 0; i < details.length; ++i) {
            details[i] = this.detailFields[i].getBigDecimal();
        }
        message = YearPercentageTableBO.update(this.yearPercentageTable, this.desc.getValue().trim(), this.actualYears.getIntValue(), this.list, details);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.id.getValue().trim(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject report(DataObject object) throws Exception {
        this.yearPercentageTables = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.yearPercentageTables.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        for (int i = 0; i < this.yearPercentageTables.length; ++i) {
            this.yearPercentageTable = (YearPercentageTable)this.yearPercentageTables[i];
            String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"orderBy", "id"}, {"FromYearPercentageTable", this.yearPercentageTable.getId()}, {"ToYearPercentageTable", this.yearPercentageTable.getId()}};
            this.getProcess().setAttribute("selections", (Object)selections);
            this.getProcess().setAttribute("classNamePDF", (Object)YearPercentageTableReportAdapter.CLASSNAMEPDF);
            this.getProcess().setAttribute("jobName", (Object)"Job.YearPercentageTable");
            this.getProcess().setAttribute("returnPage", (Object)PAGE);
            object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
        }
        return object;
    }

    public DataObject reportAll(DataObject object) throws Exception {
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(YearPercentageTableReportAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.yearPercentageTables = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteYearPercentageTables", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.yearPercentageTables.length);
        for (int i = 0; i < this.yearPercentageTables.length; ++i) {
            list.add(this.yearPercentageTables[i]);
        }
        CollectionTable table = new CollectionTable(YearPercentageTable.class, list, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        for (int i = 0; i < this.yearPercentageTables.length; ++i) {
            YearPercentageTable yearPercentage = (YearPercentageTable)this.yearPercentageTables[i];
            if (yearPercentage == null || (message = YearPercentageTableBO.delete(yearPercentage)) == null) continue;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }
}

