/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.AdditionalJournalingData;
import nl.ibs.fac.db.AdditionalJournalingDataDataBean;
import nl.ibs.fac.db.AdditionalJournalingDataManager;
import nl.ibs.fac.db.AdditionalJournalingDataManagerFactory;
import nl.ibs.fac.db.AdditionalJournalingDataPK;
import nl.ibs.fac.db.Company;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class AdditionalJournalingDataBO
extends BOAdapter {
    public static Object[] get(DBData dbData, String companyId, String typeId, int accountingPrinciple, int journalingTerm, int processCode) throws Exception {
        Object[] result = new Object[2];
        AdditionalJournalingDataPK key = new AdditionalJournalingDataPK();
        key.setCompanyId(companyId);
        key.setTypeId(typeId);
        key.setAccountingPrinciple(accountingPrinciple);
        key.setJournalingTerm(journalingTerm);
        key.setProcessCode(processCode);
        try {
            result[0] = AdditionalJournalingDataManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection retrieveAdditionalJournalingDataTypes(Company company, int accountingPrinciple) throws Exception {
        ExecutableQuery query = QueryFactory.create(AdditionalJournalingData.class, null, "typeId,journalingTerm");
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = AdditionalJournalingDataBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", company.getId());
        filter = AdditionalJournalingDataBO.addFilterTerm(filter, "accountingPrinciple = ?_accountingPrinciple");
        parameters.put("_accountingPrinciple", new Integer(accountingPrinciple));
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AdditionalJournalingDataManager manager = AdditionalJournalingDataManagerFactory.getInstance(company.getDBData());
        Collection fullCollection = manager.getCollection(query);
        if (fullCollection == null || fullCollection.isEmpty()) {
            return null;
        }
        ArrayList<String> resultCollection = new ArrayList<String>();
        for (AdditionalJournalingData ajd : fullCollection) {
            if (resultCollection.contains(ajd.getTypeId().trim())) continue;
            resultCollection.add(ajd.getTypeId().trim());
        }
        return resultCollection;
    }

    public static Collection retrieveJournalingTerms(Company company, String typeId, int accountingPrinciple) throws Exception {
        ExecutableQuery query = QueryFactory.create(AdditionalJournalingData.class, null, "typeId,journalingTerm");
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = AdditionalJournalingDataBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", company.getId());
        filter = AdditionalJournalingDataBO.addFilterTerm(filter, "typeId = ?_typeId");
        parameters.put("_typeId", typeId);
        filter = AdditionalJournalingDataBO.addFilterTerm(filter, "accountingPrinciple = ?_accountingPrinciple");
        parameters.put("_accountingPrinciple", new Integer(accountingPrinciple));
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AdditionalJournalingDataManager manager = AdditionalJournalingDataManagerFactory.getInstance(company.getDBData());
        return manager.getCollection(query);
    }

    public static Object[] create(DBData dbData, String companyId, String typeId, int accountingPrinciple, int journalingTerm, int processCode, String fixedDimId1, String fixedDimId2, String fixedDimId3, String fixedDimId4, String fixedDimId5, boolean suppressStatNumbers) throws Exception {
        Object[] result = new Object[2];
        AdditionalJournalingDataManager manager = AdditionalJournalingDataManagerFactory.getInstance(dbData);
        AdditionalJournalingDataDataBean bean = new AdditionalJournalingDataDataBean();
        bean.setCompanyId(companyId);
        bean.setTypeId(typeId);
        bean.setAccountingPrinciple(accountingPrinciple);
        bean.setJournalingTerm(journalingTerm);
        bean.setProcessCode(processCode);
        bean.setFixedDimension1(fixedDimId1);
        bean.setFixedDimension2(fixedDimId2);
        bean.setFixedDimension3(fixedDimId3);
        bean.setFixedDimension4(fixedDimId4);
        bean.setFixedDimension5(fixedDimId5);
        bean.setSuppressStatNumbers(suppressStatNumbers);
        try {
            result[0] = manager.create(bean);
        }
        catch (Exception e) {
            result[1] = AdditionalJournalingDataBO.investigate(e, null);
        }
        return result;
    }

    public static String update(AdditionalJournalingData additionalJournalingData, String fixedDimId1, String fixedDimId2, String fixedDimId3, String fixedDimId4, String fixedDimId5, boolean suppressStatNumbers) throws Exception {
        boolean alreadyActive = AdditionalJournalingDataBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            additionalJournalingData.setFixedDimension1(fixedDimId1);
            additionalJournalingData.setFixedDimension2(fixedDimId2);
            additionalJournalingData.setFixedDimension3(fixedDimId3);
            additionalJournalingData.setFixedDimension4(fixedDimId4);
            additionalJournalingData.setFixedDimension5(fixedDimId5);
            additionalJournalingData.setSuppressStatNumbers(suppressStatNumbers);
            AdditionalJournalingDataBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AdditionalJournalingDataBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(AdditionalJournalingData additionalJournalingData) throws Exception {
        try {
            additionalJournalingData.delete();
        }
        catch (Exception e) {
            return AdditionalJournalingDataBO.investigate(e, null);
        }
        return null;
    }

    public static String handleMassUpdate(DBData dbData, Company company, String id, int ap, FinancialReferenceField[] costCentres, FinancialReferenceField[] costUnits, FinancialReferenceField[] activities, FinancialReferenceField[] achievements) throws Exception {
        String message = null;
        int processCode = 0;
        for (int index = 0; index < 8; ++index) {
            AdditionalJournalingData ajd;
            Object[] objects;
            int journalingTerm = (index + 1) * 10;
            String costCentreId = costCentres[index].getValue();
            String costUnitId = costUnits[index].getValue();
            String activityId = activities[index].getValue();
            String achievementId = achievements[index].getValue();
            if (costCentreId != null && costCentreId.length() > 0 || costUnitId != null && costUnitId.length() > 0 || activityId != null && activityId.length() > 0 || achievementId != null && achievementId.length() > 0) {
                if (costCentreId != null && costCentreId.length() > 0) {
                    costCentres[index].validate();
                    costCentreId = costCentres[index].getFormattedId();
                } else {
                    costCentreId = "";
                }
                if (costUnitId != null && costUnitId.length() > 0) {
                    costUnits[index].validate();
                    costUnitId = costUnits[index].getFormattedId();
                } else {
                    costUnitId = "";
                }
                if (activityId != null && activityId.length() > 0) {
                    activities[index].validate();
                    activityId = activities[index].getFormattedId();
                } else {
                    activityId = "";
                }
                if (achievementId != null && achievementId.length() > 0) {
                    achievements[index].validate();
                    achievementId = achievements[index].getFormattedId();
                } else {
                    achievementId = "";
                }
                objects = AdditionalJournalingDataBO.get(dbData, company.getId(), id, ap, journalingTerm, processCode);
                if (objects[0] != null) {
                    ajd = (AdditionalJournalingData)objects[0];
                    message = AdditionalJournalingDataBO.update(ajd, costCentreId, costUnitId, activityId, achievementId, "", false);
                    if (message == null) continue;
                    return message;
                }
                objects = AdditionalJournalingDataBO.create(dbData, company.getId(), id, ap, journalingTerm, processCode, costCentreId, costUnitId, activityId, achievementId, "", false);
                if (objects[1] == null) continue;
                return (String)objects[1];
            }
            objects = AdditionalJournalingDataBO.get(dbData, company.getId(), id, ap, journalingTerm, processCode);
            if (objects[0] == null || (message = AdditionalJournalingDataBO.delete(ajd = (AdditionalJournalingData)objects[0])) == null) continue;
            return message;
        }
        return null;
    }
}

