/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.Iterator;
import nl.ibs.esp.util.CommonObjectDataReader;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class AssetDataReader
extends CommonObjectDataReader {
    private static final long serialVersionUID = -5900137519122605376L;
    private ExecutableQuery qry = QueryFactory.create(AssetAnalysisCode.class, "seqNr = ?_seqNr");
    private static final String SQL = "seqNr = ?_seqNr";

    public AssetDataReader() throws Exception {
        super(Asset.class);
    }

    public Object getValue(Object object, String key) throws Exception {
        if (key.startsWith("assetAnalysisCode")) {
            String seqNr = key.substring("assetAnalysisCode".length());
            Asset asset = (Asset)object;
            this.qry.setParameter("_seqNr", seqNr);
            Iterator iterator = asset.getAssetAnalysisCodeCollection(this.qry).iterator();
            if (iterator.hasNext()) {
                AssetAnalysisCode analysisCode = (AssetAnalysisCode)iterator.next();
                return analysisCode.getCode();
            }
            return "";
        }
        if (key.startsWith("assetValue")) {
            String seqNr = key.substring("assetValue".length());
            Asset asset = (Asset)object;
            this.qry.setParameter("_seqNr", seqNr);
            Iterator iterator = asset.getAssetValueCollection(this.qry).iterator();
            if (iterator.hasNext()) {
                AssetValue assetValue = (AssetValue)iterator.next();
                return assetValue.getValue();
            }
            return "";
        }
        return super.getValue(object, key);
    }

    public Class getType(String key) throws Exception {
        if (key.startsWith("assetAnalysisCode") || key.startsWith("assetValue")) {
            return String.class;
        }
        return super.getType(key);
    }
}

