/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.AssetValueDataBean;
import nl.ibs.fac.db.AssetValueManager;
import nl.ibs.fac.db.AssetValueManagerFactory;
import nl.ibs.fac.db.AssetValuePK;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class AssetValueBO
extends BOAdapter {
    public static Object[] get(DBData dbData, String companyId, int seqNr, String cora, String assetId) throws Exception {
        Object[] result = new Object[2];
        AssetValuePK key = new AssetValuePK();
        key.setCompanyId(companyId);
        key.setSeqNr(seqNr);
        key.setAssetId(assetId);
        key.setCora(cora);
        try {
            result[0] = AssetValueManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection getCollection(DBData dbData, String companyId, String assetId) throws Exception {
        ExecutableQuery query = QueryFactory.create(AssetValue.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetValueBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        filter = AssetValueBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", assetId);
        filter = AssetValueBO.addFilterTerm(filter, "cora = 'A'");
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetValueManager manager = AssetValueManagerFactory.getInstance(dbData);
        return manager.getCollection(query);
    }

    public static Object[] create(DBData dbData, String companyId, String cora, String assetId, AnalysisGroup analysisGroup, String value) throws Exception {
        Object[] result = new Object[2];
        AssetValueManager manager = AssetValueManagerFactory.getInstance(dbData);
        AssetValueDataBean bean = new AssetValueDataBean();
        bean.setCora(cora);
        bean.setAssetId(assetId);
        bean.setCompanyId(companyId);
        bean.setAnalysisGroupCompanyId(analysisGroup.getCompanyId());
        bean.setSeqNr(analysisGroup.getSeqNr());
        bean.setValue(value);
        boolean alreadyActive = AssetValueBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            AssetValueBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = AssetValueBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(AssetValue assetValue, String value) throws Exception {
        boolean alreadyActive = AssetValueBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            assetValue.setValue(value);
            AssetValueBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AssetValueBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(AssetValue assetValue) throws Exception {
        boolean alreadyActive = AssetValueBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            assetValue.delete();
            AssetValueBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AssetValueBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static Collection getAssetValues(Map map) throws Exception {
        ExecutableQuery query = QueryFactory.create(AssetValue.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String companyId = (String)map.get("Company");
        String filter = AssetValueBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        Integer seqNr = (Integer)map.get("seqNr");
        filter = AssetValueBO.addFilterTerm(filter, "seqNr = ?_seqNr");
        parameters.put("_seqNr", seqNr);
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetValueManager manager = AssetValueManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }
}

