/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import nl.ibs.fac.FacDBConfigProperties;
import nl.ibs.fac.FacDBData;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.UpdateException;

public abstract class BOAdapter {
    public static final String SYSTEM = "System";
    public static final String USER = "User";
    public static final String PASSWORD = "Password";
    public static final String ENVIRONMENT = "Environment";
    public static final String LIBRARY = "facLib";
    public static final String OPERATIONAREA = "operationArea";
    public static final String DATA_LIB = "dataLib";
    public static final String PROGRAM_LIB = "programLib";
    public static final String OBJECT_LIB = "object_lib";
    public static final String COMPANY = "Company";
    public static final String BOOKYEAR = "BookYear";
    public static final String ORDER_BY = "orderBy";
    public static final String LEVELS = "levels";
    public static final String SEPARATOR = ",";
    public static final String GOVERNMENT_ACTIVATED = "governmentActivated";
    public static final String ACCOUNTINGPRINCIPLE = "AccountingPrinciple";
    public static final String BOOKYEARFROM = "BookYearFrom";
    public static final String PERIODFROM = "PeriodFrom";
    public static final String BOOKYEARTO = "BookYearTo";
    public static final String PERIODTO = "PeriodTo";

    public static DBData getDBData(Map map) {
        if (map == null) {
            return DBData.getDefaultDBData("fac");
        }
        String library = (String)map.get(LIBRARY);
        if (library == null) {
            return DBData.getDefaultDBData("fac");
        }
        return BOAdapter.getDBData(library);
    }

    public static DBData getDBData(String library) {
        String url = FacDBConfigProperties.getURL();
        int b2 = url.indexOf("package library=");
        if (b2 > -1) {
            int e = url.indexOf(";", b2);
            if (e == -1) {
                e = url.length();
            }
            url = url.substring(0, b2 + 16) + library + url.substring(e);
        }
        Log.debug((String)url);
        Log.debug((String)library);
        return new FacDBData(library, FacDBConfigProperties.getJDBCDriver(), url, library, FacDBConfigProperties.getUser(), FacDBConfigProperties.getPassword());
    }

    protected static void addOrdering(ExecutableQuery query, Map map, String defaultOrdering) throws Exception {
        String ordering = defaultOrdering;
        if (map != null) {
            String orderBy = (String)map.get(ORDER_BY);
            ordering = orderBy == null || orderBy.length() == 0 ? defaultOrdering : (defaultOrdering != null && orderBy.indexOf(SEPARATOR + defaultOrdering) == -1 ? orderBy + SEPARATOR + defaultOrdering : orderBy);
        }
        if (Log.debug()) {
            Log.debug((String)("Ordering: " + ordering));
        }
        if (ordering != null) {
            query.setOrdering(ordering);
        }
    }

    public static String[] getTotalLevels(Map map) {
        String levels = (String)map.get(LEVELS);
        String[] level = new String[levels.length() + 1];
        for (int i = 0; i < levels.length(); ++i) {
            int value = Integer.parseInt(levels.substring(i, i + 1));
            if (value == 0) continue;
            level[value] = "" + i;
        }
        return level;
    }

    public static String transLateOrderBy(String orderBy) {
        StringBuffer sb = new StringBuffer();
        String[] strings = BOAdapter.getOrderBy(orderBy);
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
            sb.append(LanguageHelper.getString("nl.ibs.fac.language", string));
            if (i >= strings.length - 1) continue;
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public static List getFields(Map map, String[] labels) {
        String[] fields = new String[labels.length];
        System.arraycopy(labels, 0, fields, 0, fields.length);
        ArrayList<String> result = new ArrayList<String>();
        String orderBy = (String)map.get(ORDER_BY);
        if (orderBy != null) {
            String[] strings = BOAdapter.getOrderBy(orderBy);
            for (int i = 0; i < strings.length; ++i) {
                result.add(strings[i]);
                for (int j = 0; j < labels.length; ++j) {
                    if (!strings[i].equals(labels[j])) continue;
                    fields[j] = null;
                }
            }
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            result.add(fields[i]);
        }
        return result;
    }

    public static String[] getOrderBy(String orderBy) {
        int i = 0;
        StringTokenizer tokenizer = new StringTokenizer(orderBy, SEPARATOR);
        String[] result = new String[tokenizer.countTokens()];
        while (tokenizer.hasMoreTokens()) {
            result[i++] = tokenizer.nextToken();
        }
        return result;
    }

    public static String addFilterTerm(String filter, String term) throws Exception {
        if (term == null || term.length() == 0) {
            return filter;
        }
        if (filter != null) {
            return filter + " AND " + term;
        }
        return term;
    }

    public static String addOrFilterTerm(String filter, String term) throws Exception {
        if (term == null || term.length() == 0) {
            return filter;
        }
        if (filter != null) {
            return filter + " OR " + term;
        }
        return term;
    }

    public static boolean beginTransaction() throws Exception {
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        boolean alreadyActive = dbTransaction.isActive();
        if (Log.debug() && alreadyActive) {
            Log.debug((String)"transaction is already active");
        }
        if (!alreadyActive) {
            Log.debug((String)"begin transaction");
            dbTransaction.begin();
        }
        return alreadyActive;
    }

    public static void commitTransaction() throws Exception {
        BOAdapter.commitTransaction(false);
    }

    public static void commitTransaction(boolean alreadyActive) throws Exception {
        if (Log.debug() && alreadyActive) {
            Log.debug((String)"transaction is already active");
        }
        if (!alreadyActive) {
            DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
            Log.debug((String)"commit transaction");
            dbTransaction.commit();
        }
    }

    public static String investigate(Exception e, DBTransaction dbTransaction) throws Exception {
        if (dbTransaction != null && dbTransaction.isActive()) {
            try {
                Log.debug((String)"rollback transaction");
                dbTransaction.rollback();
            }
            catch (Exception ex) {
                Log.error((Exception)e);
                Log.error((String)"Severe problem: rollback failed");
                throw ex;
            }
        }
        if (e == null) {
            return null;
        }
        if (e instanceof NullPointerException || e.getMessage() == null) {
            Log.error((Exception)e);
            return "system_error";
        }
        if (e instanceof FinderException) {
            return "Key_not_found";
        }
        if (e instanceof UpdateException) {
            return "record_changed";
        }
        if (e.getMessage().startsWith("[SQL0803]")) {
            return "duplicate_key";
        }
        if (e.getMessage().startsWith("Data truncation")) {
            return "data_truncation";
        }
        Log.error((Exception)e);
        return e.getMessage();
    }

    protected static String escapeSingleQuotes(String value) {
        if (value.indexOf(39) >= 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == '\'') {
                    buffer.append('\'');
                }
                buffer.append(value.charAt(i));
            }
            value = buffer.toString();
        }
        return "'" + value + "'";
    }
}

