/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.BookYear;
import nl.ibs.fac.db.BookYearDataBean;
import nl.ibs.fac.db.BookYearManager;
import nl.ibs.fac.db.BookYearManagerFactory;
import nl.ibs.fac.db.BookYearPK;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class BookYearBO
extends BOAdapter {
    public static final int BOOKYEAR_NOT_FOUND = 0;
    public static final int CLOSED = 1;
    public static final int OPEN = 2;

    public static String synchronizeWithFinancials(LoginHelper loginHelper, Environment env, Company company) throws Exception {
        List years = BookYearBO.getFinancialBookYears(loginHelper, env, company.getId(), company.getInitialBookYear());
        return (String)BookYearBO.create(company, years)[1];
    }

    public static List getFinancialBookYears(LoginHelper loginHelper, Environment env, String companyId, int initialBookYear) throws Exception {
        ArrayList<String> years = new ArrayList<String>();
        List allYears = null;
        allYears = env.getOperationArea().trim().length() == 0 ? new FISHelper(loginHelper).getBookYears(companyId) : new FMSHelper(loginHelper).getBookYears(companyId);
        for (int i = 0; i < allYears.size(); ++i) {
            String year = (String)allYears.get(i);
            if (Integer.parseInt(year) < initialBookYear) continue;
            years.add("" + year);
        }
        return years;
    }

    private static Object[] create(Company company, List years) throws Exception {
        Object[] result = new Object[2];
        for (String year : years) {
            BookYear bookYear = (BookYear)BookYearBO.get(company, Integer.parseInt(year))[0];
            if (bookYear != null) continue;
            try {
                BookYearManager manager = BookYearManagerFactory.getInstance(company.getDBData());
                BookYearDataBean bean = new BookYearDataBean();
                bean.setCompanyId(company.getId());
                bean.setBookYear(Integer.parseInt(year));
                result[0] = manager.create(bean);
            }
            catch (Exception e) {
                result[1] = BookYearBO.investigate(e, null);
                if (!"duplicate_key".equals(result[1])) {
                    return result;
                }
                result[1] = null;
            }
        }
        return result;
    }

    public static String update(BookYear bookYear, int valBookYear, int valPeriodTo, int valPeriodFrom) throws Exception {
        boolean alreadyActive = BookYearBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            bookYear.setPeriodTo(valPeriodTo);
            bookYear.setPeriodFrom(valPeriodFrom);
            BookYearBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BookYearBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static Collection getFACBookYears(Company company) throws Exception {
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(BookYear.class);
        query.setCacheable(true);
        String companyId = company.getId();
        String filter = BookYearBO.addFilterTerm(null, "companyId = ?_companyId");
        query.setFilter(filter);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", companyId);
        query.setParameters(parameters);
        BookYearBO.addOrdering(query, null, "bookYear");
        BookYearManager manager = BookYearManagerFactory.getInstance(company.getDBData());
        return manager.getCollection(query);
    }

    public static int getPeriodStatus(Company company, int year, int period) throws Exception {
        BookYear bookYear = (BookYear)BookYearBO.get(company, year)[0];
        if (bookYear == null) {
            return 0;
        }
        if (bookYear.getAggregated()) {
            return 1;
        }
        if (bookYear.getPeriodTo() >= period) {
            return 1;
        }
        if (bookYear.getPeriodFrom() > 0 && period >= bookYear.getPeriodFrom()) {
            return 1;
        }
        return 2;
    }

    public static void incrementBlockedPeriods(Company company, int numberOfPeriods, int year, int period) throws Exception {
        BookYear bookYear = (BookYear)BookYearBO.get(company, year)[0];
        if (bookYear == null) {
            return;
        }
        if (bookYear.getPeriodTo() < period) {
            bookYear.setPeriodTo(period);
            int periodFrom = bookYear.getPeriodFrom();
            if (periodFrom > 0 && periodFrom >= period) {
                if (++periodFrom > numberOfPeriods) {
                    periodFrom = numberOfPeriods;
                }
                bookYear.setPeriodFrom(periodFrom);
            }
        }
    }

    public static Object[] get(Company company, int year) throws Exception {
        Object[] result = new Object[2];
        BookYearPK key = new BookYearPK();
        key.setCompanyId(company.getId());
        key.setBookYear(year);
        try {
            result[0] = BookYearManagerFactory.getInstance(company.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }
}

