/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.EnvironmentAccountingPrincipleDefault;
import nl.ibs.fac.db.EnvironmentAccountingPrincipleDefaultDataBean;
import nl.ibs.fac.db.EnvironmentAccountingPrincipleDefaultManager;
import nl.ibs.fac.db.EnvironmentAccountingPrincipleDefaultManagerFactory;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.exception.FinderException;

public abstract class EnvironmentAccountingPrincipleDefaultBO
extends BOAdapter {
    public static Object[] get(Environment environment, int accountingPrinciple) throws Exception {
        Object[] result = new Object[2];
        DBData dbData = EnvironmentAccountingPrincipleDefaultBO.getDBData(environment.getFacLib());
        try {
            result[0] = EnvironmentAccountingPrincipleDefaultManagerFactory.getInstance(dbData).findByPrimaryKey(accountingPrinciple);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    static void initialCreate(Environment environment) throws Exception {
        DBData dbData = EnvironmentAccountingPrincipleDefaultBO.getDBData(environment.getFacLib());
        EnvironmentAccountingPrincipleDefaultManager manager = EnvironmentAccountingPrincipleDefaultManagerFactory.getInstance(dbData);
        for (int accountingPrinciple = 1; accountingPrinciple < 5; ++accountingPrinciple) {
            EnvironmentAccountingPrincipleDefaultDataBean bean = new EnvironmentAccountingPrincipleDefaultDataBean();
            bean.setAccountingPrinciple(accountingPrinciple);
            bean.setStartPeriodHandlingMethod(1);
            bean.setCalculateInterest(false);
            bean.setInterestCalculationMethod(0);
            if (accountingPrinciple != 3) {
                bean.setCalculateDepreciation(true);
                bean.setDepreciationMethod(1);
            } else {
                bean.setCalculateDepreciation(false);
                bean.setDepreciationMethod(99);
            }
            if (accountingPrinciple != 1) {
                bean.setJournalingMethod(9);
            } else {
                bean.setJournalingMethod(1);
            }
            if (accountingPrinciple == 3) {
                bean.setJournalingMethod(1);
            }
            bean.setYearPercentageTableId(null);
            bean.setInterestTableId(null);
            bean.setAnnuityInterestTableId(null);
            manager.create(bean);
        }
    }

    public static String update(Environment environment, EnvironmentAccountingPrincipleDefault eapd, boolean calculateDepreciation, int depreciationMethod, String yearPercentageTableId, BigDecimal degressivePercentage, String annuityInterestTableId, BigDecimal annuityPercentage, int startPeriodHandlingMethod, boolean calculateInterest, int interestCalculationMethod, String interestTableId, BigDecimal interestPercentage, int journalingMethod) throws Exception {
        boolean alreadyActive = EnvironmentAccountingPrincipleDefaultBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        DBData dbData = EnvironmentAccountingPrincipleDefaultBO.getDBData(environment.getFacLib());
        try {
            YearPercentageTable yearPercentageTable = null;
            if (!yearPercentageTableId.trim().equals("")) {
                yearPercentageTable = (YearPercentageTable)YearPercentageTableBO.get(dbData, yearPercentageTableId)[0];
            }
            InterestTable annuityInterestTable = null;
            if (!annuityInterestTableId.trim().equals("")) {
                annuityInterestTable = (InterestTable)InterestTableBO.get(dbData, annuityInterestTableId, 0)[0];
            }
            InterestTable interestTable = null;
            if (!interestTableId.trim().equals("")) {
                interestTable = (InterestTable)InterestTableBO.get(dbData, interestTableId, 0)[0];
            }
            eapd.setCalculateDepreciation(calculateDepreciation);
            eapd.setDepreciationMethod(depreciationMethod);
            eapd.setYearPercentageTable(yearPercentageTable);
            eapd.setDegressivePercentage(degressivePercentage);
            eapd.setAnnuityInterestTable(annuityInterestTable);
            eapd.setAnnuityPercentage(annuityPercentage);
            eapd.setStartPeriodHandlingMethod(startPeriodHandlingMethod);
            eapd.setCalculateInterest(calculateInterest);
            eapd.setInterestCalculationMethod(interestCalculationMethod);
            eapd.setInterestTable(interestTable);
            eapd.setInterestPercentage(interestPercentage);
            eapd.setJournalingMethod(journalingMethod);
            EnvironmentAccountingPrincipleDefaultBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return EnvironmentAccountingPrincipleDefaultBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(EnvironmentAccountingPrincipleDefault accountingPrincipleDefault) throws Exception {
        try {
            accountingPrincipleDefault.delete();
        }
        catch (Exception e) {
            return EnvironmentAccountingPrincipleDefaultBO.investigate(e, null);
        }
        return null;
    }
}

