/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ObjectDescription;
import java.util.HashMap;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentAccountingPrincipleDefaultBO;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.EnvironmentDataBean;
import nl.ibs.fac.db.EnvironmentManager;
import nl.ibs.fac.db.EnvironmentManagerFactory;
import nl.ibs.fac.fis.FISDimensionEnum;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSDimensionEnum;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;

public abstract class EnvironmentBO
extends BOAdapter {
    public static Object[] get(String facLib) throws Exception {
        Object[] result = new Object[2];
        try {
            result[0] = EnvironmentManagerFactory.getInstance().findByPrimaryKey(facLib);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(LoginHelper loginHelper, String facLib, String operationArea, String dataLib, String programLib, String description, boolean governmentActivated) throws Exception {
        Object[] result = new Object[2];
        String message = EnvironmentBO.validateForCreate(loginHelper, facLib, operationArea, dataLib, programLib);
        if (message != null && message.trim().length() > 0) {
            result[1] = message;
            return result;
        }
        EnvironmentManager manager = EnvironmentManagerFactory.getInstance();
        EnvironmentDataBean bean = new EnvironmentDataBean();
        bean.setFacLib(facLib);
        bean.setOperationArea(operationArea);
        bean.setDataLib(dataLib);
        bean.setProgramLib(programLib);
        bean.setDescription(description);
        if (governmentActivated) {
            bean.setAccountingPrinciple2IsUsed(false);
        } else {
            bean.setAccountingPrinciple2IsUsed(true);
        }
        bean.setShortName1("Kostenpl.");
        bean.setShortName2("Kostendr.");
        if (operationArea.length() == 0) {
            bean.setName1(FISDimensionEnum.getValue(1));
            bean.setName2(FISDimensionEnum.getValue(2));
            bean.setName3(FISDimensionEnum.getValue(3));
            bean.setName4(FISDimensionEnum.getValue(4));
            bean.setName5(FISDimensionEnum.getValue(5));
            bean.setShortName3("Stat.nr.1");
            bean.setShortName4("Stat.nr.2");
            bean.setShortName5("Stat.nr.3");
            bean.setNameDebtor(FISDimensionEnum.getValue(10));
            bean.setNameCreditor(FISDimensionEnum.getValue(11));
            bean.setNameRelation("");
            bean.setShortNameRelation("");
        } else {
            bean.setName1(FMSDimensionEnum.getValue(1));
            bean.setName2(FMSDimensionEnum.getValue(2));
            bean.setName3(FMSDimensionEnum.getValue(3));
            bean.setName4(FMSDimensionEnum.getValue(4));
            bean.setName5("");
            bean.setShortName3(bean.getName3());
            bean.setShortName4(bean.getName4());
            bean.setShortName5("");
            bean.setNameDebtor(FMSDimensionEnum.getValue(10));
            bean.setNameCreditor(FMSDimensionEnum.getValue(11));
            bean.setNameRelation(FMSDimensionEnum.getValue(12));
            bean.setShortNameRelation(bean.getNameRelation());
            bean.setGovernmentActivated(governmentActivated);
        }
        bean.setShortNameDebtor(bean.getNameDebtor());
        bean.setShortNameCreditor(bean.getNameCreditor());
        bean.setCMSName1("Hoofdproject");
        bean.setCMSName2("Subproject");
        bean.setCMSName3("Werksoort");
        bean.setCMSShortName1("Hoofdproject");
        bean.setCMSShortName2("Subproject");
        bean.setCMSShortName3("Werksoort");
        boolean alreadyActive = EnvironmentBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Environment environment = manager.create(bean);
            result[0] = environment;
            if (environment != null && governmentActivated) {
                environment.setAPName1("Activa");
                environment.setAPName3("Investeringskredieten");
                environment.setAPShortName1("Activa");
                environment.setAPShortName3("Kredieten");
            }
            EnvironmentAccountingPrincipleDefaultBO.initialCreate(environment);
            manager = EnvironmentManagerFactory.getInstance(EnvironmentBO.getDBData(facLib));
            manager.getFirstObject(null);
            BatchJobHelper.runCommand(loginHelper, "CHGLIB LIB(" + environment.getFacLib() + ") TEXT('" + environment.getDescription() + "')");
            EnvironmentBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = EnvironmentBO.investigate(e, dbTransaction);
        }
        return result;
    }

    private static String validateForCreate(LoginHelper loginHelper, String facLib, String operationArea, String dataLib, String programLib) throws Exception {
        String message = null;
        if (facLib.equals(loginHelper.getLibrary())) {
            return LanguageHelper.getString("nl.ibs.fac.language", "DefaultLibNotAllowed");
        }
        ObjectDescription od = new ObjectDescription((AS400)loginHelper.getAs400(), "/QSYS.LIB/" + facLib + ".LIB");
        if (od.exists()) {
            return LanguageHelper.getString("nl.ibs.fac.language", "Library_already_exists");
        }
        if (operationArea.length() == 0) {
            if (dataLib.length() == 0) {
                TokenList tl = new TokenList();
                tl.addTranslatable("nl.ibs.fac.language", "DataLib");
                return LanguageHelper.getString("nl.ibs.fac.language", "empty-mandatory-field", tl);
            }
            if (programLib.length() == 0) {
                TokenList tl = new TokenList();
                tl.addTranslatable("nl.ibs.fac.language", "ProgramLib");
                return LanguageHelper.getString("nl.ibs.fac.language", "empty-mandatory-field", tl);
            }
            if (EnvironmentBO.getEnvironment(null, dataLib) != null) {
                TokenList tl = new TokenList();
                tl.addTranslatable("nl.ibs.fac.language", "DataLib");
                return LanguageHelper.getString("nl.ibs.fac.language", "duplicate_key", tl);
            }
            FISHelper helper = new FISHelper(loginHelper);
            helper.login(dataLib, programLib);
            message = helper.getMessage();
            if (message.trim().length() == 0) {
                helper.logout(dataLib, programLib);
            }
        } else {
            if (EnvironmentBO.getEnvironment(operationArea, null) != null) {
                TokenList tl = new TokenList();
                tl.addTranslatable("nl.ibs.fac.language", "OperationArea");
                return LanguageHelper.getString("nl.ibs.fac.language", "duplicate_key", tl);
            }
            FMSHelper helper = new FMSHelper(loginHelper);
            helper.login(operationArea, "", "");
            message = helper.getMessage();
            if (message.trim().length() == 0) {
                helper.logout(operationArea, "", "");
            }
        }
        return message;
    }

    public static Object[] checkActivated(LoginHelper loginHelper, String operationArea, boolean government) throws Exception {
        int days;
        String message;
        Object[] result = new Object[3];
        if (operationArea.length() == 0) {
            FISHelper helper = new FISHelper(loginHelper);
            helper.checkActivated(government);
            message = helper.getMessage();
            days = helper.getDaysUntilExpiration();
            result[2] = "" + helper.getMaxUsers();
        } else {
            FMSHelper helper = new FMSHelper(loginHelper);
            helper.checkActivated(government);
            message = helper.getMessage();
            days = helper.getDaysUntilExpiration();
            result[2] = "" + helper.getMaxUsers();
        }
        if (message != null) {
            result[0] = LanguageHelper.getString("nl.ibs.fac.language", message);
            if (days > 0) {
                result[1] = "" + days;
                result[0] = result[0] + ": " + days;
            }
        }
        return result;
    }

    public static Environment getEnvironment(String operationArea, String dataLib) throws Exception {
        ExecutableQuery query = QueryFactory.create(Environment.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = null;
        if (operationArea != null && operationArea.length() > 0) {
            filter = EnvironmentBO.addFilterTerm(filter, "operationArea = ?_operationArea");
            parameters.put("_operationArea", operationArea);
        }
        if (dataLib != null && dataLib.length() > 0) {
            filter = EnvironmentBO.addFilterTerm(filter, "dataLib = ?_dataLib");
            parameters.put("_dataLib", dataLib);
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        EnvironmentManager manager = EnvironmentManagerFactory.getInstance();
        return manager.getFirstObject(query);
    }

    public static String update(Environment environment, String[] names, String[] shortNames, boolean accountingPrinciple2IsUsed, String[] apNames, String[] apShortNames, String description, String progLib, String bespokeWorkLib, String[] dircNames, String[] dircShortNames) throws Exception {
        boolean alreadyActive = EnvironmentBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            EnvironmentBO.updateExternalAnalysisGroups(environment, names, shortNames);
            environment.setName1(names[0]);
            environment.setName2(names[1]);
            environment.setName3(names[2]);
            environment.setName4(names[3]);
            environment.setName5(names[4]);
            environment.setNameDebtor(names[5]);
            environment.setNameCreditor(names[6]);
            environment.setNameRelation(names[7]);
            environment.setCMSName1(names[8]);
            environment.setCMSName2(names[9]);
            environment.setCMSName3(names[10]);
            environment.setShortName1(shortNames[0]);
            environment.setShortName2(shortNames[1]);
            environment.setShortName3(shortNames[2]);
            environment.setShortName4(shortNames[3]);
            environment.setShortName5(shortNames[4]);
            environment.setShortNameDebtor(shortNames[5]);
            environment.setShortNameCreditor(shortNames[6]);
            environment.setShortNameRelation(shortNames[7]);
            environment.setCMSShortName1(shortNames[8]);
            environment.setCMSShortName2(shortNames[9]);
            environment.setCMSShortName3(shortNames[10]);
            environment.setAccountingPrinciple2IsUsed(accountingPrinciple2IsUsed);
            environment.setAPName1(apNames[0]);
            environment.setAPName2(apNames[1]);
            environment.setAPName3(apNames[2]);
            environment.setAPName4(apNames[3]);
            environment.setAPShortName1(apShortNames[0]);
            environment.setAPShortName2(apShortNames[1]);
            environment.setAPShortName3(apShortNames[2]);
            environment.setAPShortName4(apShortNames[3]);
            environment.setDescription(description);
            environment.setProgramLib(progLib);
            environment.setBespokeWorkLib(bespokeWorkLib);
            environment.setDIRCName0(dircNames[0]);
            environment.setDIRCName1(dircNames[1]);
            environment.setDIRCName2(dircNames[2]);
            environment.setDIRCName3(dircNames[3]);
            environment.setDIRCName4(dircNames[4]);
            environment.setDIRCName5(dircNames[5]);
            environment.setDIRCShort0(dircShortNames[0]);
            environment.setDIRCShort1(dircShortNames[1]);
            environment.setDIRCShort2(dircShortNames[2]);
            environment.setDIRCShort3(dircShortNames[3]);
            environment.setDIRCShort4(dircShortNames[4]);
            environment.setDIRCShort5(dircShortNames[5]);
            EnvironmentBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return EnvironmentBO.investigate(e, dbTransaction);
        }
        return null;
    }

    private static void updateExternalAnalysisGroups(Environment environment, String[] names, String[] shortNames) throws Exception {
        if (!environment.getNameDebtor().trim().equals(names[5].trim()) || !environment.getShortNameDebtor().trim().equals(shortNames[5].trim())) {
            CompanyBO.updateExternalAnalysisGroups(environment, 1, names[5], shortNames[5]);
        }
        if (!environment.getNameCreditor().trim().equals(names[6].trim()) || !environment.getShortNameCreditor().trim().equals(shortNames[6].trim())) {
            CompanyBO.updateExternalAnalysisGroups(environment, 2, names[6], shortNames[6]);
        }
        if (!environment.getNameRelation().trim().equals(names[7].trim()) || !environment.getShortNameRelation().trim().equals(shortNames[7].trim())) {
            CompanyBO.updateExternalAnalysisGroups(environment, 3, names[7], shortNames[7]);
        }
        if (!environment.getCMSName1().trim().equals(names[8].trim()) || !environment.getCMSShortName1().trim().equals(shortNames[8].trim())) {
            CompanyBO.updateExternalAnalysisGroups(environment, 4, names[8], shortNames[8]);
        }
        if (!environment.getCMSName2().trim().equals(names[9].trim()) || !environment.getCMSShortName2().trim().equals(shortNames[9].trim())) {
            CompanyBO.updateExternalAnalysisGroups(environment, 5, names[9], shortNames[9]);
        }
        if (!environment.getCMSName3().trim().equals(names[10].trim()) || !environment.getCMSShortName3().trim().equals(shortNames[10].trim())) {
            CompanyBO.updateExternalAnalysisGroups(environment, 6, names[10], shortNames[10]);
        }
    }

    public static String delete(Environment environment) throws Exception {
        try {
            DBData dbBData = EnvironmentBO.getDBData(environment.getFacLib());
            DBConnectionPool.getInstance(dbBData).disconnectAll();
            LoginHelper loginHelper = new LoginHelper(StartStopServlet.getSystem(), StartStopServlet.getDatabaseUser(), StartStopServlet.getDatabasePassword(), StartStopServlet.getLibrary());
            String message = loginHelper.login();
            if (message != null) {
                throw new Exception(message);
            }
            String[] result = BatchJobHelper.runCommand(loginHelper, "DLTLIB LIB(" + environment.getFacLib() + ")");
            if (result != null && result[1] != null && !"CPC2194".equals(result[1])) {
                return result[0];
            }
            loginHelper.logout();
            EnvironmentBO.removeUserSettings(environment.getFacLib());
            environment.delete();
        }
        catch (Exception e) {
            return EnvironmentBO.investigate(e, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUserSettings(String context) throws Exception {
        ConnectionProvider provider = DBPersistenceManager.getConnectionProvider(DBData.getDefaultDBData("fac"));
        DBConnection dbc = provider.getConnection();
        StringBuffer buffer = new StringBuffer(64);
        try {
            buffer.append("DELETE FROM ");
            buffer.append(provider.getPrefix());
            buffer.append("JSQLUSRST");
            buffer.append(" WHERE ");
            buffer.append(" US_CONTEXT");
            buffer.append(" = '");
            buffer.append(context);
            buffer.append("'");
            dbc.executeUpdate(buffer.toString());
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    public static void queryEnvironments(LoginHelper loginHelper) throws Exception {
        for (Environment environment : EnvironmentManagerFactory.getInstance().getCollection(null)) {
            EnvironmentManager manager = EnvironmentManagerFactory.getInstance(EnvironmentBO.getDBData(environment.getFacLib()));
            manager.getFirstObject(null);
            BatchJobHelper.runCommand(loginHelper, "CHGLIB LIB(" + environment.getFacLib() + ") TEXT('" + environment.getDescription() + "')");
        }
    }
}

