/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.IncomingFinancialTransactionDataBean;
import nl.ibs.fac.db.IncomingFinancialTransactionManager;
import nl.ibs.fac.db.IncomingFinancialTransactionManagerFactory;
import nl.ibs.fac.db.IncomingFinancialTransactionPK;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionManager;
import nl.ibs.fac.db.TransactionManagerFactory;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class IncomingFinancialTransactionBO
extends BOAdapter {
    public static final String MAINACCOUNT_FROM = "MainAccountFrom";
    public static final String MAINACCOUNT_TO = "MainAccountTo";
    public static final String FINDIMID1_FROM = "FinDimId1From";
    public static final String FINDIMID1_TO = "FinDimId1To";
    public static final String FINDIMID2_FROM = "FinDimId2From";
    public static final String FINDIMID2_TO = "FinDimId2To";
    public static final String FINDIMID3_FROM = "FinDimId3From";
    public static final String FINDIMID3_TO = "FinDimId3To";
    public static final String FINDIMID4_FROM = "FinDimId4From";
    public static final String FINDIMID4_TO = "FinDimId4To";
    public static final String FINDIMID5_FROM = "FinDimId5From";
    public static final String FINDIMID5_TO = "FinDimId5To";
    public static final String CONFIRMED = "Confirmed";

    public static Object[] create(DBData dbData, String companyId, String id, String mainAccount, String finDimId1, String finDimId2, String finDimId3, String finDimId4, String finDimId5, BigDecimal transactionValue, int bookYear, int period, int internalInvoiceId, String description, Date bookDate, String voucherId, String documentId, String daybookId, BigDecimal unAllocatedValue, boolean confirmed, int systemItemNumber, int systemItemSequencenumber) throws Exception {
        Object[] result = new Object[2];
        IncomingFinancialTransactionManager manager = IncomingFinancialTransactionManagerFactory.getInstance(dbData);
        IncomingFinancialTransactionDataBean bean = new IncomingFinancialTransactionDataBean();
        bean.setCompanyId(companyId);
        bean.setId(id);
        bean.setMainAccount(mainAccount);
        bean.setFinDimId1(finDimId1);
        bean.setFinDimId2(finDimId2);
        bean.setFinDimId3(finDimId3);
        bean.setFinDimId4(finDimId4);
        bean.setFinDimId5(finDimId5);
        bean.setTransactionValue(transactionValue);
        bean.setBookYear(bookYear);
        bean.setPeriod(period);
        bean.setInternalInvoiceId(internalInvoiceId);
        bean.setDescription(description);
        bean.setBookDate(bookDate);
        bean.setVoucherId(voucherId);
        bean.setDocumentId(documentId);
        bean.setDaybookId(daybookId);
        bean.setUnAllocatedValue(unAllocatedValue);
        bean.setConfirmed(confirmed);
        bean.setSystemItemNumber(systemItemNumber);
        bean.setSystemItemSequencenumber(systemItemSequencenumber);
        boolean alreadyActive = IncomingFinancialTransactionBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            IncomingFinancialTransactionBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = IncomingFinancialTransactionBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(IncomingFinancialTransaction incomingFinancialTransaction, BigDecimal unAllocatedValue) throws Exception {
        boolean alreadyActive = IncomingFinancialTransactionBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            incomingFinancialTransaction.setUnAllocatedValue(unAllocatedValue);
            IncomingFinancialTransactionBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return IncomingFinancialTransactionBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static Collection getTransactions(IncomingFinancialTransaction incomingFinancialTransaction) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(incomingFinancialTransaction.getDBData());
        ExecutableQuery query = QueryFactory.create(Transaction.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = IncomingFinancialTransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", incomingFinancialTransaction.getCompanyId());
        filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "incomingFinancialTransactionId = ?_incomingFinancialTransactionId");
        parameters.put("_incomingFinancialTransactionId", incomingFinancialTransaction.getId());
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        return manager.getCollection(query);
    }

    public static Collection getIncomingFinancialTransactions(Map map) throws Exception {
        Boolean confirmed;
        String to;
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(IncomingFinancialTransaction.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String companyId = (String)map.get("Company");
        String filter = IncomingFinancialTransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        String from = (String)map.get(MAINACCOUNT_FROM);
        if (from != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "mainAccount >= ?_fromId");
            parameters.put("_fromId", from);
        }
        if ((to = (String)map.get(MAINACCOUNT_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "mainAccount <= ?_toId");
            parameters.put("_toId", to);
        }
        if ((from = (String)map.get(FINDIMID1_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId1 >= ?_fromFinDimId1");
            parameters.put("_fromFinDimId1", from);
        }
        if ((to = (String)map.get(FINDIMID1_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId1 <= ?_toFinDimId1");
            parameters.put("_toFinDimId1", to);
        }
        if ((from = (String)map.get(FINDIMID2_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId2 >= ?_fromFinDimId2");
            parameters.put("_fromFinDimId2", from);
        }
        if ((to = (String)map.get(FINDIMID2_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId2 <= ?_toFinDimId2");
            parameters.put("_toFinDimId2", to);
        }
        if ((from = (String)map.get(FINDIMID3_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId3 >= ?_fromFinDimId3");
            parameters.put("_fromFinDimId3", from);
        }
        if ((to = (String)map.get(FINDIMID3_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId3 <= ?_toFinDimId3");
            parameters.put("_toFinDimId3", to);
        }
        if ((from = (String)map.get(FINDIMID4_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId4 >= ?_fromFinDimId4");
            parameters.put("_fromFinDimId4", from);
        }
        if ((to = (String)map.get(FINDIMID4_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId4 <= ?_toFinDimId4");
            parameters.put("_toFinDimId4", to);
        }
        if ((from = (String)map.get(FINDIMID5_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId5 >= ?_fromFinDimId5");
            parameters.put("_fromFinDimId5", from);
        }
        if ((to = (String)map.get(FINDIMID5_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId5 <= ?_toFinDimId5");
            parameters.put("_toFinDimId5", to);
        }
        if ((confirmed = (Boolean)map.get(CONFIRMED)) != null) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "confirmed = ?_confirmed");
            parameters.put("_confirmed", confirmed);
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        IncomingFinancialTransactionBO.addOrdering(query, map, "id");
        IncomingFinancialTransactionManager manager = IncomingFinancialTransactionManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }

    public static Collection getIncomingFinancialTransactions(Map map, boolean ICFT) throws Exception {
        Boolean confirmed;
        String to;
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(IncomingFinancialTransaction.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String companyId = (String)map.get("Company");
        String filter = IncomingFinancialTransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        String from = (String)map.get("BookYearFrom");
        if (from != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, " ((bookYear = ?_fromBookyear");
            parameters.put("_fromBookyear", from);
        }
        if ((from = (String)map.get("PeriodFrom")) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "period >= ?_fromPeriod) ");
            parameters.put("_fromPeriod", from);
        }
        if ((to = (String)map.get("BookYearTo")) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addOrFilterTerm(filter, " (bookYear = ?_toBookyear");
            parameters.put("_toBookyear", to);
        }
        if ((to = (String)map.get("PeriodTo")) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "period <= ?_toPeriod) ");
            parameters.put("_toPeriod", to);
        }
        if ((from = (String)map.get("BookYearFrom")) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addOrFilterTerm(filter, " (bookYear > ?_fromBookyear");
            parameters.put("_fromBookyear", from);
        }
        if ((to = (String)map.get("BookYearTo")) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "bookYear < ?_toBookyear)) ");
            parameters.put("_toBookyear", to);
        }
        if ((from = (String)map.get(MAINACCOUNT_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "mainAccount >= ?_fromId");
            parameters.put("_fromId", from);
        }
        if ((to = (String)map.get(MAINACCOUNT_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "mainAccount <= ?_toId");
            parameters.put("_toId", to);
        }
        if ((from = (String)map.get(FINDIMID1_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId1 >= ?_fromFinDimId1");
            parameters.put("_fromFinDimId1", from);
        }
        if ((to = (String)map.get(FINDIMID1_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId1 <= ?_toFinDimId1");
            parameters.put("_toFinDimId1", to);
        }
        if ((from = (String)map.get(FINDIMID2_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId2 >= ?_fromFinDimId2");
            parameters.put("_fromFinDimId2", from);
        }
        if ((to = (String)map.get(FINDIMID2_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId2 <= ?_toFinDimId2");
            parameters.put("_toFinDimId2", to);
        }
        if ((from = (String)map.get(FINDIMID3_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId3 >= ?_fromFinDimId3");
            parameters.put("_fromFinDimId3", from);
        }
        if ((to = (String)map.get(FINDIMID3_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId3 <= ?_toFinDimId3");
            parameters.put("_toFinDimId3", to);
        }
        if ((from = (String)map.get(FINDIMID4_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId4 >= ?_fromFinDimId4");
            parameters.put("_fromFinDimId4", from);
        }
        if ((to = (String)map.get(FINDIMID4_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId4 <= ?_toFinDimId4");
            parameters.put("_toFinDimId4", to);
        }
        if ((from = (String)map.get(FINDIMID5_FROM)) != null && from.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId5 >= ?_fromFinDimId5");
            parameters.put("_fromFinDimId5", from);
        }
        if ((to = (String)map.get(FINDIMID5_TO)) != null && to.length() > 0) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "finDimId5 <= ?_toFinDimId5");
            parameters.put("_toFinDimId5", to);
        }
        if ((confirmed = (Boolean)map.get(CONFIRMED)) != null) {
            filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "confirmed = ?_confirmed");
            parameters.put("_confirmed", confirmed);
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        IncomingFinancialTransactionBO.addOrdering(query, map, "id");
        IncomingFinancialTransactionManager manager = IncomingFinancialTransactionManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }

    public static Object[] get(Company company, String id) throws Exception {
        Object[] result = new Object[2];
        IncomingFinancialTransactionPK key = new IncomingFinancialTransactionPK();
        key.setCompanyId(company.getId());
        key.setId(id);
        try {
            result[0] = IncomingFinancialTransactionManagerFactory.getInstance(company.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection retrieveNewInvestmentCreditTransactions(Company company, String mainAccountId) throws Exception {
        ExecutableQuery query = QueryFactory.create(IncomingFinancialTransaction.class);
        query.setCacheable(true);
        String filter = IncomingFinancialTransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "mainAccount = ?_mainAccountId");
        filter = IncomingFinancialTransactionBO.addFilterTerm(filter, "isNew = ?_isNew");
        query.setFilter(filter);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("_companyId", company.getId());
        parameters.put("_mainAccountId", mainAccountId);
        parameters.put("_isNew", new Boolean(true));
        query.setParameters(parameters);
        IncomingFinancialTransactionManager manager = IncomingFinancialTransactionManagerFactory.getInstance(company.getDBData());
        return manager.getCollection(query);
    }
}

