/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.InterestBookYear;
import nl.ibs.fac.db.InterestBookYearDataBean;
import nl.ibs.fac.db.InterestBookYearManager;
import nl.ibs.fac.db.InterestBookYearManagerFactory;
import nl.ibs.fac.db.InterestBookYearPK;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.exception.FinderException;

public abstract class InterestBookYearBO
extends BOAdapter {
    public static void create(DBData dbData, String interestTableId, int bookYear) throws Exception {
        InterestBookYearManager manager = InterestBookYearManagerFactory.getInstance(dbData);
        InterestBookYearDataBean bean = new InterestBookYearDataBean();
        bean.setInterestTableId(interestTableId);
        bean.setBookYear(bookYear);
        bean.setRecalculationPercentage(new BigDecimal("0.000"));
        manager.create(bean);
    }

    public static String delete(InterestBookYear interestBookYear) throws Exception {
        try {
            interestBookYear.delete();
        }
        catch (Exception e) {
            return InterestBookYearBO.investigate(e, null);
        }
        return null;
    }

    public static boolean checkExistence(InterestTable table, int year) throws Exception {
        InterestBookYearPK pk = new InterestBookYearPK();
        pk.setInterestTableId(table.getId());
        pk.setBookYear(year);
        try {
            InterestBookYearManagerFactory.getInstance(table.getDBData()).findByPrimaryKey(pk);
        }
        catch (FinderException e) {
            return false;
        }
        return true;
    }
}

