/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.InterestBookYearBO;
import nl.ibs.fac.boadapters.InterestPeriodBO;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.InterestTableDataBean;
import nl.ibs.fac.db.InterestTableManager;
import nl.ibs.fac.db.InterestTableManagerFactory;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class InterestTableBO
extends BOAdapter {
    public static final String FROMID = "FromInterestTable";
    public static final String TOID = "ToInterestTable";

    public static Collection getInterestTables(Map map) throws Exception {
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(InterestTable.class);
        query.setCacheable(true);
        if (map != null) {
            String toId;
            HashMap<String, String> parameters = new HashMap<String, String>();
            String filter = null;
            String fromId = (String)map.get(FROMID);
            if (fromId != null && fromId.length() > 0) {
                filter = InterestTableBO.addFilterTerm(filter, "id >= ?_fromId");
                parameters.put("_fromId", fromId);
            }
            if ((toId = (String)map.get(TOID)) != null && toId.length() > 0) {
                filter = InterestTableBO.addFilterTerm(filter, "id <= ?_toId");
                parameters.put("_toId", toId);
            }
            if (Log.debug()) {
                Log.debug((String)("Filter: " + filter));
                Log.debug((String)("Parameters: " + parameters));
            }
            query.setFilter(filter);
            query.setParameters(parameters);
        }
        InterestTableBO.addOrdering(query, map, "id");
        InterestTableManager manager = InterestTableManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }

    public static Object[] get(DBData dbData, String id, int numberOfPeriods) throws Exception {
        Object[] result = new Object[2];
        try {
            result[0] = InterestTableManagerFactory.getInstance(dbData).findByPrimaryKey(id);
            InterestTable interestTable = (InterestTable)result[0];
            if (numberOfPeriods != 0 && interestTable.getNumberOfPeriods() != numberOfPeriods) {
                result[0] = null;
                result[1] = "key_not_found";
            }
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(DBData dbData, String id, String desc, int numOfPer, int firstYear, int firstPeriod, BigDecimal firstPercentage) throws Exception {
        Object[] result = new Object[2];
        InterestTableManager manager = InterestTableManagerFactory.getInstance(dbData);
        InterestTableDataBean bean = new InterestTableDataBean();
        bean.setId(id);
        bean.setDescription(desc);
        bean.setNumberOfPeriods(numOfPer);
        try {
            result[0] = manager.create(bean);
            if (result[0] != null) {
                InterestBookYearBO.create(dbData, id, firstYear);
                InterestPeriodBO.createFirstPercentage(dbData, id, firstYear, firstPeriod, firstPercentage);
            }
        }
        catch (Exception e) {
            result[1] = InterestTableBO.investigate(e, null);
        }
        return result;
    }

    public static String update(InterestTable interest, String desc, int numOfPer) throws Exception {
        InterestTableDataBean bean = new InterestTableDataBean();
        bean.setId(interest.getId());
        bean.setDescription(desc);
        bean.setNumberOfPeriods(numOfPer);
        boolean alreadyActive = InterestTableBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            interest.update(bean);
            InterestTableBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return InterestTableBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(InterestTable interestTable) throws Exception {
        try {
            interestTable.delete();
        }
        catch (Exception e) {
            return InterestTableBO.investigate(e, null);
        }
        return null;
    }
}

