/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.db.MainAccountSchemeDataBean;
import nl.ibs.fac.db.MainAccountSchemeManager;
import nl.ibs.fac.db.MainAccountSchemeManagerFactory;
import nl.ibs.fac.db.MainAccountSchemePK;
import nl.ibs.fac.db.Transaction;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.exception.FinderException;

public abstract class MainAccountSchemeBO
extends BOAdapter {
    public static Object[] get(DBData dbData, String companyId, String typeId, int accountingPrinciple, int bookYearFrom, int periodFrom) throws Exception {
        Object[] result = new Object[2];
        MainAccountSchemePK key = new MainAccountSchemePK();
        key.setCompanyId(companyId);
        key.setTypeId(typeId);
        key.setAccountingPrinciple(accountingPrinciple);
        key.setBookYearFrom(bookYearFrom);
        key.setPeriodFrom(periodFrom);
        try {
            result[0] = MainAccountSchemeManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static MainAccountScheme getMainAccountSchemeToUse(AssetType assetType, Transaction transaction) throws Exception {
        return MainAccountSchemeBO.getMainAccountSchemeToUse(assetType, transaction.getAccountingPrinciple(), transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization());
    }

    public static MainAccountScheme getMainAccountSchemeToUse(AssetType assetType, int accountingPrinciple, int theYear, int thePeriod) throws Exception {
        MainAccountScheme mainAccountSchemeToUse = null;
        int bookYear = 0;
        int period = 0;
        for (MainAccountScheme mainAccountScheme : assetType.getMainAccountSchemeCollection(null)) {
            int periodFrom;
            int bookYearFrom;
            if (mainAccountScheme.getAccountingPrinciple() != accountingPrinciple || PeriodHelper.isBefore(theYear, thePeriod, bookYearFrom = mainAccountScheme.getBookYearFrom(), periodFrom = mainAccountScheme.getPeriodFrom()) || !PeriodHelper.isAfter(bookYearFrom, periodFrom, bookYear, period)) continue;
            bookYear = bookYearFrom;
            period = periodFrom;
            mainAccountSchemeToUse = mainAccountScheme;
        }
        return mainAccountSchemeToUse;
    }

    public static Object[] create(DBData dbData, String companyId, String typeId, int accountingPrinciple, int bookYearFrom, int periodFrom, String mainAccountId1, String mainAccountId2, String mainAccountId3, String mainAccountId4, String mainAccountId5, String mainAccountId6, String mainAccountId7, String mainAccountId8, String mainAccountId9, String mainAccountId10, String mainAccountId11) throws Exception {
        Object[] result = new Object[2];
        MainAccountSchemeManager manager = MainAccountSchemeManagerFactory.getInstance(dbData);
        MainAccountSchemeDataBean bean = new MainAccountSchemeDataBean();
        bean.setCompanyId(companyId);
        bean.setTypeId(typeId);
        bean.setAccountingPrinciple(accountingPrinciple);
        bean.setBookYearFrom(bookYearFrom);
        bean.setPeriodFrom(periodFrom);
        bean.setMainAccountId1(mainAccountId1);
        bean.setMainAccountId2(mainAccountId2);
        bean.setMainAccountId3(mainAccountId3);
        bean.setMainAccountId4(mainAccountId4);
        bean.setMainAccountId5(mainAccountId5);
        bean.setMainAccountId6(mainAccountId6);
        bean.setMainAccountId7(mainAccountId7);
        bean.setMainAccountId8(mainAccountId8);
        bean.setMainAccountId9(mainAccountId9);
        bean.setMainAccountId10(mainAccountId10);
        bean.setMainAccountId11(mainAccountId11);
        try {
            result[0] = manager.create(bean);
        }
        catch (Exception e) {
            result[1] = MainAccountSchemeBO.investigate(e, null);
        }
        return result;
    }

    public static String update(MainAccountScheme mainAccountScheme, String mainAccountId1, String mainAccountId2, String mainAccountId3, String mainAccountId4, String mainAccountId5, String mainAccountId6, String mainAccountId7, String mainAccountId8, String mainAccountId9, String mainAccountId10, String mainAccountId11) throws Exception {
        boolean alreadyActive = MainAccountSchemeBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            mainAccountScheme.setMainAccountId1(mainAccountId1);
            mainAccountScheme.setMainAccountId2(mainAccountId2);
            mainAccountScheme.setMainAccountId3(mainAccountId3);
            mainAccountScheme.setMainAccountId4(mainAccountId4);
            mainAccountScheme.setMainAccountId5(mainAccountId5);
            mainAccountScheme.setMainAccountId6(mainAccountId6);
            mainAccountScheme.setMainAccountId7(mainAccountId7);
            mainAccountScheme.setMainAccountId8(mainAccountId8);
            mainAccountScheme.setMainAccountId9(mainAccountId9);
            mainAccountScheme.setMainAccountId10(mainAccountId10);
            mainAccountScheme.setMainAccountId11(mainAccountId11);
            MainAccountSchemeBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return MainAccountSchemeBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(MainAccountScheme mainAccountScheme) throws Exception {
        try {
            mainAccountScheme.delete();
        }
        catch (Exception e) {
            return MainAccountSchemeBO.investigate(e, null);
        }
        return null;
    }
}

