/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.Memo;
import nl.ibs.fac.db.MemoDataBean;
import nl.ibs.fac.db.MemoManager;
import nl.ibs.fac.db.MemoManagerFactory;
import nl.ibs.fac.db.MemoPK;
import nl.ibs.fac.db.TotalEstimationTransaction;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.exception.FinderException;

public abstract class MemoBO
extends BOAdapter {
    public static Object[] get(Asset asset) throws Exception {
        Object[] result = new Object[2];
        MemoPK key = new MemoPK();
        key.setCompanyId(asset.getCompanyId());
        key.setCora(asset.getCora());
        key.setAssetId(asset.getId());
        key.setTransactionNumber(0);
        try {
            result[0] = MemoManagerFactory.getInstance(asset.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] get(Credit credit) throws Exception {
        Object[] result = new Object[2];
        MemoPK key = new MemoPK();
        key.setCompanyId(credit.getCompanyId());
        key.setCora("C");
        key.setAssetId(credit.getId());
        key.setTransactionNumber(0);
        try {
            result[0] = MemoManagerFactory.getInstance(credit.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] get(TotalEstimationTransaction transaction) throws Exception {
        Object[] result = new Object[2];
        MemoPK key = new MemoPK();
        key.setCompanyId(transaction.getCompanyId());
        key.setCora("C");
        key.setAssetId(transaction.getCreditId());
        key.setTransactionNumber(transaction.getInternalNumber());
        try {
            result[0] = MemoManagerFactory.getInstance(transaction.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(Asset asset, String text) throws Exception {
        Object[] result = new Object[2];
        MemoManager manager = MemoManagerFactory.getInstance(asset.getDBData());
        MemoDataBean bean = new MemoDataBean();
        bean.setCompanyId(asset.getCompanyId());
        bean.setCora(asset.getCora());
        bean.setAssetId(asset.getId());
        bean.setTransactionNumber(0);
        bean.setMemo(text);
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            asset.setHasMemo(true);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = MemoBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static Object[] create(Credit credit, String text) throws Exception {
        Object[] result = new Object[2];
        MemoManager manager = MemoManagerFactory.getInstance(credit.getDBData());
        MemoDataBean bean = new MemoDataBean();
        bean.setCompanyId(credit.getCompanyId());
        bean.setCora("C");
        bean.setAssetId(credit.getId());
        bean.setTransactionNumber(0);
        bean.setMemo(text);
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            credit.setHasMemo(true);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = MemoBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static Object[] create(TotalEstimationTransaction transaction, String text) throws Exception {
        Object[] result = new Object[2];
        MemoManager manager = MemoManagerFactory.getInstance(transaction.getDBData());
        MemoDataBean bean = new MemoDataBean();
        bean.setCompanyId(transaction.getCompanyId());
        bean.setCora("C");
        bean.setAssetId(transaction.getCreditId());
        bean.setTransactionNumber(transaction.getInternalNumber());
        bean.setMemo(text);
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            transaction.setHasMemo(true);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = MemoBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(Asset asset, Memo memo, String text) throws Exception {
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            memo.setMemo(text);
            asset.setHasMemo(true);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return MemoBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String update(Credit credit, Memo memo, String text) throws Exception {
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            memo.setMemo(text);
            credit.setHasMemo(true);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return MemoBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String update(TotalEstimationTransaction transaction, Memo memo, String text) throws Exception {
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            memo.setMemo(text);
            transaction.setHasMemo(true);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return MemoBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(Asset asset, Memo memo) throws Exception {
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            memo.delete();
            asset.setHasMemo(false);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return MemoBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(Credit credit, Memo memo) throws Exception {
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            memo.delete();
            credit.setHasMemo(false);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return MemoBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(TotalEstimationTransaction transaction, Memo memo) throws Exception {
        boolean alreadyActive = MemoBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            memo.delete();
            transaction.setHasMemo(false);
            MemoBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return MemoBO.investigate(e, dbTransaction);
        }
        return null;
    }
}

