/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.ibs.fac.MenuOptionValue;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.MenuOption;
import nl.ibs.fac.db.MenuOptionDataBean;
import nl.ibs.fac.db.MenuOptionManager;
import nl.ibs.fac.db.MenuOptionManagerFactory;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public abstract class MenuOptionBO
extends BOAdapter {
    public static void revokeAll(String userGroupId) throws Exception {
        if (Log.debug()) {
            Log.debug((String)("revokeAll for userGroupId: " + userGroupId));
        }
        MenuOptionManager manager = MenuOptionManagerFactory.getInstance();
        manager.generalDelete("userGroupId = " + MenuOptionBO.escapeSingleQuotes(userGroupId));
    }

    public static void copyAll(String userGroupId, String toUserGroupId) throws Exception {
        if (Log.debug()) {
            Log.debug((String)("copyAll from userGroupId: " + userGroupId));
            Log.debug((String)("copyAll to userGroupId: " + toUserGroupId));
        }
        MenuOptionManager manager = MenuOptionManagerFactory.getInstance();
        for (MenuOption menuOption : MenuOptionBO.getMenuOptions(userGroupId)) {
            MenuOptionDataBean bean = new MenuOptionDataBean();
            bean.setUserGroupId(toUserGroupId);
            bean.setMenuOption(menuOption.getMenuOption());
            manager.create(bean);
        }
    }

    public static List getOptions(String userGroupId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (MenuOption menuOption : MenuOptionBO.getMenuOptions(userGroupId)) {
            list.add(menuOption.getMenuOption());
        }
        return list;
    }

    public static void addOptions(String userGroupId, List menuOptions) throws Exception {
        MenuOptionManager manager = MenuOptionManagerFactory.getInstance();
        for (MenuOptionValue menuOptionValue : menuOptions) {
            MenuOptionDataBean bean = new MenuOptionDataBean();
            bean.setUserGroupId(userGroupId);
            bean.setMenuOption(menuOptionValue.getValue());
            manager.create(bean);
        }
    }

    private static Collection getMenuOptions(String userGroupId) throws Exception {
        if (Log.debug()) {
            Log.debug((String)("getCollection for userGroupId: " + userGroupId));
        }
        ExecutableQuery query = QueryFactory.create(MenuOption.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = MenuOptionBO.addFilterTerm(null, "userGroupId = ?_userGroupId");
        parameters.put("_userGroupId", userGroupId);
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        return query.getCollection();
    }
}

