/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.User;
import nl.ibs.fac.db.UserDataBean;
import nl.ibs.fac.db.UserGroup;
import nl.ibs.fac.db.UserManager;
import nl.ibs.fac.db.UserManagerFactory;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.UserSettings;
import nl.ibs.jsql.exception.FinderException;

public abstract class UserBO
extends BOAdapter {
    public static Object[] get(String id) throws Exception {
        Object[] result = new Object[2];
        try {
            result[0] = UserManagerFactory.getInstance().findByPrimaryKey(id);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(String id, String description, String userGroupId, boolean admin, boolean oneEnvironment, Environment environment, boolean selectCompany, boolean checkCurrentBatchHasTransactions) throws Exception {
        Object[] result = new Object[2];
        UserManager manager = UserManagerFactory.getInstance();
        UserDataBean bean = new UserDataBean();
        bean.setId(id);
        bean.setDescription(description);
        bean.setUserGroupId(userGroupId);
        bean.setAdmin(admin);
        bean.setOneEnvironment(oneEnvironment);
        if (oneEnvironment) {
            bean.setFacLib(environment.getFacLib());
        }
        bean.setSelectCompany(selectCompany);
        bean.setCheckCurrentTransactionBatchHasTransactions(checkCurrentBatchHasTransactions);
        boolean alreadyActive = UserBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            User user = manager.create(bean);
            result[0] = user;
            UserBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = UserBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(User user, String description, UserGroup userGroup, boolean admin, boolean oneEnvironment, Environment environment, boolean selectCompany, boolean checkCurrentBatchHasTransactions) throws Exception {
        boolean alreadyActive = UserBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            user.setDescription(description);
            user.setUserGroup(userGroup);
            user.setAdmin(admin);
            user.setOneEnvironment(oneEnvironment);
            if (oneEnvironment) {
                user.setFacLib(environment.getFacLib());
            }
            user.setSelectCompany(selectCompany);
            user.setCheckCurrentTransactionBatchHasTransactions(checkCurrentBatchHasTransactions);
            UserBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return UserBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String update(User user, String facLib, String companyId) throws Exception {
        if (user == null) {
            return null;
        }
        boolean alreadyActive = UserBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            if (!user.getOneEnvironment()) {
                user.setFacLib(facLib);
            }
            user.setCompanyId(companyId);
            UserBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return UserBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(User user) throws Exception {
        try {
            new UserSettings("fac", user.getId()).remove(true);
            user.delete();
        }
        catch (Exception e) {
            return UserBO.investigate(e, null);
        }
        return null;
    }
}

