/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.WozValue;
import nl.ibs.fac.db.WozValueDataBean;
import nl.ibs.fac.db.WozValueManager;
import nl.ibs.fac.db.WozValueManagerFactory;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class WozValueBO
extends BOAdapter {
    public static Collection getWozValues(Asset parentAsset) throws Exception {
        ExecutableQuery query = QueryFactory.create(WozValue.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = WozValueBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", parentAsset.getCompanyId());
        filter = WozValueBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", parentAsset.getId());
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        WozValueManager manager = WozValueManagerFactory.getInstance(parentAsset.getDBData());
        return manager.getCollection(query);
    }

    public static Object[] create(DBData dbData, String companyId, String cora, String assetId, int wozValueYear, int wozValuePeriod, BigDecimal wozValue, BigDecimal limitValuePercentage, int ap1LimitValueYear, int ap1LimitValuePeriod, BigDecimal ap1LimitAmount, int ap2LimitValueYear, int ap2LimitValuePeriod, BigDecimal ap2LimitAmount) throws Exception {
        Object[] result = new Object[2];
        WozValueManager manager = WozValueManagerFactory.getInstance(dbData);
        WozValueDataBean bean = new WozValueDataBean();
        bean.setCompanyId(companyId);
        bean.setCora(cora);
        bean.setAssetId(assetId);
        bean.setWOZValueYear(wozValueYear);
        bean.setWOZValuePeriod(wozValuePeriod);
        bean.setWOZAmount(wozValue);
        bean.setLimitValuePercentage(limitValuePercentage);
        bean.setLimitValueYear1(ap1LimitValueYear);
        bean.setLimitValuePeriod1(ap1LimitValuePeriod);
        bean.setLimitAmount1(ap1LimitAmount);
        bean.setLimitValueYear2(ap2LimitValueYear);
        bean.setLimitValuePeriod2(ap2LimitValuePeriod);
        bean.setLimitAmount2(ap2LimitAmount);
        boolean alreadyActive = WozValueBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            WozValueBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = WozValueBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(WozValue wozValue, BigDecimal wozAmount, BigDecimal limitValuePercentage, BigDecimal ap1LimitAmount, int ap1LimitYear, int ap1LimitPeriod, BigDecimal ap2LimitAmount, int ap2LimitYear, int ap2LimitPeriod) throws Exception {
        boolean alreadyActive = WozValueBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            wozValue.setWOZAmount(wozAmount);
            wozValue.setLimitValuePercentage(limitValuePercentage);
            wozValue.setLimitAmount1(ap1LimitAmount);
            wozValue.setLimitValueYear1(ap1LimitYear);
            wozValue.setLimitValuePeriod1(ap1LimitPeriod);
            wozValue.setLimitAmount2(ap2LimitAmount);
            wozValue.setLimitValueYear2(ap2LimitYear);
            wozValue.setLimitValuePeriod2(ap2LimitPeriod);
            WozValueBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return WozValueBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static WozValue getLastWozValue(DBData dbData, String companyId, String cora, String assetId) throws Exception {
        String sql = "companyId = ?_companyId AND cora = ?_cora AND assetId = ?_assetId";
        ExecutableQuery qry = QueryFactory.create(WozValue.class, sql, "wOZValueYear descending, wOZValuePeriod descending");
        qry.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", companyId);
        parameters.put("_cora", cora);
        parameters.put("_assetId", assetId);
        qry.setParameters(parameters);
        WozValueManager manager = WozValueManagerFactory.getInstance(dbData);
        return manager.getFirstObject(qry);
    }

    public static String delete(Asset asset, WozValue wozValue) throws Exception {
        Object[] result = ValuationBO.getLastDepreciatedPeriod(asset, 1);
        int lastDepreciationBookYearAp1 = Integer.parseInt((String)result[0]);
        int lastDepreciationPeriodAp1 = Integer.parseInt((String)result[1]);
        result = ValuationBO.getLastDepreciatedPeriod(asset, 2);
        int lastDepreciationBookYearAp2 = Integer.parseInt((String)result[0]);
        int lastDepreciationPeriodAp2 = Integer.parseInt((String)result[1]);
        if (!PeriodHelper.isAfter(wozValue.getLimitValueYear1(), wozValue.getLimitValuePeriod1(), lastDepreciationBookYearAp1, lastDepreciationPeriodAp1)) {
            return "Periode ligt niet na de laatste afgeschreven periode";
        }
        if (!PeriodHelper.isAfter(wozValue.getLimitValueYear2(), wozValue.getLimitValuePeriod2(), lastDepreciationBookYearAp2, lastDepreciationPeriodAp2)) {
            return "Periode ligt niet na de laatste afgeschreven periode";
        }
        try {
            wozValue.delete();
        }
        catch (Exception e) {
            return WozValueBO.investigate(e, null);
        }
        return null;
    }
}

