/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class AdditionalDepreciationBP
extends GenericTransactionBP {
    private static final long serialVersionUID = -1812885065510527986L;
    private Valuation[] valuations = new Valuation[2];
    private int[] facYears = new int[2];
    private int[] facPeriods = new int[2];
    private int[] finYears = new int[2];
    private int[] finPeriods = new int[2];
    private BigDecimal[] ads = new BigDecimal[2];
    private BigDecimal[] ais = new BigDecimal[2];
    private String description;

    public AdditionalDepreciationBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public String[] retrieveYearsAndPeriods(Valuation valuation) throws Exception {
        String[] yps = new String[4];
        if (this.company.getLastDepreciationRunYear() != 0) {
            int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
            yps[0] = "" + nextPeriod[0];
            yps[1] = "" + nextPeriod[1];
        } else if (valuation.getStartDepreciationBookYear() != 0) {
            yps[0] = "" + valuation.getStartDepreciationBookYear();
            yps[1] = "" + valuation.getStartDepreciationPeriod();
        } else {
            yps[0] = "" + this.asset.getStartUseYear();
            yps[1] = "" + this.asset.getStartUsePeriod();
        }
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    public String[] validateFACYearAndPeriod(Valuation valuation, int facYear, int facPeriod) throws Exception {
        int status;
        int thePeriod;
        String[] messages = new String[2];
        int index = 0;
        int theYear = valuation.getStartDepreciationBookYear();
        if (PeriodHelper.isBefore(facYear, facPeriod, theYear, thePeriod = valuation.getStartDepreciationPeriod())) {
            messages[index] = "FACPeriodBeforeStartDepreciationPeriod";
            ++index;
        }
        if (valuation.getLastDepreciationBookYear() == 0) {
            if (valuation.getDepreciationMethod() != 99 && PeriodHelper.isAfter(facYear, facPeriod, theYear, thePeriod)) {
                messages[index] = "FACPeriodAfterStartDepreciationPeriod";
                ++index;
            }
        } else {
            int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod());
            theYear = nextPeriod[0];
            if (PeriodHelper.isAfter(facYear, facPeriod, theYear, thePeriod = nextPeriod[1])) {
                messages[index] = "FACPeriodAfterCurrentPeriod";
                ++index;
            }
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateAmounts(BigDecimal bd1, BigDecimal bd2, BigDecimal bd3, BigDecimal bd4) throws Exception {
        String[] messages = new String[1];
        int index = 0;
        if (!(bd1 != null && bd1.doubleValue() != 0.0 || bd2 != null && bd2.doubleValue() != 0.0 || bd3 != null && bd3.doubleValue() != 0.0 || bd4 != null && bd4.doubleValue() != 0.0)) {
            messages[index] = "AtLeastOneAmountShouldBeEntered";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateDepreciationAmount(Asset asset, Valuation valuation, BigDecimal additionalDepreciationAmount) throws Exception {
        if (additionalDepreciationAmount == null) {
            return null;
        }
        String[] messages = new String[1];
        int index = 0;
        BigDecimal residualValue = valuation.getResidualValue();
        if (residualValue.doubleValue() == 0.0 && valuation.getResidualPercentage().doubleValue() > 0.0) {
            residualValue = valuation.getPostedAcquisitionBalance().multiply(valuation.getResidualPercentage());
        }
        BigDecimal limitValue = valuation.getPostedAcquisitionBalance().subtract(valuation.getPostedDepreciationBalance().subtract(residualValue));
        if (asset.getNegativeInvestment()) {
            if (additionalDepreciationAmount.doubleValue() < limitValue.doubleValue()) {
                messages[index] = "DepreciationAmountLessThanLimitValue";
                ++index;
            }
        } else if (additionalDepreciationAmount.doubleValue() > limitValue.doubleValue()) {
            messages[index] = "DepreciationAmountGreaterThanLimitValue";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String createAdditionalDepreciation(Asset asset, Valuation[] valuations, int[] facYears, int[] facPeriods, int[] finYears, int[] finPeriods, BigDecimal[] ads, BigDecimal[] ais, String description, String user) throws Exception {
        String message = null;
        this.asset = asset;
        this.valuations = valuations;
        this.facYears = facYears;
        this.facPeriods = facPeriods;
        this.finYears = finYears;
        this.finPeriods = finPeriods;
        this.ads = ads;
        this.ais = ais;
        this.description = description;
        this.user = user;
        this.documentNr = 0;
        this.seqNr = 0;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            if ((ads[0].doubleValue() != 0.0 || ais[0].doubleValue() != 0.0) && (message = this.createTransaction(0)) != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            if (valuations[1] != null && (ads[1].doubleValue() != 0.0 || ais[1].doubleValue() != 0.0) && (message = this.createTransaction(1)) != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private String createTransaction(int index) throws Exception {
        Object[] objects;
        String message = null;
        if (this.finYears[index] == 0) {
            this.finBookYear = this.facYears[index];
            this.finBookPeriod = this.facPeriods[index];
        } else {
            this.finBookYear = this.finYears[index];
            this.finBookPeriod = this.finPeriods[index];
        }
        this.retrieveFinancialDimensions(this.facYears[index], this.facPeriods[index]);
        if (this.description.equals("")) {
            this.description = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalDepreciationAndInterest");
            if (this.ais[index].doubleValue() == 0.0) {
                this.description = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalDepreciation");
            }
            if (this.ads[index].doubleValue() == 0.0) {
                this.description = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalInterest");
            }
        }
        if ((objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.description, this.asset.getCora(), this.asset.getId(), this.valuations[index].getAccountingPrinciple(), 3, 90, this.facYears[index], this.facPeriods[index], this.finBookYear, this.finBookPeriod, new BigDecimal(0), this.ads[index], this.ais[index], null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(this.valuations[index].getAccountingPrinciple(), 3), 0, -1, this.user, this.asset.getTypeId()))[0] == null) {
            message = (String)objects[1];
        } else {
            Transaction transaction = (Transaction)objects[0];
            AdditionalDepreciationBP.updatePostedDepreciationBalance(this.asset, this.valuations[index], transaction, false);
            transaction.setState(1);
            this.documentNr = transaction.getDocumentNr();
            if (!(!this.processParameters.getUseCorrectionCodeDC() || !this.asset.getNegativeInvestment() && this.ads[index].doubleValue() >= 0.0 && this.ais[index].doubleValue() >= 0.0 || this.asset.getNegativeInvestment() && this.ads[index].doubleValue() <= 0.0 && this.ais[index].doubleValue() <= 0.0)) {
                transaction.setCorrectionCodeDC("J");
            }
        }
        return message;
    }
}

