/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.boadapters.AssetAnalysisCodeBO;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetValueBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.db.ValuationManagerFactory;
import nl.ibs.fac.db.ValuationPK;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class AssetAssetTypeChangeBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 4122477805617250210L;
    private String description = "";
    private int batchId;
    private AssetPanels panels;
    private String typeOld;

    public AssetAssetTypeChangeBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public boolean validateForChangeType(Asset asset) throws Exception {
        if (asset.getStartUseYear() < this.company.getLastDepreciationRunYear()) {
            return false;
        }
        for (Transaction transaction : TransactionBO.getTransactions(asset)) {
            int type = transaction.getTransactionType();
            if (type == 70 || type == 10 || type == 20 || type == 120 || type == 80) continue;
            return false;
        }
        for (Transaction transaction : TransactionBO.getTransactions(this.company.getCurrentTransactionBatch())) {
            if (!asset.getId().equals(transaction.getAssetId())) continue;
            return false;
        }
        return true;
    }

    public String[] retrieveYearsAndPeriods(Asset asset) throws Exception {
        String[] yps = new String[4];
        yps[0] = "" + asset.getStartUseYear();
        yps[1] = "" + asset.getStartUsePeriod();
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    public String[] validateFACYearAndPeriod(Asset asset, int facYear, int facPeriod) throws Exception {
        int status;
        int thePeriod;
        int theYear;
        String[] messages = new String[2];
        int index = 0;
        if (asset != null && PeriodHelper.isBefore(facYear, facPeriod, theYear = asset.getStartUseYear(), thePeriod = asset.getStartUsePeriod())) {
            messages[index] = "FACPeriodBeforeStartUsePeriod";
            ++index;
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateTypeTo(AssetType typeFrom, AssetType typeTo) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        if (typeFrom.getId().equals(typeTo.getId())) {
            messages[index] = "types_equal";
            ++index;
        }
        if (typeFrom.getAccountingPrinciple2IsUsed() && !typeTo.getAccountingPrinciple2IsUsed()) {
            messages[index] = "type_has_noaccountingprinciple2";
            ++index;
        }
        if (!typeFrom.getAccountingPrinciple2IsUsed() && typeTo.getAccountingPrinciple2IsUsed()) {
            messages[index] = "type_has_accountingprinciple2";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String changeAssetType(Asset asset, AssetPanels panels, AssetType assetType, int facYear, int facPeriod, int finYear, int finPeriod, BigDecimal investmentValue, String user, int journalingState) throws Exception {
        String message = null;
        this.asset = asset;
        this.panels = panels;
        this.facYear = facYear;
        this.facPeriod = facPeriod;
        this.finYear = finYear;
        this.finPeriod = finPeriod;
        this.user = user;
        this.post = true;
        this.batchId = -1;
        this.documentNr = 0;
        this.seqNr = 0;
        this.description = LanguageHelper.getString("nl.ibs.fac.language", "ChangeType");
        this.description = this.description + " " + facYear + "/" + facPeriod;
        this.typeOld = asset.getAssetType().getId();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            int i;
            this.handleFinancialDimensions();
            message = AssetBO.update(asset, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5);
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            AssetBP assetBP = new AssetBP(panels);
            assetBP.setAsset(asset);
            assetBP.saveDimensions();
            for (AssetValue assetValue : AssetValueBO.getCollection(this.company.getDBData(), this.company.getId(), asset.getId())) {
                boolean delete = true;
                for (i = 0; i < panels.dimensionPanels.assetValue.length; ++i) {
                    if (!assetValue.equals(panels.dimensionPanels.assetValue[i])) continue;
                    delete = false;
                    break;
                }
                if (!delete) continue;
                assetValue.delete();
            }
            for (AssetAnalysisCode assetAnalysisCode : AssetAnalysisCodeBO.getCollection(this.company.getDBData(), this.company.getId(), asset.getId())) {
                boolean delete = true;
                for (int i2 = 0; i2 < panels.dimensionPanels.assetAnalysisCode.length; ++i2) {
                    if (!assetAnalysisCode.equals(panels.dimensionPanels.assetAnalysisCode[i2])) continue;
                    delete = false;
                    break;
                }
                if (!delete) continue;
                assetAnalysisCode.delete();
            }
            for (i = 0; i <= panels.apTabCountMax; ++i) {
                message = ValuationBO.update(this.company.getDBData(), panels.valuation[i], panels.currentCapitalization, panels.deprTotal[i].getBigDecimal(), panels.nbrOfDeprPers[i].getIntValue(), Integer.parseInt(panels.depreciationMethod[i].getValue()), panels.degressivePercentage[i].getBigDecimal(), panels.annuityInterestTableId[i].getValue(), panels.annuityPercentage[i].getBigDecimal(), panels.yearPercentageTableId[i].getValue(), Integer.parseInt(panels.startPeriodHandlingMethod[i].getValue()), panels.startDepreciation[i].getBookYear().getIntValue(), panels.startDepreciation[i].getPeriod().getIntValue(), panels.depreciatableLife[i].getIntValue(), panels.residualValue[i].getBigDecimal(), panels.residualPercentage[i].getBigDecimal(), panels.depreciationPaused[i].getValueAsBoolean(), Integer.parseInt(panels.interestCalculationMethod[i].getValue()), panels.interestTableId[i].getValue(), this.numberOfPeriods, panels.interestPercentage[i].getBigDecimal(), panels.startInterest[i].getBookYear().getIntValue(), panels.startInterest[i].getPeriod().getIntValue(), panels.beyondEconomicLifePercentage[i].getBigDecimal());
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                panels.valuation[i].setStartDepreciationBookYear(facYear);
                panels.valuation[i].setStartDepreciationPeriod(facPeriod);
            }
            if (panels.mainAccountIds != null) {
                Iterator<Object> iterator = ValuationMainAccountBO.getCollection(this.company.getDBData(), this.company.getId(), asset.getCora(), asset.getId(), 1).iterator();
                while (iterator.hasNext()) {
                    ((ValuationMainAccount)iterator.next()).delete();
                }
                message = assetBP.saveValuationMainAccount(panels.investmentYP.getBookYear().getIntValue());
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
            }
            asset.setAssetType(assetType);
            asset.setStartUseYear(facYear);
            asset.setStartUsePeriod(facPeriod);
            asset.setBookValue(ValuationBO.getBookValue(asset));
            for (Valuation valuation : asset.getValuationsCollection(null)) {
                message = this.createAnonymousTransaction(valuation);
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                message = this.createReversingAndNewInvestmentTransactions(valuation);
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                if (valuation.getLastDepreciationBookYear() <= 0) continue;
                int[] yearPeriod = new int[]{valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod()};
                ValuationPK key = new ValuationPK();
                key.setAccountingPrinciple(valuation.getAccountingPrinciple());
                key.setAssetId(valuation.getAssetId());
                key.setCompanyId(valuation.getCompanyId());
                key.setCora(valuation.getCora());
                valuation = ValuationManagerFactory.getInstance(valuation.getDBData()).findByPrimaryKey(key);
                valuation.setLastDepreciationBookYear(0);
                valuation.setLastDepreciationPeriod(0);
                message = this.createAdditionalDepreciationTransactions(valuation, yearPeriod, this.description, -1, null, null);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    public void handleFinancialDimensions() throws Exception {
        this.finDimId1 = "";
        if (this.panels.dimensionPanels.financialDimension[0] != null) {
            this.finDimId1 = this.panels.dimensionPanels.financialDimension[0].getFormattedId();
        }
        this.finDimId2 = "";
        if (this.panels.dimensionPanels.financialDimension[1] != null) {
            this.finDimId2 = this.panels.dimensionPanels.financialDimension[1].getFormattedId();
        }
        this.finDimId3 = "";
        if (this.panels.dimensionPanels.financialDimension[2] != null) {
            this.finDimId3 = this.panels.dimensionPanels.financialDimension[2].getFormattedId();
        }
        this.finDimId4 = "";
        if (this.panels.dimensionPanels.financialDimension[3] != null) {
            this.finDimId4 = this.panels.dimensionPanels.financialDimension[3].getFormattedId();
        }
        this.finDimId5 = "";
        if (this.panels.dimensionPanels.financialDimension[4] != null) {
            this.finDimId5 = this.panels.dimensionPanels.financialDimension[4].getFormattedId();
        }
    }

    private String createAnonymousTransaction(Valuation valuation) throws Exception {
        if (this.finYear == 0) {
            this.finBookYear = this.facYear;
            this.finBookPeriod = this.facPeriod;
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.description, this.asset.getCora(), this.asset.getId(), valuation.getAccountingPrinciple(), 9, 100, this.facYear, this.facPeriod, this.finBookYear, this.finBookPeriod, new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, 0, 0, this.batchId, this.user, this.asset.getTypeId());
        if (objects[1] != null) {
            String message = (String)objects[1];
            return message;
        }
        Transaction anonymousTransaction = (Transaction)objects[0];
        this.documentNr = anonymousTransaction.getDocumentNr();
        if (this.typeOld.length() > 9) {
            anonymousTransaction.setMainAccount1(this.typeOld.substring(0, 9));
            anonymousTransaction.setMainAccount2(this.typeOld.substring(9));
        } else {
            anonymousTransaction.setMainAccount1(this.typeOld);
        }
        anonymousTransaction.setState(1);
        return null;
    }

    private String createReversingAndNewInvestmentTransactions(Valuation valuation) throws Exception {
        for (Transaction transactionToBeReversed : TransactionBO.getTransactions(valuation, true)) {
            if (transactionToBeReversed.getMainTransactionType() == 9) continue;
            Object[] objects = this.createReversingTransaction(transactionToBeReversed, this.description, -1);
            if (objects[1] != null) {
                String message = (String)objects[1];
                return message;
            }
            Transaction reversingTransaction = (Transaction)objects[0];
            reversingTransaction.setState(1);
            reversingTransaction.setMainAccount1(transactionToBeReversed.getMainAccount1());
            reversingTransaction.setMainAccount2(transactionToBeReversed.getMainAccount2());
            reversingTransaction.setMainAccount3(transactionToBeReversed.getMainAccount3());
            reversingTransaction.setMainAccount4(transactionToBeReversed.getMainAccount4());
            reversingTransaction.setJournalingTerm1(transactionToBeReversed.getJournalingTerm1());
            reversingTransaction.setJournalingTerm2(transactionToBeReversed.getJournalingTerm2());
            reversingTransaction.setJournalingTerm3(transactionToBeReversed.getJournalingTerm3());
            reversingTransaction.setJournalingTerm4(transactionToBeReversed.getJournalingTerm4());
            reversingTransaction.setJournalingTerm5(transactionToBeReversed.getJournalingTerm5());
            reversingTransaction.setMainAccountsSet(true);
            if (reversingTransaction.getTransactionType() == 70 || reversingTransaction.getTransactionType() == 80) {
                AssetAssetTypeChangeBP.updatePostedDepreciationBalance(this.asset, valuation, reversingTransaction, false);
                if (reversingTransaction.getTransactionType() != 70) continue;
                valuation.setNumberOfDepreciatedPeriods(valuation.getNumberOfDepreciatedPeriods() - 1);
                continue;
            }
            Object[] transactionCopies = this.createTransactionCopy(transactionToBeReversed, -1);
            if (transactionCopies[0] == null) {
                String message = (String)transactionCopies[1];
                return message;
            }
            Transaction transactionCopy = (Transaction)transactionCopies[0];
            transactionCopy.setState(1);
            if (transactionToBeReversed.getDocumentNr() == valuation.getDocumentNr1stTransaction() && transactionToBeReversed.getSeqNr() == valuation.getSeqNr1stTransaction()) {
                ValuationPK key = new ValuationPK();
                key.setAccountingPrinciple(valuation.getAccountingPrinciple());
                key.setAssetId(valuation.getAssetId());
                key.setCompanyId(valuation.getCompanyId());
                key.setCora(valuation.getCora());
                valuation = ValuationManagerFactory.getInstance(valuation.getDBData()).findByPrimaryKey(key);
                valuation.setDocumentNr1stTransaction(transactionCopy.getDocumentNr());
                valuation.setSeqNr1stTransaction(transactionCopy.getSeqNr());
                if (transactionCopy.getTransactionType() != 10 || transactionCopy.getAmount1().doubleValue() == 0.0) continue;
                AssetAssetTypeChangeBP.updatePreviousBookValueBalance(valuation, reversingTransaction);
                continue;
            }
            if (transactionCopy.getAmount1().doubleValue() == 0.0) continue;
            AssetAssetTypeChangeBP.updatePreviousBookValueBalance(valuation, reversingTransaction);
        }
        return null;
    }

    private Object[] createTransactionCopy(Transaction transaction, int batchId) throws Exception {
        if (this.finYear == 0) {
            this.finBookYear = this.facYear;
            this.finBookPeriod = this.facPeriod;
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.description, transaction.getCora(), transaction.getAssetId(), transaction.getAccountingPrinciple(), transaction.getMainTransactionType(), transaction.getTransactionType(), transaction.getBookYear(), transaction.getPeriod(), this.finBookYear, this.finBookPeriod, transaction.getAmount1(), transaction.getAmount2(), transaction.getAmount3(), null, this.asset.getFinDimId1(), this.asset.getFinDimId2(), this.asset.getFinDimId3(), this.asset.getFinDimId4(), this.asset.getFinDimId5(), this.retrieveJournalingState(transaction.getAccountingPrinciple(), transaction.getMainTransactionType()), 0, batchId, this.user, this.asset.getAssetType().getId());
        return objects;
    }
}

