/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.io.Serializable;
import java.math.BigDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.boadapters.AssetAnalysisCodeBO;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetValueBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.bp.CurrentCapitalizationBP;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.bp.InvestmentBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetValue;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class AssetBP
implements Serializable {
    private static final long serialVersionUID = -1597233480625841171L;
    private AssetPanels assetPanels;
    private AssetDimensionPanels dimensionPanels;
    private LoginHelper loginHelper;
    private Company company;
    private int numberOfPeriods;
    private Asset asset;
    private boolean isSubAsset;
    private boolean isParentAsset;
    private String finDimId1 = "";
    private String finDimId2 = "";
    private String finDimId3 = "";
    private String finDimId4 = "";
    private String finDimId5 = "";

    public AssetBP(AssetPanels assetPanels) {
        this.assetPanels = assetPanels;
        this.dimensionPanels = assetPanels.dimensionPanels;
        this.loginHelper = assetPanels.loginHelper;
        this.company = assetPanels.company;
        this.numberOfPeriods = assetPanels.numberOfPeriods;
    }

    public Object[] create(IncomingFinancialTransaction incomingFinancialTransaction, Credit credit, boolean activate) throws Exception {
        int bookYear = 0;
        if (!this.assetPanels.isParent) {
            bookYear = this.assetPanels.investmentYP.getBookYear().getIntValue();
        }
        return this.create(incomingFinancialTransaction, credit, activate, bookYear);
    }

    public Object[] create(IncomingFinancialTransaction incomingFinancialTransaction, Credit credit, boolean activate, int year) throws Exception {
        Object[] result = new Object[2];
        this.handleParentOrSubAsset();
        this.handleFinancialDimensions();
        int startUsePeriod = 0;
        int startUseYear = 0;
        if (!this.assetPanels.isParent) {
            startUsePeriod = this.assetPanels.investmentYP.getPeriod().getIntValue();
            startUseYear = this.assetPanels.investmentYP.getBookYear().getIntValue();
        }
        int historicalPeriod = 0;
        int historicalYear = 0;
        if (this.assetPanels.historicalYP != null) {
            historicalPeriod = this.assetPanels.historicalYP.getPeriod().getIntValue();
            historicalYear = this.assetPanels.historicalYP.getBookYear().getIntValue();
        }
        String iftId = null;
        if (incomingFinancialTransaction != null) {
            iftId = incomingFinancialTransaction.getId();
        }
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message;
            result = AssetBO.create(this.assetPanels.company.getDBData(), this.assetPanels.company.getId(), this.assetPanels.id.getValue().trim(), this.assetPanels.description.getValue().trim(), 0, this.assetPanels.companyOrDataSetId, this.assetPanels.type.getValue().trim(), this.assetPanels.parent.getValue().trim(), this.isParentAsset, this.isSubAsset, false, this.assetPanels.assetType.getIs3rdPartyLoan(), this.assetPanels.currentCapitalization, this.assetPanels.negativeInvestment.getValueAsBoolean(), false, this.assetPanels.acquisitionDate.getValueAsDate(), startUsePeriod, startUseYear, historicalPeriod, historicalYear, iftId, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, 0, "", null, "");
            if (result[1] != null) {
                BOAdapter.investigate(null, dbTransaction);
                return result;
            }
            this.asset = (Asset)result[0];
            if (credit != null) {
                this.asset.setCreditId(credit.getId());
            }
            if (this.asset.getLoan() && this.assetPanels.payOffYearAmount.getBigDecimal().doubleValue() != 0.0) {
                this.asset.setPayOffYearAmount(this.assetPanels.payOffYearAmount.getBigDecimal());
            }
            if ((message = this.saveDimensions()) != null) {
                BOAdapter.investigate(null, dbTransaction);
                result[1] = message;
                return result;
            }
            if (this.assetPanels.isParent) {
                BOAdapter.commitTransaction(alreadyActive);
                return result;
            }
            for (int i = 0; i <= this.assetPanels.apTabCountMax; ++i) {
                message = this.saveValuation(i);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                result[1] = message;
                return result;
            }
            message = this.assetPanels.currentCapitalization ? this.saveCurrentCapitalization(credit) : this.saveInvestment(incomingFinancialTransaction);
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                result[1] = message;
                return result;
            }
            if (this.assetPanels.mainAccountIds != null && (message = this.saveValuationMainAccount(year)) != null) {
                BOAdapter.investigate(null, dbTransaction);
                result[1] = message;
                return result;
            }
            if (activate && (message = AssetBP.activate(this.asset)) != null) {
                BOAdapter.investigate(null, dbTransaction);
                result[1] = message;
                return result;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = BOAdapter.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String activate(Asset asset) throws Exception {
        if (asset.getState() != 0) {
            return null;
        }
        Company company = (Company)CompanyBO.get(asset.getDBData(), asset.getCompanyId())[0];
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            for (Transaction transaction : TransactionBO.getTransactions(asset)) {
                if (transaction.getState() == 1) continue;
                Valuation valuation = (Valuation)ValuationBO.getValuation(asset.getDBData(), asset.getCompanyId(), asset.getCora(), asset.getId(), transaction.getAccountingPrinciple())[0];
                if (transaction.getMainTransactionType() == 1) {
                    GenericTransactionBP.updatePostedAcquisitionBalance(asset, valuation, transaction, true);
                }
                transaction.setBatchId(company.getCurrentBatchId());
                transaction.setState(1);
            }
            if (asset.getCurrentCapitalization()) {
                for (Valuation valuation : asset.getValuationsCollection(null)) {
                    if (valuation.getInterestCalculationMethod() == 0) continue;
                    valuation.setPreviousBookvalueBalance(valuation.getPostedAcquisitionBalance().subtract(valuation.getPostedDepreciationBalance()));
                }
            }
            asset.setState(2);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    public String update(Asset asset) throws Exception {
        this.asset = asset;
        this.handleParentOrSubAsset();
        this.handleFinancialDimensions();
        int startUsePeriod = 0;
        int startUseYear = 0;
        if (!this.assetPanels.isParent) {
            startUsePeriod = this.assetPanels.investmentYP.getPeriod().getIntValue();
            startUseYear = this.assetPanels.investmentYP.getBookYear().getIntValue();
        }
        int historicalPeriod = 0;
        int historicalYear = 0;
        if (this.assetPanels.historicalYP != null) {
            historicalPeriod = this.assetPanels.historicalYP.getPeriod().getIntValue();
            historicalYear = this.assetPanels.historicalYP.getBookYear().getIntValue();
        }
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message = AssetBO.update(asset, this.assetPanels.description.getValue().trim(), this.assetPanels.assetType, this.assetPanels.parentAsset, this.isParentAsset, this.isSubAsset, this.assetPanels.acquisitionDate.getValueAsDate(), startUsePeriod, startUseYear, historicalPeriod, historicalYear, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.assetPanels.payOffYearAmount.getBigDecimal());
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            message = this.saveDimensions();
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            if (this.assetPanels.isParent) {
                BOAdapter.commitTransaction();
                return null;
            }
            for (int i = 0; i <= this.assetPanels.apTabCountMax; ++i) {
                message = this.saveValuation(i);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            if (this.assetPanels.currentCapitalization) {
                message = this.saveCurrentCapitalization(null);
            } else if (asset.getState() == 0) {
                message = this.saveInvestment(asset.getIncomingFinancialTransaction());
            }
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    private void handleParentOrSubAsset() throws Exception {
        this.isParentAsset = this.assetPanels.isParent;
        if (!this.isParentAsset) {
            this.isParentAsset = this.assetPanels.parent.getValue().trim().length() == 0;
            this.isSubAsset = true;
        } else {
            this.isSubAsset = false;
        }
    }

    private void handleFinancialDimensions() throws Exception {
        this.finDimId1 = "";
        if (this.dimensionPanels.financialDimension[0] != null) {
            this.finDimId1 = this.dimensionPanels.financialDimension[0].getFormattedId();
        }
        this.finDimId2 = "";
        if (this.dimensionPanels.financialDimension[1] != null) {
            this.finDimId2 = this.dimensionPanels.financialDimension[1].getFormattedId();
        }
        this.finDimId3 = "";
        if (this.dimensionPanels.financialDimension[2] != null) {
            this.finDimId3 = this.dimensionPanels.financialDimension[2].getFormattedId();
        }
        this.finDimId4 = "";
        if (this.dimensionPanels.financialDimension[3] != null) {
            this.finDimId4 = this.dimensionPanels.financialDimension[3].getFormattedId();
        }
        this.finDimId5 = "";
        if (this.dimensionPanels.financialDimension[4] != null) {
            this.finDimId5 = this.dimensionPanels.financialDimension[4].getFormattedId();
        }
    }

    public String saveDimensions() throws Exception {
        String message = null;
        for (int i = 0; i < 10; ++i) {
            if (this.dimensionPanels.dimension[i] == null) continue;
            if (this.dimensionPanels.assetAnalysisCode[i] == null) {
                if (this.dimensionPanels.analysisGroup[i] != null && this.dimensionPanels.dimension[i].getValue().trim().length() > 0) {
                    Object[] object = AssetAnalysisCodeBO.create(this.company.getDBData(), this.company.getId(), this.asset.getCora(), this.asset.getId(), this.dimensionPanels.analysisGroup[i], this.dimensionPanels.dimension[i].getValue().trim());
                    this.dimensionPanels.assetAnalysisCode[i] = (AssetAnalysisCode)object[0];
                    message = (String)object[1];
                }
            } else {
                message = this.dimensionPanels.analysisGroup[i] != null && this.dimensionPanels.dimension[i].getValue().trim().length() > 0 ? AssetAnalysisCodeBO.update(this.dimensionPanels.assetAnalysisCode[i], this.dimensionPanels.analysisGroup[i], this.dimensionPanels.dimension[i].getValue().trim()) : AssetAnalysisCodeBO.delete(this.dimensionPanels.assetAnalysisCode[i]);
            }
            if (message == null) continue;
            return message;
        }
        for (int i = 0; i < 10; ++i) {
            if (this.dimensionPanels.freeDimension[i] == null) continue;
            String value = this.dimensionPanels.getFreeDimensionValue(i);
            if (this.dimensionPanels.assetValue[i] == null) {
                if (value.length() > 0) {
                    Object[] object = AssetValueBO.create(this.company.getDBData(), this.company.getId(), this.asset.getCora(), this.asset.getId(), this.dimensionPanels.analysisGroup[i], value);
                    this.dimensionPanels.assetValue[i] = (AssetValue)object[0];
                    message = (String)object[1];
                }
            } else {
                message = value.length() > 0 ? AssetValueBO.update(this.dimensionPanels.assetValue[i], value) : AssetValueBO.delete(this.dimensionPanels.assetValue[i]);
            }
            if (message == null) continue;
            return message;
        }
        return message;
    }

    private String saveValuation(int i) throws Exception {
        String message = null;
        if (this.assetPanels.currentCapitalization) {
            this.assetPanels.nbrOfDeprPers[i].setValue((long)(this.assetPanels.depreciatableLife[i].getIntValue() - this.assetPanels.remainingLife[i].getIntValue()));
        }
        if (this.assetPanels.valuation[i] != null) {
            message = ValuationBO.update(this.company.getDBData(), this.assetPanels.valuation[i], this.assetPanels.currentCapitalization, this.assetPanels.deprTotal[i].getBigDecimal(), this.assetPanels.nbrOfDeprPers[i].getIntValue(), Integer.parseInt(this.assetPanels.depreciationMethod[i].getValue()), this.assetPanels.degressivePercentage[i].getBigDecimal(), this.assetPanels.annuityInterestTableId[i].getValue(), this.assetPanels.annuityPercentage[i].getBigDecimal(), this.assetPanels.yearPercentageTableId[i].getValue(), Integer.parseInt(this.assetPanels.startPeriodHandlingMethod[i].getValue()), this.assetPanels.startDepreciation[i].getBookYear().getIntValue(), this.assetPanels.startDepreciation[i].getPeriod().getIntValue(), this.assetPanels.depreciatableLife[i].getIntValue(), this.assetPanels.residualValue[i].getBigDecimal(), this.assetPanels.residualPercentage[i].getBigDecimal(), this.assetPanels.depreciationPaused[i].getValueAsBoolean(), Integer.parseInt(this.assetPanels.interestCalculationMethod[i].getValue()), this.assetPanels.interestTableId[i].getValue(), this.numberOfPeriods, this.assetPanels.interestPercentage[i].getBigDecimal(), this.assetPanels.startInterest[i].getBookYear().getIntValue(), this.assetPanels.startInterest[i].getPeriod().getIntValue(), this.assetPanels.beyondEconomicLifePercentage[i].getBigDecimal());
        } else if (this.assetPanels.ap[i] != 2 || this.assetPanels.useAccountingPrinciple2) {
            Object[] result = null;
            result = ValuationBO.create(this.company.getDBData(), this.company.getId(), this.asset.getCora(), this.asset.getId(), this.assetPanels.ap[i], Integer.parseInt(this.assetPanels.depreciationMethod[i].getValue()), this.assetPanels.degressivePercentage[i].getBigDecimal(), this.assetPanels.annuityInterestTableId[i].getValue(), this.assetPanels.annuityPercentage[i].getBigDecimal(), this.assetPanels.yearPercentageTableId[i].getValue(), Integer.parseInt(this.assetPanels.startPeriodHandlingMethod[i].getValue()), this.assetPanels.startDepreciation[i].getBookYear().getIntValue(), this.assetPanels.startDepreciation[i].getPeriod().getIntValue(), this.assetPanels.depreciatableLife[i].getIntValue(), this.assetPanels.residualValue[i].getBigDecimal(), this.assetPanels.residualPercentage[i].getBigDecimal(), this.assetPanels.depreciationPaused[i].getValueAsBoolean(), Integer.parseInt(this.assetPanels.interestCalculationMethod[i].getValue()), this.assetPanels.interestTableId[i].getValue(), this.assetPanels.interestPercentage[i].getBigDecimal(), this.assetPanels.nbrOfDeprPers[i].getIntValue(), 0, 0, this.assetPanels.deprTotal[i].getBigDecimal(), new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), this.assetPanels.startInterest[i].getBookYear().getIntValue(), this.assetPanels.startInterest[i].getPeriod().getIntValue(), this.assetPanels.beyondEconomicLifePercentage[i].getBigDecimal());
            this.assetPanels.valuation[i] = (Valuation)result[0];
            this.assetPanels.valuation[i].setPostedDepreciationBalanceBeyondEconomicLife(this.assetPanels.deprTotalBEL[i].getBigDecimal());
            message = (String)result[1];
        }
        this.asset.setBookValue(ValuationBO.getBookValue(this.asset));
        return message;
    }

    private String saveCurrentCapitalization(Credit credit) throws Exception {
        String message = null;
        int documentNr = 0;
        int seqNr = 0;
        for (int i = 0; i <= this.assetPanels.apTabCountMax; ++i) {
            Object[] result;
            if (this.assetPanels.valuation[i] == null) {
                return null;
            }
            if (this.assetPanels.transactions[i] != null) {
                message = CurrentCapitalizationBP.updateCurrentCapitalizationInvestment(this.assetPanels.transactions[i], this.assetPanels.investmentYP.getBookYear().getIntValue(), this.assetPanels.investmentYP.getPeriod().getIntValue(), this.assetPanels.bookYP.getBookYear().getIntValue(), this.assetPanels.bookYP.getPeriod().getIntValue(), this.assetPanels.acquisitionValue.getBigDecimal(), this.assetPanels.valuation[i].getPostedDepreciationBalance());
                if (message == null) continue;
                return message;
            }
            if ((result = new CurrentCapitalizationBP(this.company).createCurrentCapitalizationInvestment(documentNr, ++seqNr, "", this.asset, this.assetPanels.investmentYP.getBookYear().getIntValue(), this.assetPanels.investmentYP.getPeriod().getIntValue(), this.assetPanels.bookYP.getBookYear().getIntValue(), this.assetPanels.bookYP.getPeriod().getIntValue(), this.assetPanels.acquTotal[i].getBigDecimal(), this.assetPanels.valuation[i], this.loginHelper.getUser()))[1] != null) {
                return (String)result[1];
            }
            Transaction transaction = (Transaction)result[0];
            if (credit != null) {
                transaction.setDescription("Afsl. krediet " + credit.getId());
                transaction.setCreditId(credit.getId());
                transaction.setTransactionType(120);
                transaction.setJournalingState(1);
                if (i == 0) {
                    credit.setAllocatedValue(credit.getAllocatedValue().add(this.assetPanels.acquTotal[i].getBigDecimal()));
                    credit.setAllocatedDepreciationValue(credit.getAllocatedDepreciationValue().add(this.assetPanels.deprTotal[i].getBigDecimal()));
                }
            }
            documentNr = transaction.getDocumentNr();
        }
        return message;
    }

    private String saveInvestment(IncomingFinancialTransaction incomingFinancialTransaction) throws Exception {
        String message = null;
        if (this.assetPanels.transaction != null) {
            message = InvestmentBP.updateInvestment(this.assetPanels.transaction, this.assetPanels.investmentYP.getBookYear().getIntValue(), this.assetPanels.investmentYP.getPeriod().getIntValue(), this.assetPanels.bookYP.getBookYear().getIntValue(), this.assetPanels.bookYP.getPeriod().getIntValue(), this.assetPanels.acquisitionValue.getBigDecimal());
        } else {
            boolean post = incomingFinancialTransaction == null;
            String originatingFrom = "FAC";
            String description = LanguageHelper.getString("nl.ibs.fac.language", "Oorspr.investering");
            if (incomingFinancialTransaction != null) {
                originatingFrom = "FIN";
                description = incomingFinancialTransaction.getDescription();
            }
            new InvestmentBP(this.company, this.numberOfPeriods, originatingFrom).createInvestment(this.asset, true, this.assetPanels.investmentYP.getBookYear().getIntValue(), this.assetPanels.investmentYP.getPeriod().getIntValue(), this.assetPanels.bookYP.getBookYear().getIntValue(), this.assetPanels.bookYP.getPeriod().getIntValue(), description, this.assetPanels.acquisitionValue.getBigDecimal(), incomingFinancialTransaction, post, this.loginHelper.getUser(), false, null, 0, -1);
        }
        return message;
    }

    public String saveValuationMainAccount(int year) throws Exception {
        Object[] result = ValuationMainAccountBO.create(this.company.getDBData(), this.company.getId(), this.asset.getCora(), this.asset.getId(), 1, year, 1, this.assetPanels.mainAccountIds[0], this.assetPanels.mainAccountIds[1], this.assetPanels.mainAccountIds[2], this.assetPanels.mainAccountIds[3], this.assetPanels.mainAccountIds[4], this.assetPanels.mainAccountIds[5], this.assetPanels.mainAccountIds[6], this.assetPanels.mainAccountIds[7], this.assetPanels.mainAccountIds[8]);
        return (String)result[1];
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }
}

