/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import com.ibm.as400.access.AS400;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Vector;
import nl.ibs.api.fis.FaglrekAdapter;
import nl.ibs.api.fis.FagsldrAdapter;
import nl.ibs.fac.ComparisonValue;
import nl.ibs.fac.bp.BaseComparisonBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.FreeQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;

public class ComparisonBP
extends BaseComparisonBP
implements Serializable {
    private static final long serialVersionUID = 2794011880548357509L;
    private boolean isFMS;
    private Environment env;
    private FagsldrAdapter maAdapter;
    private FaglrekAdapter faglrekAdapter;

    public ComparisonBP(DBData dbData, AS400 as400, Environment env, Company company, int numberOfPeriods, boolean isFMS) throws Exception {
        super(dbData, as400, company, numberOfPeriods);
        this.env = env;
        this.isFMS = isFMS;
    }

    public Vector retrieveGLComparisonValues(int accountingPrinciple, int year) throws Exception {
        this.year = year;
        this.accountingPrinciple = accountingPrinciple;
        this.types = null;
        this.allSchemes = null;
        this.glComparisonValues = null;
        this.retrieveSchemes();
        if (this.allSchemes == null || this.allSchemes.isEmpty()) {
            return null;
        }
        this.createGLComparisonValues();
        this.initializeIBSAPIAdapters();
        this.retrieveGLTotals();
        DBData defaultDBData = DBData.getDefaultDBData("fac");
        DBPersistenceManager.setDefaultDataBase(this.dbData);
        this.retrieveFACTotals();
        DBPersistenceManager.setDefaultDataBase(defaultDBData);
        this.handleTotalDifferences();
        return this.glComparisonValues;
    }

    private void initializeIBSAPIAdapters() throws Exception {
        if (this.isFMS) {
            this.initializeFMSAdapters();
        } else {
            this.initializeFIS2000Adapters();
        }
    }

    private void retrieveGLTotals() throws Exception {
        if (this.isFMS) {
            this.retrieveFMSTotals();
        } else {
            this.retrieveFIS2000Totals();
        }
    }

    public ComparisonValue retrieveGLComparisonValueDetails(ComparisonValue glComparisonValue) throws Exception {
        if (glComparisonValue.getDetailsAlreadyAvailable()) {
            return glComparisonValue;
        }
        this.retrieveGLDetails(glComparisonValue);
        DBData defaultDBData = DBData.getDefaultDBData("fac");
        DBPersistenceManager.setDefaultDataBase(this.dbData);
        this.retrieveFACDetails(glComparisonValue);
        DBPersistenceManager.setDefaultDataBase(defaultDBData);
        glComparisonValue.handleDetailDifferences();
        glComparisonValue.setDetailsAlreadyAvailable(true);
        return glComparisonValue;
    }

    private void retrieveGLDetails(ComparisonValue glComparisonValue) throws Exception {
        if (this.isFMS) {
            this.retrieveFMSDetails(glComparisonValue);
        } else {
            this.retrieveFIS2000Details(glComparisonValue);
        }
    }

    private void initializeFIS2000Adapters() throws Exception {
        this.maAdapter = new FagsldrAdapter(this.as400);
        this.maAdapter.setDSPAR1HP1STK(" ");
        this.maAdapter.setDSPAR1HP1BDR(this.getCompany(this.company.getId()));
        this.maAdapter.setDSPAR1HP1VST(this.getBranche(this.company.getId()));
        this.maAdapter.setDSPAR1HP1BJR(this.getBookYear("" + this.year));
        this.maAdapter.setDSPAR1HP1BBB(new BigDecimal("0.00"));
        this.maAdapter.setDSPAR1HP1BSD(new BigDecimal("0.00"));
        this.maAdapter.setDSPAR1HP1ABB(new BigDecimal("0"));
        this.maAdapter.setDSPAR1HP1ASD(new BigDecimal("0"));
        this.maAdapter.setDSPAR1HP1SBV(" ");
        this.maAdapter.setDSPAR1HP1CBV(" ");
        this.maAdapter.setDSPAR1HP1STK(" ");
        this.faglrekAdapter = new FaglrekAdapter(this.as400);
        this.faglrekAdapter.setHP1BDR(this.getCompany(this.company.getId()));
        this.faglrekAdapter.setHP1VST(this.getBranche(this.company.getId()));
        this.faglrekAdapter.setHP1BJR(this.getBookYear("" + this.year));
        this.faglrekAdapter.setHP1AUT("N");
    }

    private void retrieveFIS2000Totals() throws Exception {
        for (ComparisonValue glComparisonValue : this.glComparisonValues) {
            if (glComparisonValue.getBeanType() == 0) {
                this.faglrekAdapter.setHP1NR(new BigDecimal(glComparisonValue.getAcquisitionAccount()));
                this.faglrekAdapter.execute();
                glComparisonValue.setAcquisitionAccountDescription(this.faglrekAdapter.getSROMS());
                this.maAdapter.setDSPAR1HP1REK(new BigDecimal(glComparisonValue.getAcquisitionAccount()));
                this.maAdapter.setDSPAR1HP1PTM(new BigDecimal("0"));
                this.maAdapter.execute();
                glComparisonValue.setGLAcquisitionTotal(this.maAdapter.getDSPAR1HP1BSD());
                glComparisonValue.addFIS2000YTDFigure(this.maAdapter.getDSPAR1HP1BBB(), 0, 0);
                if ("".equals(glComparisonValue.getDepreciationAccount())) {
                    glComparisonValue.setDepreciationAccountDescription("");
                } else {
                    this.faglrekAdapter.setHP1NR(new BigDecimal(glComparisonValue.getDepreciationAccount()));
                    this.faglrekAdapter.execute();
                    glComparisonValue.setDepreciationAccountDescription(this.faglrekAdapter.getSROMS());
                    this.maAdapter.setDSPAR1HP1REK(new BigDecimal(glComparisonValue.getDepreciationAccount()));
                    this.maAdapter.setDSPAR1HP1PTM(new BigDecimal("0"));
                    this.maAdapter.execute();
                    glComparisonValue.setGLDepreciationTotal(this.maAdapter.getDSPAR1HP1BSD().negate());
                    glComparisonValue.addFIS2000YTDFigure(this.maAdapter.getDSPAR1HP1BBB().negate(), 2, 0);
                }
                if ("".equals(glComparisonValue.getCostAccount())) {
                    glComparisonValue.setCostAccountDescription("");
                    continue;
                }
                this.faglrekAdapter.setHP1NR(new BigDecimal(glComparisonValue.getCostAccount()));
                this.faglrekAdapter.execute();
                glComparisonValue.setCostAccountDescription(this.faglrekAdapter.getSROMS());
                continue;
            }
            glComparisonValue.setAcquisitionAccountDescription("");
            glComparisonValue.setDepreciationAccountDescription("");
            glComparisonValue.setCostAccountDescription("");
        }
    }

    private void retrieveFIS2000Details(ComparisonValue glComparisonValue) throws Exception {
        int i;
        int theNumberOfPeriods = this.numberOfPeriods;
        if (this.numberOfCorrectionPeriods > 0) {
            theNumberOfPeriods = 13;
        }
        this.maAdapter.setDSPAR1HP1REK(new BigDecimal(glComparisonValue.getAcquisitionAccount()));
        for (i = 1; i <= theNumberOfPeriods; ++i) {
            this.maAdapter.setDSPAR1HP1PTM(new BigDecimal("" + i));
            this.maAdapter.execute();
            glComparisonValue.addFIS2000YTDFigure(this.maAdapter.getDSPAR1HP1BSD(), 0, i);
        }
        if (!"".equals(glComparisonValue.getDepreciationAccount())) {
            this.maAdapter.setDSPAR1HP1REK(new BigDecimal(glComparisonValue.getDepreciationAccount()));
            for (i = 1; i <= theNumberOfPeriods; ++i) {
                this.maAdapter.setDSPAR1HP1PTM(new BigDecimal("" + i));
                this.maAdapter.execute();
                glComparisonValue.addFIS2000YTDFigure(this.maAdapter.getDSPAR1HP1BSD().negate(), 2, i);
            }
        }
        if (!"".equals(glComparisonValue.getCostAccount())) {
            this.maAdapter.setDSPAR1HP1REK(new BigDecimal(glComparisonValue.getCostAccount()));
            for (i = 1; i <= theNumberOfPeriods; ++i) {
                this.maAdapter.setDSPAR1HP1PTM(new BigDecimal("" + i));
                this.maAdapter.execute();
                glComparisonValue.addFIS2000YTDFigure(this.maAdapter.getDSPAR1HP1BSD(), 4, i);
            }
        }
        glComparisonValue.setDetailsAlreadyAvailable(true);
    }

    private BigDecimal getCompany(String adminId) {
        int i = adminId.indexOf(47);
        if (i > 0) {
            return new BigDecimal(adminId.substring(0, i));
        }
        return new BigDecimal(adminId);
    }

    private BigDecimal getBranche(String adminId) {
        int i = adminId.indexOf(47);
        if (i > 0) {
            return new BigDecimal(adminId.substring(i + 1));
        }
        return new BigDecimal(0);
    }

    private BigDecimal getBookYear(String bookYear) {
        return new BigDecimal(bookYear.substring(2));
    }

    public Vector retrieveInternalCompanyComparisonValues() throws Exception {
        Vector<ComparisonValue> internalComparisonValues = new Vector<ComparisonValue>();
        DBData defaultDBData = DBData.getDefaultDBData("fac");
        DBPersistenceManager.setDefaultDataBase(this.dbData);
        BigDecimal[] totals_1 = ComparisonBP.retrieveCompanyTotals(this.company, 1, true, true);
        BigDecimal[] totals_2 = ComparisonBP.retrieveCompanyTotals(this.company, 2, true, true);
        DBPersistenceManager.setDefaultDataBase(defaultDBData);
        ComparisonValue internalComparisonValue = new ComparisonValue(1, this.env.getAPName1(), totals_1);
        internalComparisonValues.add(internalComparisonValue);
        if (totals_2[0].doubleValue() != 0.0 || totals_2[1].doubleValue() != 0.0 || totals_2[2].doubleValue() != 0.0 || totals_2[3].doubleValue() != 0.0) {
            internalComparisonValue = new ComparisonValue(2, this.env.getAPName2(), totals_2);
            internalComparisonValues.add(internalComparisonValue);
        }
        return internalComparisonValues;
    }

    public Vector[] retrieveInternalAssetComparisonValues() throws Exception {
        Vector vector_1 = new Vector();
        Vector vector_2 = new Vector();
        Vector[] internalComparisonValuesArray = new Vector[]{vector_1, vector_2};
        String dataLib = this.dbData.getName();
        String companyId = this.company.getId();
        String stmt = "";
        stmt = stmt + "WITH MYTABLE AS (";
        stmt = stmt + "SELECT COMPANYID, CORA, ASSETID, ACCPRIN, SUM(AMOUNT1) AS TOTAL1, SUM(AMOUNT2) AS TOTAL2 ";
        stmt = stmt + "FROM " + dataLib + ".TRANSACTN ";
        stmt = stmt + "WHERE COMPANYID = '" + companyId + "' AND CORA = 'A' AND (MNTRANSTYP = 1 OR MNTRANSTYP = 2 OR MNTRANSTYP = 3) ";
        stmt = stmt + "GROUP BY COMPANYID, CORA, ASSETID, ACCPRIN) ";
        stmt = stmt + "SELECT A.COMPANYID, A.CORA, A.ASSETID, C.DESCR, A.ACCPRIN, A.TOTAL1, B.PSTACQBAL, A.TOTAL2, B.DEPBALANCE, C.STATE ";
        stmt = stmt + "FROM MYTABLE AS A ";
        stmt = stmt + "JOIN " + dataLib + ".VALUATION AS B ON ";
        stmt = stmt + "B.COMPANYID = A.COMPANYID AND ";
        stmt = stmt + "B.CORA = A.CORA AND ";
        stmt = stmt + "B.ASSETID = A.ASSETID AND ";
        stmt = stmt + "B.ACCPRIN = A.ACCPRIN ";
        stmt = stmt + "JOIN " + dataLib + ".ASSET AS C ON ";
        stmt = stmt + "C.COMPANYID = A.COMPANYID AND ";
        stmt = stmt + "C.CORA = A.CORA AND ";
        stmt = stmt + "C.ID = A.ASSETID ";
        stmt = stmt + "WHERE B.PSTACQBAL <> A.TOTAL1 OR B.DEPBALANCE <> A.TOTAL2 ";
        stmt = stmt + "ORDER BY A.COMPANYID, A.CORA, A.ASSETID, A.ACCPRIN";
        DBConnection con = DBConnectionPool.getInstance("fac").getConnection();
        ResultSet resultSet = con.executeQuery(stmt);
        while (resultSet.next()) {
            ComparisonValue internalComparisonValue = new ComparisonValue(resultSet.getString(3), resultSet.getString(4), resultSet.getInt(10), resultSet.getInt(5), resultSet.getBigDecimal(6), resultSet.getBigDecimal(7), resultSet.getBigDecimal(8), resultSet.getBigDecimal(9));
            if (resultSet.getInt(5) == 1) {
                internalComparisonValuesArray[0].add(internalComparisonValue);
                continue;
            }
            internalComparisonValuesArray[1].add(internalComparisonValue);
        }
        DBConnectionPool.getInstance("fac").returnConnection(con);
        return internalComparisonValuesArray;
    }

    public static BigDecimal[] retrieveCompanyTotals(Company company, int accountingPrinciple, boolean valuationTotals, boolean transactionTotals) throws Exception {
        BigDecimal[] hlpTotals;
        BigDecimal ZERO = new BigDecimal("0.00");
        BigDecimal[] totals = new BigDecimal[]{ZERO, ZERO, ZERO, ZERO};
        if (valuationTotals) {
            hlpTotals = ComparisonBP.retrieveValuationTotals(company, accountingPrinciple);
            totals[0] = hlpTotals[0];
            totals[2] = hlpTotals[1];
        }
        if (transactionTotals) {
            hlpTotals = ComparisonBP.retrieveTransactionTotals(company, accountingPrinciple, null);
            totals[1] = hlpTotals[0];
            totals[3] = hlpTotals[1];
        }
        return totals;
    }

    public static BigDecimal[] retrieveValuationTotals(Company company, int accountingPrinciple) throws Exception {
        BigDecimal ZERO = new BigDecimal("0.00");
        BigDecimal[] totals = new BigDecimal[]{ZERO, ZERO};
        FreeQuery query = QueryFactory.createFreeQuery(Valuation.class);
        query.setQuery("SELECT SUM(postedAcquisitionBalance), SUM(postedDepreciationBalance) FROM Valuation WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap");
        query.setParameter("_companyId", company.getId());
        query.setParameter("_ap", accountingPrinciple);
        Object[][] data = query.getResultArray();
        if (data[0][0] != null) {
            totals[0] = (BigDecimal)data[0][0];
        }
        if (data[0][1] != null) {
            totals[1] = (BigDecimal)data[0][1];
        }
        return totals;
    }

    public static BigDecimal[] retrieveTransactionTotals(Company company, int accountingPrinciple, String assetId) throws Exception {
        BigDecimal ZERO = new BigDecimal("0.00");
        BigDecimal[] totals = new BigDecimal[]{ZERO, ZERO};
        String assetFilter = "";
        if (assetId != null && assetId.trim().length() > 0) {
            assetFilter = " AND assetId = ?_assetId ";
        }
        FreeQuery query = QueryFactory.createFreeQuery(Transaction.class);
        query.setQuery("SELECT SUM(amount1), SUM(amount2) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap " + assetFilter + " AND (" + "mainTransactionType" + " = ?_mtt_1 OR " + "mainTransactionType" + " = ?_mtt_2 OR " + "mainTransactionType" + " = ?_mtt_3) ");
        query.setParameter("_companyId", company.getId());
        query.setParameter("_ap", accountingPrinciple);
        if (assetFilter.length() > 0) {
            query.setParameter("_assetId", assetId);
        }
        query.setParameter("_mtt_1", 1);
        query.setParameter("_mtt_2", 2);
        query.setParameter("_mtt_3", 3);
        Object[][] data = query.getResultArray();
        if (data[0][0] != null) {
            totals[0] = (BigDecimal)data[0][0];
        }
        if (data[0][1] != null) {
            totals[1] = (BigDecimal)data[0][1];
        }
        return totals;
    }
}

