/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class CurrentCapitalizationBP
extends GenericTransactionBP {
    private static final long serialVersionUID = -3851705625079047100L;

    public CurrentCapitalizationBP(Company company) throws Exception {
        super(company, 0);
    }

    public Object[] createCurrentCapitalizationInvestment(int documentNr, int seqNr, String description, Asset asset, int facYear, int facPeriod, int finYear, int finPeriod, BigDecimal investmentValue, Valuation valuation, String user) throws Exception {
        if (finYear == 0) {
            finYear = facYear;
            finPeriod = facPeriod;
        }
        description = LanguageHelper.getString("nl.ibs.fac.language", "CurrentCapitalization") + " " + asset.getId();
        int journalingState = 0;
        boolean journalize = this.processParameters.getJournalizeCurrentAssets();
        if (journalize) {
            journalingState = this.retrieveJournalingState(valuation.getAccountingPrinciple(), 1);
        }
        Object[] result = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result = TransactionBO.create(asset.getDBData(), this.company.getId(), documentNr, seqNr, description.trim(), asset.getCora(), asset.getId(), valuation.getAccountingPrinciple(), 1, 20, facYear, facPeriod, finYear, finPeriod, investmentValue, valuation.getPostedDepreciationBalance(), new BigDecimal(0), null, asset.getFinDimId1(), asset.getFinDimId2(), asset.getFinDimId3(), asset.getFinDimId4(), asset.getFinDimId5(), journalingState, 0, 0, user, asset.getTypeId());
            if (result[1] != null) {
                BOAdapter.investigate(null, dbTransaction);
                return result;
            }
            Transaction transaction = (Transaction)result[0];
            documentNr = transaction.getDocumentNr();
            valuation.setDocumentNr1stTransaction(documentNr);
            valuation.setSeqNr1stTransaction(seqNr);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = BOAdapter.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String updateCurrentCapitalizationInvestment(Transaction transaction, int facYear, int facPeriod, int finYear, int finPeriod, BigDecimal investmentValue, BigDecimal depreciationValue) throws Exception {
        if (finYear == 0) {
            finYear = facYear;
            finPeriod = facPeriod;
        }
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            transaction.setBookYear(facYear);
            transaction.setPeriod(facPeriod);
            transaction.setBookYearForJournalization(finYear);
            transaction.setPeriodForJournalization(finPeriod);
            transaction.setAmount1(investmentValue);
            transaction.setAmount2(depreciationValue);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }
}

