/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalanceDetail;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.IncomingFinancialTransactionManager;
import nl.ibs.fac.db.IncomingFinancialTransactionManagerFactory;
import nl.ibs.fac.db.IncomingFinancialTransactionPK;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.gov.boadapters.CreditBalanceDetailBO;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public abstract class IncomingFinancialTransactionBP {
    public static String confirm(IncomingFinancialTransaction incomingFinancialTransaction) throws Exception {
        IncomingFinancialTransactionManager manager = IncomingFinancialTransactionManagerFactory.getInstance(incomingFinancialTransaction.getDBData());
        IncomingFinancialTransactionPK key = new IncomingFinancialTransactionPK();
        key.setCompanyId(incomingFinancialTransaction.getCompanyId());
        key.setId(incomingFinancialTransaction.getId());
        incomingFinancialTransaction = manager.findByPrimaryKey(key);
        Company company = (Company)CompanyBO.get(incomingFinancialTransaction.getDBData(), incomingFinancialTransaction.getCompanyId())[0];
        if (incomingFinancialTransaction.getConfirmed()) {
            return null;
        }
        if (incomingFinancialTransaction.getUnAllocatedValue().doubleValue() != 0.0) {
            return LanguageHelper.getString("nl.ibs.fac.language", "invalid_state");
        }
        company = (Company)CompanyBO.get(company.getDBData(), company.getId())[0];
        boolean use445Correction = company.getProcessParameters().getUse445Correction();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            for (Transaction iftTransaction : IncomingFinancialTransactionBO.getTransactions(incomingFinancialTransaction)) {
                iftTransaction.setBookingIndicator(incomingFinancialTransaction.getBBVCategory());
                Asset asset = iftTransaction.getAsset();
                if (iftTransaction.getAssetOriginatedByFinancialTransaction()) {
                    String message = AssetBP.activate(iftTransaction.getAsset());
                    if (message == null) continue;
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                if (asset == null) {
                    iftTransaction.setBatchId(company.getCurrentBatchId());
                    iftTransaction.setState(1);
                    continue;
                }
                Valuation valuation = (Valuation)ValuationBO.getValuation(asset.getDBData(), asset.getCompanyId(), asset.getCora(), asset.getId(), iftTransaction.getAccountingPrinciple())[0];
                BigDecimal c445A = null;
                BigDecimal c445B = null;
                for (Transaction transaction : TransactionBO.getTransactionsForDocument(iftTransaction)) {
                    if (transaction.getAccountingPrinciple() != valuation.getAccountingPrinciple() || transaction.getState() != 0) continue;
                    if (transaction.getMainTransactionType() == 1) {
                        IncomingFinancialTransaction ift;
                        GenericTransactionBP.updatePostedAcquisitionBalance(asset, valuation, transaction, true);
                        if (transaction.getIncomingFinancialTransactionId() != null && (ift = transaction.getIncomingFinancialTransaction()) != null && ift.getGovernmentCode() == 1 && valuation.getInterestCalculationMethod() == 1) {
                            valuation.setPreviousBookvalueBalance(valuation.getPreviousBookvalueBalance().add(transaction.getAmount1()));
                        }
                    }
                    if (transaction.getMainTransactionType() == 2) {
                        GenericTransactionBP.updatePostedAcquisitionBalance(asset, valuation, transaction, false);
                        if (transaction.getTransactionType() == 30) {
                            asset.setState(4);
                            asset.setDisinvestmentYear(transaction.getBookYear());
                            asset.setDisinvestmentPeriod(transaction.getPeriod());
                            asset.setFinDisinvestmentYear(transaction.getBookYearForJournalization());
                            asset.setFinDisinvestmentPeriod(transaction.getPeriodForJournalization());
                        }
                    }
                    if (transaction.getMainTransactionType() == 3) {
                        GenericTransactionBP.updatePostedDepreciationBalance(asset, valuation, transaction, false);
                        if (use445Correction && transaction.getRevCode() != -1) {
                            int remainder = transaction.getPeriod() % 3;
                            switch (remainder) {
                                case 1: {
                                    c445A = transaction.getCorrectionAmount445();
                                    break;
                                }
                                case 2: {
                                    c445B = transaction.getCorrectionAmount445();
                                    break;
                                }
                                case 0: {
                                    c445A = new BigDecimal("0.00");
                                    c445B = new BigDecimal("0.00");
                                }
                            }
                        }
                    }
                    transaction.setBatchId(company.getCurrentBatchId());
                    transaction.setState(1);
                    if (transaction.getRevCode() != -1) continue;
                    transaction.setRevCode(1);
                    Transaction toBeReversedTransaction = (Transaction)TransactionBO.get(asset.getDBData(), asset.getCompanyId(), transaction.getRevDocumentNr(), transaction.getRevSeqNr())[0];
                    toBeReversedTransaction.setInfoLevel(1);
                    toBeReversedTransaction.setRevCode(2);
                    toBeReversedTransaction.setRevDocumentNr(transaction.getDocumentNr());
                    toBeReversedTransaction.setRevSeqNr(transaction.getSeqNr());
                }
                if (!use445Correction) continue;
                if (c445A != null && c445A.doubleValue() != 0.0) {
                    valuation.setCorrectionAmount445A(valuation.getCorrectionAmount445A().add(c445A));
                }
                if (c445B == null || c445B.doubleValue() == 0.0) continue;
                valuation.setCorrectionAmount445B(valuation.getCorrectionAmount445B().add(c445B));
            }
            incomingFinancialTransaction.setConfirmed(true);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String changeBBVCategory(IncomingFinancialTransaction ift, int newCategory) throws Exception {
        Collection transactions = IncomingFinancialTransactionBO.getTransactions(ift);
        Iterator it = transactions.iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (it.hasNext()) {
                Transaction transaction = (Transaction)it.next();
                transaction.setBookingIndicator(newCategory);
            }
            Company company = (Company)CompanyBO.get(ift.getDBData(), ift.getCompanyId())[0];
            CreditBalanceDetail detail = (CreditBalanceDetail)CreditBalanceDetailBO.get(company, ift.getMainAccount(), ift.getBookYear(), 0)[0];
            if (detail != null) {
                switch (ift.getBBVCategory()) {
                    case 0: {
                        detail.setBalanceAmount1(detail.getBalanceAmount1().subtract(ift.getTransactionValue()));
                        break;
                    }
                    case 1: {
                        detail.setBalanceAmount2(detail.getBalanceAmount2().subtract(ift.getTransactionValue()));
                        break;
                    }
                    case 2: {
                        detail.setBalanceAmount3(detail.getBalanceAmount3().subtract(ift.getTransactionValue()));
                    }
                }
                switch (newCategory) {
                    case 0: {
                        detail.setBalanceAmount1(detail.getBalanceAmount1().add(ift.getTransactionValue()));
                        break;
                    }
                    case 1: {
                        detail.setBalanceAmount2(detail.getBalanceAmount2().add(ift.getTransactionValue()));
                        break;
                    }
                    case 2: {
                        detail.setBalanceAmount3(detail.getBalanceAmount3().add(ift.getTransactionValue()));
                    }
                }
            }
            ift.setBBVCategory(newCategory);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    public static void allocateInitialProjectCosts(IncomingFinancialTransaction ift, String creditId) throws Exception {
        ift.setCreditId(creditId);
        ift.setUnAllocatedValue(ift.getTransactionValue().subtract(ift.getTransactionValue()));
        ift.setConfirmed(true);
    }

    public static void deallocateInitialProjectCosts(IncomingFinancialTransaction ift) throws Exception {
        ift.setCreditId("");
        ift.setUnAllocatedValue(ift.getTransactionValue());
        ift.setConfirmed(false);
    }

    public static BigDecimal getTotalIPCAmount(Credit credit) throws Exception {
        BigDecimal result = new BigDecimal("0.00");
        String sql = "companyId = '" + credit.getCompanyId() + "' AND " + "creditId" + " = '" + credit.getId() + "'";
        ExecutableQuery query = QueryFactory.create(IncomingFinancialTransaction.class, sql, "creditId");
        for (IncomingFinancialTransaction ift : IncomingFinancialTransactionManagerFactory.getInstance(credit.getDBData()).getCollection(query)) {
            result = result.add(ift.getTransactionValue());
        }
        return result;
    }
}

