/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Collection;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.bp.DisInvestmentBP;
import nl.ibs.fac.bp.ProofDisInvestmentBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class InterCompanyMovementBP
extends DisInvestmentBP {
    private static final long serialVersionUID = 6795232720610096405L;
    ProofDisInvestmentBP pdiBP;
    private boolean useRCTableForMOVIC;

    public InterCompanyMovementBP(Company company, int numberOfPeriods, boolean useRCTableForMOVIC) throws Exception {
        super(company, numberOfPeriods, null);
        this.useRCTableForMOVIC = useRCTableForMOVIC;
        this.interCompany = true;
    }

    public void calculateInterCompanyMovementValues(Asset asset, int year, int period) throws Exception {
        this.pdiBP = new ProofDisInvestmentBP(this.company, this.numberOfPeriods);
        this.pdiBP.calculateProofDisInvestmentValues(asset, year, period, new BigDecimal("0"), new BigDecimal("0"));
    }

    public BigDecimal[] getInterCompanyMovementValues() throws Exception {
        return this.pdiBP.getProofDisInvestmentValues();
    }

    public int[] getCorrectionPeriods() throws Exception {
        return this.pdiBP.getCorrectionPeriods();
    }

    public String move(Asset assetToMove, AssetPanels assetPanels, int facYear, int facPeriod, int finYear, int finPeriod, String user) throws Exception {
        this.asset = assetToMove;
        String message = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        if (alreadyActive) {
            return "transaction already active";
        }
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Object[] result = new AssetBP(assetPanels).create(null, null, true);
            message = (String)result[1];
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            Asset newAsset = (Asset)result[0];
            String becomes = LanguageHelper.getString("nl.ibs.fac.language", "Becomes");
            String oldDescription = becomes + " : " + assetPanels.company.getId() + "/" + AssetBO.formatId(assetPanels.company, newAsset.getId(), false);
            message = this.createDisInvestment(assetToMove, facYear, facPeriod, finYear, finPeriod, oldDescription, new BigDecimal("0"), new BigDecimal("0"), null, true, user, 0);
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            Collection oldTransactions = null;
            if (this.useRCTableForMOVIC) {
                oldTransactions = TransactionBO.getTransactions(assetToMove);
            }
            String formerly = LanguageHelper.getString("nl.ibs.fac.language", "Formerly");
            String description = formerly + " : " + this.company.getId() + "/" + AssetBO.formatId(this.company, assetToMove.getId(), false);
            Collection newTransactions = TransactionBO.getTransactions(newAsset);
            for (Transaction newTransaction : newTransactions) {
                newTransaction.setTransactionType(50);
                newTransaction.setDescription(description);
                int journalingState = this.retrieveJournalingState(newTransaction.getAccountingPrinciple(), 1);
                if (this.useRCTableForMOVIC) {
                    journalingState = 0;
                    for (Transaction oldTransaction : oldTransactions) {
                        if (oldTransaction.getMainTransactionType() != 2 || oldTransaction.getTransactionType() != 50 || oldTransaction.getAccountingPrinciple() != newTransaction.getAccountingPrinciple()) continue;
                        oldTransaction.setAlternativeCompanyId(newTransaction.getCompanyId());
                        oldTransaction.setRevDocumentNr(newTransaction.getDocumentNr());
                        oldTransaction.setRevSeqNr(newTransaction.getSeqNr());
                        break;
                    }
                }
                newTransaction.setJournalingState(journalingState);
            }
            BOAdapter.commitTransaction();
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }
}

