/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class LedgerCorrectionBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 7940061250490197430L;

    public LedgerCorrectionBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public String[] validateFACMainAccount(LoginHelper loginHelper, boolean isFMS, int bookYear, String mainAccount) throws Exception {
        String[] messages = new String[1];
        int index = 0;
        if (isFMS) {
            boolean[] mainAccountAttributes = new FMSHelper(loginHelper).getMainAccountAttributes("" + bookYear, mainAccount);
            if (mainAccountAttributes[4]) {
                messages[index] = "MainAccount_is_FAC_account";
                ++index;
            }
        } else {
            boolean[] mainAccountAttributes = new FISHelper(loginHelper).getMainAccountAttributes(this.company.getId(), "" + bookYear, mainAccount);
            if (mainAccountAttributes[2]) {
                messages[index] = "MainAccount_is_FAC_account";
                ++index;
            }
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String createCorrection(int financialYear, int financialPeriod, String description, BigDecimal correctionValue, String daybook, String mainAccount, String finDimId1, String finDimId2, String finDimId3, String finDimId4, String finDimId5, IncomingFinancialTransaction incomingFinancialTransaction, Credit credit, String user) throws Exception {
        String message = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Object[] result;
            String incomingFinancialTransactionId = null;
            Date bookDate = Calendar.getInstance().getTime();
            if (incomingFinancialTransaction != null) {
                incomingFinancialTransactionId = incomingFinancialTransaction.getId();
                bookDate = incomingFinancialTransaction.getBookDate();
            }
            if ((message = (String)(result = TransactionBO.create(this.company.getDBData(), this.company.getId(), 0, 1, description.trim(), "", null, 0, 4, 0, this.facYear, this.facPeriod, financialYear, financialPeriod, correctionValue, new BigDecimal(0), new BigDecimal(0), incomingFinancialTransactionId, finDimId1, finDimId2, finDimId3, finDimId4, finDimId5, this.retrieveJournalingState(1, 4), 0, 0, user, ""))[1]) != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            Transaction transaction = (Transaction)result[0];
            transaction.setCreationDate(bookDate);
            transaction.setDaybookId(daybook);
            transaction.setMainAccount1(mainAccount);
            if (credit != null) {
                transaction.setCreditId(credit.getId());
                CompanyAccountingPrincipleDefault capd = (CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.company.getDBData(), this.company.getId(), 3)[0];
                transaction.setMainAccount4(capd.getMainAccountId4());
                credit.setAllocatedValue(credit.getAllocatedValue().add(correctionValue));
            }
            if (incomingFinancialTransaction != null && incomingFinancialTransaction.getId() != null && (message = IncomingFinancialTransactionBO.update(incomingFinancialTransaction, incomingFinancialTransaction.getUnAllocatedValue().subtract(correctionValue))) != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }
}

