/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.bp.ValuationCorrectionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetManager;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchParameterDataBean;
import nl.ibs.fac.db.TransactionBatchParameterManager;
import nl.ibs.fac.db.TransactionBatchParameterManagerFactory;
import nl.ibs.fac.db.TransactionBatchParameterPK;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class MassCorrectionBP
extends MassTransactionBP {
    private static final long serialVersionUID = -4886986842375239773L;
    public static final String ACCOUNTINGPRINCIPLE = "ACCPRINC";
    public static final String AP_DESCRIPTION = "APDESCR";
    public static final String TYPE = "TYPE";
    public static final String DEPREC_LIFE = "DEPRLIFE";
    public static final String RESIDUAL_PERC = "RESPERC";
    public static final String RESIDUAL_AMT = "RESAMOUNT";
    private static BigDecimal EMPTY = new BigDecimal(-1);
    private int facYearParm;
    private int facPeriodParm;
    private Valuation valuation;
    private String type;
    private String ap_description;
    private int accountingPrinciple;
    private int depreciatableLife;
    private int depreciatableLife_2;
    private BigDecimal residualPercentage;
    private BigDecimal residualPercentage_2;
    private BigDecimal residualValue;
    private BigDecimal residualValue_2;
    private TransactionBatchParameterManager manager;
    private TransactionBatchParameterDataBean bean;
    private TransactionBatchParameterPK key;
    private DecimalFormat fmt = new DecimalFormat();

    public MassCorrectionBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
        this.manager = TransactionBatchParameterManagerFactory.getInstance(company.getDBData());
        this.bean = new TransactionBatchParameterDataBean();
        this.key = new TransactionBatchParameterPK();
        this.fmt.setMinimumFractionDigits(2);
        this.fmt.setMaximumFractionDigits(2);
    }

    @Override
    public String[] retrieveYearsAndPeriods() throws Exception {
        String[] yps = new String[4];
        int[] yps2 = new int[]{0, 0};
        if (this.company.getLastDepreciationRunYear() > 0) {
            yps2 = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
            if (BookYearBO.getPeriodStatus(this.company, yps2[0], yps2[1]) != 2) {
                yps2[0] = this.company.getCurrentBookYear();
                yps2[1] = 1;
            }
        } else {
            yps2[0] = this.company.getCurrentBookYear();
            yps2[1] = 1;
        }
        if (yps2[0] == 0) {
            yps[0] = "";
            yps[1] = "";
        } else {
            yps[0] = "" + yps2[0];
            yps[1] = "" + yps2[1];
        }
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    @Override
    public String[] validateFACYearAndPeriod(int facYear, int facPeriod) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        int status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod);
        if (status == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    @Override
    public String createProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.seqNr = 0;
        ValuationCorrectionBP businessProcess = new ValuationCorrectionBP(this.company, this.company.getNumberOfPeriods());
        String reasonDescription = this.getTransactionDescription(transactionBatch);
        String message = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            for (Asset this.asset : this.retrieveAssets()) {
                boolean validationOK;
                System.out.println(this.asset.getId());
                this.valuation = (Valuation)ValuationBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), this.accountingPrinciple)[0];
                if (this.valuation == null || !(validationOK = this.validate()) || (message = this.createAnonymousTransaction(transactionBatch.getBatchId(), reasonDescription, businessProcess)) == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private Collection retrieveAssets() throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        String filter = BOAdapter.addFilterTerm(null, "companyId = ?_companyId");
        filter = BOAdapter.addFilterTerm(filter, "credit = ?_credit");
        filter = BOAdapter.addFilterTerm(filter, "subAsset = ?_subAsset");
        filter = BOAdapter.addFilterTerm(filter, "typeId = ?_type");
        filter = BOAdapter.addFilterTerm(filter, "state = ?_state");
        query.setFilter(filter);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", this.company.getId());
        parameters.put("_credit", Boolean.toString(false));
        parameters.put("_subAsset", Boolean.toString(true));
        parameters.put("_type", this.type);
        parameters.put("_state", "2");
        query.setParameters(parameters);
        query.setOrdering("id");
        AssetManager manager = AssetManagerFactory.getInstance(this.company.getDBData());
        return manager.getCollection(query);
    }

    private boolean validate() throws Exception {
        int[] nextPeriod;
        boolean validationOK = false;
        if (this.valuation.getLastDepreciationBookYear() != 0 && PeriodHelper.isBefore((nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.valuation.getLastDepreciationBookYear(), this.valuation.getLastDepreciationPeriod()))[0], nextPeriod[1], this.facYear, this.facPeriod)) {
            return validationOK;
        }
        if (this.valuation.getDepreciationMethod() != 1) {
            return validationOK;
        }
        if (this.valuation.getDepreciatableLife() <= this.valuation.getNumberOfDepreciatedPeriods()) {
            return validationOK;
        }
        if (this.depreciatableLife != EMPTY.intValue() && this.depreciatableLife != this.valuation.getDepreciatableLife()) {
            validationOK = true;
        }
        if (this.residualPercentage != EMPTY && this.residualPercentage != this.valuation.getResidualPercentage()) {
            validationOK = true;
        }
        return validationOK;
    }

    private String createAnonymousTransaction(int batchId, String reasonDescription, ValuationCorrectionBP businessProcess) throws Exception {
        this.facYear = this.facYearParm;
        this.facPeriod = this.facPeriodParm;
        if (PeriodHelper.isAfter(this.valuation.getStartDepreciationBookYear(), this.valuation.getStartDepreciationPeriod(), this.facYear, this.facPeriod)) {
            this.facYear = this.valuation.getStartDepreciationBookYear();
            this.facPeriod = this.valuation.getStartDepreciationPeriod();
        }
        this.finDimId1 = this.asset.getFinDimId1();
        this.finDimId2 = this.asset.getFinDimId2();
        this.finDimId3 = this.asset.getFinDimId3();
        this.finDimId4 = this.asset.getFinDimId4();
        this.finDimId5 = this.asset.getFinDimId5();
        boolean hasNotPostedTransactions = AssetBO.hasNotPostedTransactions(this.asset);
        String message = null;
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, this.seqNr, reasonDescription, this.asset.getCora(), this.asset.getId(), this.accountingPrinciple, 9, 60, this.facYear, this.facPeriod, this.finYear, this.finPeriod, this.valuation.getPostedAcquisitionBalance(), this.valuation.getPostedDepreciationBalance(), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(this.accountingPrinciple, 9), 0, batchId, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
        } else {
            Transaction anonymousTransaction = (Transaction)objects[0];
            anonymousTransaction.setDaybookId("" + this.valuation.getDepreciatableLife());
            anonymousTransaction.setVoucherId("" + (this.depreciatableLife == EMPTY.intValue() ? this.valuation.getDepreciatableLife() : this.depreciatableLife));
            anonymousTransaction.setMainAccount1("" + this.valuation.getResidualPercentage().multiply(new BigDecimal("100")).intValue());
            anonymousTransaction.setMainAccount2("" + (this.residualPercentage == EMPTY ? anonymousTransaction.getMainAccount1() : "" + this.residualPercentage.multiply(new BigDecimal("100")).intValue()));
            anonymousTransaction.setMainAccount3("" + this.valuation.getResidualValue().multiply(new BigDecimal("100")).intValue());
            anonymousTransaction.setMainAccount4("" + (this.residualValue == EMPTY ? anonymousTransaction.getMainAccount3() : "" + this.residualValue.multiply(new BigDecimal("100")).intValue()));
            if (hasNotPostedTransactions) {
                anonymousTransaction.setReasonCode(50);
            } else {
                String error = businessProcess.investigateTransactionsToBeReversed(this.asset, this.facYear, this.facPeriod, this.valuation, 0);
                if (error != null) {
                    if ("ChangeNotAllowedBeforePartialDisinvestment".equals(error.trim())) {
                        anonymousTransaction.setReasonCode(80);
                    } else {
                        anonymousTransaction.setReasonCode(81);
                    }
                } else if (this.depreciatableLife != EMPTY.intValue() && this.depreciatableLife <= this.valuation.getNumberOfDepreciatedPeriods()) {
                    anonymousTransaction.setReasonCode(82);
                }
            }
            if (this.documentNr == 0) {
                this.documentNr = anonymousTransaction.getDocumentNr();
            }
            ++this.documentNr;
        }
        return message;
    }

    @Override
    public String postProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.getParameters(transactionBatch);
        String message = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            ValuationCorrectionBP businessProcess = new ValuationCorrectionBP(this.company, this.company.getNumberOfPeriods());
            Transaction transaction = null;
            Iterator transactions = TransactionBO.getTransactions(transactionBatch).iterator();
            while (transactions.hasNext()) {
                transaction = (Transaction)transactions.next();
                if (transaction.getReasonCode() < 50) {
                    this.asset = transaction.getAsset();
                    this.valuation = (Valuation)ValuationBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), this.accountingPrinciple)[0];
                    if (this.valuation != null) {
                        this.depreciatableLife_2 = this.depreciatableLife == EMPTY.intValue() ? this.valuation.getDepreciatableLife() : this.depreciatableLife;
                        this.residualPercentage_2 = this.residualPercentage == EMPTY ? this.valuation.getResidualPercentage() : this.residualPercentage;
                        this.residualValue_2 = this.residualValue == EMPTY ? this.valuation.getResidualValue() : this.residualValue;
                        message = businessProcess.updateValuation(this.asset, this.valuation, transaction.getBookYear(), transaction.getPeriod(), transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization(), this.depreciatableLife_2, this.residualPercentage_2, this.residualValue_2, transaction.getDescription(), user, transactionBatch.getBatchId(), transaction.getDocumentNr());
                        if (message != null) {
                            BOAdapter.investigate(null, dbTransaction);
                            return message;
                        }
                    }
                }
                transactions.remove();
                message = TransactionBO.delete(transaction, null, null);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            transactionBatch.setState(1);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    @Override
    public void addParameters(TransactionBatch transactionBatch, String[][] selections) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.bean.setCompanyId(transactionBatch.getCompanyId());
        this.bean.setBatchId(transactionBatch.getBatchId());
        this.addParameter(TYPE, selections);
        this.addParameter(ACCOUNTINGPRINCIPLE, selections);
        this.addParameter(AP_DESCRIPTION, selections);
        this.addParameter(DEPREC_LIFE, selections);
        this.addParameter(RESIDUAL_PERC, selections);
        this.addParameter(RESIDUAL_AMT, selections);
        transactionBatch.setEndYear(Integer.parseInt(MassCorrectionBP.retrieve("FACPERYEAR", selections)));
        transactionBatch.setEndPeriod(Integer.parseInt(MassCorrectionBP.retrieve("FACPERPER", selections)));
        transactionBatch.setFinYear(Integer.parseInt(MassCorrectionBP.retrieve("FINPERYEAR", selections)));
        transactionBatch.setFinPeriod(Integer.parseInt(MassCorrectionBP.retrieve("FINPERPER", selections)));
    }

    private void addParameter(String parmName, String[][] selections) throws Exception {
        this.bean.setParameterName(parmName);
        for (int i = 0; i < selections.length; ++i) {
            if (!selections[i][0].equals(parmName)) continue;
            this.bean.setParameterValue(selections[i][1]);
            this.manager.create(this.bean);
            return;
        }
    }

    private void getParameters(TransactionBatch transactionBatch) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.facYear = transactionBatch.getEndYear();
        this.facPeriod = transactionBatch.getEndPeriod();
        this.finYear = transactionBatch.getFinYear();
        this.finPeriod = transactionBatch.getFinPeriod();
        this.facYearParm = this.facYear;
        this.facPeriodParm = this.facPeriod;
        this.type = this.getParameter(transactionBatch, TYPE);
        String s = this.getParameter(transactionBatch, ACCOUNTINGPRINCIPLE);
        this.accountingPrinciple = s == null || s.trim().length() == 0 ? 0 : Integer.parseInt(s);
        this.ap_description = this.getParameter(transactionBatch, AP_DESCRIPTION);
        s = this.getParameter(transactionBatch, DEPREC_LIFE);
        this.depreciatableLife = s == null || s.trim().length() == 0 ? EMPTY.intValue() : Integer.parseInt(s);
        s = this.getParameter(transactionBatch, RESIDUAL_PERC);
        this.residualPercentage = s == null || s.trim().length() == 0 ? EMPTY : new BigDecimal(Double.parseDouble(s));
        s = this.getParameter(transactionBatch, RESIDUAL_AMT);
        this.residualValue = s == null || s.trim().length() == 0 ? EMPTY : new BigDecimal(Double.parseDouble(s));
    }

    public String getParameter(TransactionBatch transactionBatch, String parmName) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.key.setParameterName(parmName);
        try {
            return this.manager.findByPrimaryKey(this.key).getParameterValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String[][] getExtraBatchDetails(TransactionBatch transactionBatch) throws Exception {
        String[][] details = new String[5][2];
        this.getParameters(transactionBatch);
        details[0][0] = "Label.Type";
        details[0][1] = this.type;
        details[1][0] = "Label.AccountingPrinciple";
        details[1][1] = this.ap_description;
        details[2][0] = "Label.DepreciationLife";
        details[2][1] = this.depreciatableLife == EMPTY.intValue() ? "" : "" + this.depreciatableLife;
        details[3][0] = "Label.ResidualValuePercentage";
        details[3][1] = this.residualPercentage == EMPTY ? "" : this.fmt.format(this.residualPercentage.doubleValue());
        details[4][0] = "Label.ResidualValueAmount";
        details[4][1] = this.residualValue == EMPTY ? "" : this.fmt.format(this.residualValue.doubleValue());
        return details;
    }

    @Override
    public String getTransactionDescription(TransactionBatch transactionBatch) throws Exception {
        StringBuffer result = new StringBuffer();
        this.getParameters(transactionBatch);
        if (this.depreciatableLife != EMPTY.intValue() && this.residualPercentage == EMPTY) {
            result.append(LanguageHelper.getString("nl.ibs.fac.language", "ChangedDepreciationLife"));
            return result.toString();
        }
        if (this.residualPercentage != EMPTY && this.depreciatableLife == EMPTY.intValue()) {
            result.append(LanguageHelper.getString("nl.ibs.fac.language", "ChangedResidualValue"));
            return result.toString();
        }
        result.append(LanguageHelper.getString("nl.ibs.fac.language", "ChangedMiscellaneous"));
        return result.toString();
    }
}

