/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.bp.MovementBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetManager;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchParameterDataBean;
import nl.ibs.fac.db.TransactionBatchParameterManager;
import nl.ibs.fac.db.TransactionBatchParameterManagerFactory;
import nl.ibs.fac.db.TransactionBatchParameterPK;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class MassMovementBP
extends MassTransactionBP {
    private static final long serialVersionUID = 8301929377620142116L;
    public static final String DIM = "DIM";
    public static final String OLDVALUE = "OLDVALUE";
    public static final String NEWVALUE = "NEWVALUE";
    public static final String OLDVALUE_FORMATTED = "OLDVALUE_F";
    public static final String NEWVALUE_FORMATTED = "NEWVALUE_F";
    public static final String DIMTEXT1 = "DIMTEXT1";
    public static final String DIMTEXT2 = "DIMTEXT2";
    public static final String DIMTEXT3 = "DIMTEXT3";
    public static final String DIMTEXT4 = "DIMTEXT4";
    public static final String DIMTEXT5 = "DIMTEXT5";
    private int dim;
    private int originalFacYear;
    private int originalFacPeriod;
    private String[] dimText = new String[]{"", "", "", "", ""};
    private String oldValue;
    private String newValue;
    private String oldValueFrm;
    private String newValueFrm;
    private TransactionBatchParameterManager manager;
    private TransactionBatchParameterDataBean bean;
    private TransactionBatchParameterPK key;

    public MassMovementBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
        this.manager = TransactionBatchParameterManagerFactory.getInstance(company.getDBData());
        this.bean = new TransactionBatchParameterDataBean();
        this.key = new TransactionBatchParameterPK();
    }

    @Override
    public String[] retrieveYearsAndPeriods() throws Exception {
        String[] yps = new String[4];
        if (this.company.getLastDepreciationRunYear() > 0) {
            int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
            yps[0] = "" + nextPeriod[0];
            yps[1] = "" + nextPeriod[1];
        } else {
            yps[0] = "" + this.company.getCurrentBookYear();
            yps[1] = "1";
        }
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    @Override
    public String[] validateFACYearAndPeriod(int facYear, int facPeriod) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        int status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod);
        if (status == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    @Override
    public String createProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.getParameters(transactionBatch);
        String message = null;
        String transactionDescription = this.getTransactionDescription(transactionBatch);
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            for (Asset this.asset : this.retrieveAssets(this.dim, this.oldValue)) {
                message = this.createAnonymousTransaction(transactionBatch.getBatchId(), 1, transactionDescription);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private Collection retrieveAssets(int dim, String oldValue) throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        String filter = BOAdapter.addFilterTerm(null, "companyId = ?_companyId");
        filter = BOAdapter.addFilterTerm(filter, "credit = ?_credit");
        filter = BOAdapter.addFilterTerm(filter, "subAsset = ?_subAsset");
        filter = BOAdapter.addFilterTerm(filter, "finDimId" + (dim + 1) + " = ?_finDim");
        query.setFilter(filter);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", this.company.getId());
        parameters.put("_credit", Boolean.toString(false));
        parameters.put("_subAsset", Boolean.toString(true));
        parameters.put("_finDim", oldValue);
        query.setParameters(parameters);
        query.setOrdering("id");
        AssetManager manager = AssetManagerFactory.getInstance(this.company.getDBData());
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (Asset this.asset : manager.getCollection(query)) {
            if ((this.asset.getState() == 4 || this.asset.getState() == 5 || this.asset.getState() == 7) && PeriodHelper.isBefore(this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), this.facYear, this.facPeriod)) continue;
            assets.add(this.asset);
        }
        return assets;
    }

    private String createAnonymousTransaction(int batchId, int accountingPrinciple, String reasonDescription) throws Exception {
        String message = null;
        boolean hasNotPostedTransactions = false;
        this.facYear = this.originalFacYear;
        this.facPeriod = this.originalFacPeriod;
        if (PeriodHelper.isAfter(this.asset.getStartUseYear(), this.asset.getStartUsePeriod(), this.facYear, this.facPeriod)) {
            this.facYear = this.asset.getStartUseYear();
            this.facPeriod = this.asset.getStartUsePeriod();
        }
        if (PeriodHelper.isAfter(this.asset.getFinDimYearFrom(), this.asset.getFinDimPeriodFrom(), this.facYear, this.facPeriod)) {
            this.facYear = this.asset.getFinDimYearFrom();
            this.facPeriod = this.asset.getFinDimPeriodFrom();
        }
        hasNotPostedTransactions = AssetBO.hasNotPostedTransactions(this.asset);
        this.finDimId1 = this.asset.getFinDimId1();
        this.finDimId2 = this.asset.getFinDimId2();
        this.finDimId3 = this.asset.getFinDimId3();
        this.finDimId4 = this.asset.getFinDimId4();
        this.finDimId5 = this.asset.getFinDimId5();
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), 0, 0, reasonDescription, this.asset.getCora(), this.asset.getId(), accountingPrinciple, 9, 40, this.facYear, this.facPeriod, this.finYear, this.finPeriod, new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(accountingPrinciple, 9), 0, batchId, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
            return message;
        }
        Transaction anonymousTransaction = (Transaction)objects[0];
        if (this.asset.getState() == 0) {
            anonymousTransaction.setReasonCode(51);
        } else if (this.asset.getState() == 4 || this.asset.getState() == 5 || this.asset.getState() == 7) {
            anonymousTransaction.setReasonCode(60);
        } else if (hasNotPostedTransactions) {
            anonymousTransaction.setReasonCode(50);
        }
        if (anonymousTransaction.getReasonCode() == 0) {
            Valuation valuation = (Valuation)ValuationBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), 1)[0];
            anonymousTransaction.setAmount1(valuation == null ? ZERO : valuation.getPostedAcquisitionBalance());
            anonymousTransaction.setAmount2(valuation == null ? ZERO : valuation.getPostedDepreciationBalance());
        }
        return message;
    }

    @Override
    public String postProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.getParameters(transactionBatch);
        int limitYear = 0;
        int limitPeriod = 0;
        String reasonDescription = LanguageHelper.getString("nl.ibs.fac.language", "ChangeOf").trim() + " " + this.dimText[this.dim];
        String[] ids = new String[5];
        String message = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            MovementBP movementBP = new MovementBP(this.company, this.numberOfPeriods);
            Transaction transaction = null;
            Iterator transactions = TransactionBO.getTransactions(transactionBatch).iterator();
            while (transactions.hasNext()) {
                transaction = (Transaction)transactions.next();
                if (transaction.getReasonCode() < 50) {
                    this.asset = transaction.getAsset();
                    ids[0] = this.asset.getFinDimId1();
                    ids[1] = this.asset.getFinDimId2();
                    ids[2] = this.asset.getFinDimId3();
                    ids[3] = this.asset.getFinDimId4();
                    ids[4] = this.asset.getFinDimId5();
                    ids[this.dim] = this.newValue;
                    message = movementBP.move(this.asset, transaction.getBookYear(), transaction.getPeriod(), transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization(), ids, reasonDescription, user, limitYear, limitPeriod, transactionBatch.getBatchId(), transaction.getDocumentNr());
                    if (message != null) {
                        BOAdapter.investigate(null, dbTransaction);
                        return message;
                    }
                }
                transactions.remove();
                message = TransactionBO.delete(transaction, null, null);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            transactionBatch.setState(1);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    @Override
    public void addParameters(TransactionBatch transactionBatch, String[][] selections) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.bean.setCompanyId(transactionBatch.getCompanyId());
        this.bean.setBatchId(transactionBatch.getBatchId());
        this.addParameter(DIM, selections);
        this.addParameter(OLDVALUE, selections);
        this.addParameter(NEWVALUE, selections);
        this.addParameter(OLDVALUE_FORMATTED, selections);
        this.addParameter(NEWVALUE_FORMATTED, selections);
        this.addParameter(DIMTEXT1, selections);
        this.addParameter(DIMTEXT2, selections);
        this.addParameter(DIMTEXT3, selections);
        this.addParameter(DIMTEXT4, selections);
        this.addParameter(DIMTEXT5, selections);
        transactionBatch.setEndYear(Integer.parseInt(MassMovementBP.retrieve("FACPERYEAR", selections)));
        transactionBatch.setEndPeriod(Integer.parseInt(MassMovementBP.retrieve("FACPERPER", selections)));
        transactionBatch.setFinYear(Integer.parseInt(MassMovementBP.retrieve("FINPERYEAR", selections)));
        transactionBatch.setFinPeriod(Integer.parseInt(MassMovementBP.retrieve("FINPERPER", selections)));
    }

    private void addParameter(String parmName, String[][] selections) throws Exception {
        this.bean.setParameterName(parmName);
        for (int i = 0; i < selections.length; ++i) {
            if (!selections[i][0].equals(parmName)) continue;
            this.bean.setParameterValue(selections[i][1]);
            this.manager.create(this.bean);
            return;
        }
    }

    private void getParameters(TransactionBatch transactionBatch) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.facYear = transactionBatch.getEndYear();
        this.facPeriod = transactionBatch.getEndPeriod();
        this.finYear = transactionBatch.getFinYear();
        this.finPeriod = transactionBatch.getFinPeriod();
        this.dim = Integer.parseInt(this.getParameter(DIM));
        this.oldValue = this.getParameter(OLDVALUE);
        this.newValue = this.getParameter(NEWVALUE);
        this.oldValueFrm = this.getParameter(OLDVALUE_FORMATTED);
        this.newValueFrm = this.getParameter(NEWVALUE_FORMATTED);
        this.dimText[0] = this.getParameter(DIMTEXT1);
        this.dimText[1] = this.getParameter(DIMTEXT2);
        this.dimText[2] = this.getParameter(DIMTEXT3);
        this.dimText[3] = this.getParameter(DIMTEXT4);
        this.dimText[4] = this.getParameter(DIMTEXT5);
        this.originalFacYear = this.facYear;
        this.originalFacPeriod = this.facPeriod;
    }

    private String getParameter(String parmName) throws Exception {
        this.key.setParameterName(parmName);
        try {
            return this.manager.findByPrimaryKey(this.key).getParameterValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getParameter(TransactionBatch transactionBatch, String parmName) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.key.setParameterName(parmName);
        try {
            return this.manager.findByPrimaryKey(this.key).getParameterValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String[][] getExtraBatchDetails(TransactionBatch transactionBatch) throws Exception {
        String[][] details = new String[3][2];
        this.getParameters(transactionBatch);
        details[0][0] = "Label.AnalysisGroup";
        details[0][1] = this.dimText[this.dim];
        details[1][0] = "Label.OldValue";
        details[1][1] = this.oldValueFrm;
        details[2][0] = "Label.NewValue";
        details[2][1] = this.newValueFrm;
        return details;
    }

    @Override
    public String getTransactionDescription(TransactionBatch transactionBatch) throws Exception {
        StringBuffer result = new StringBuffer();
        this.getParameters(transactionBatch);
        result.append(this.dimText[this.dim]);
        result.append(" ");
        result.append(this.oldValueFrm);
        result.append(" > ");
        result.append(this.newValueFrm);
        return result.toString();
    }
}

