/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.FinancialDimensionHistoryBO;
import nl.ibs.fac.boadapters.MemoBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetManager;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Memo;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchParameterDataBean;
import nl.ibs.fac.db.TransactionBatchParameterManager;
import nl.ibs.fac.db.TransactionBatchParameterManagerFactory;
import nl.ibs.fac.db.TransactionBatchParameterPK;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.queries.TransactionQuery;
import nl.ibs.fac.queries.ValuationMainAccountQuery;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class MassRemoveBP
extends MassTransactionBP {
    private static final long serialVersionUID = 6691684702443212400L;
    public static final String TYPEFROM = "TYPEFROM";
    public static final String TYPETO = "TYPETO";
    public static final String REMPER_YEAR = "REMPERYEAR";
    public static final String REMPER_PER = "REMPERPER";
    public static final String INCLMOV_IC = "INCLMOVIC";
    private HashSet<String> assetIdsWithNotBookedTransactions = null;
    private String typeFrom;
    private String typeTo;
    private int remYear;
    private int remPeriod;
    private boolean includeMovementsIC;
    private TransactionBatchParameterManager manager;
    private TransactionBatchParameterDataBean bean;
    private TransactionBatchParameterPK key;

    public MassRemoveBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
        this.manager = TransactionBatchParameterManagerFactory.getInstance(company.getDBData());
        this.bean = new TransactionBatchParameterDataBean();
        this.key = new TransactionBatchParameterPK();
    }

    public String[] retrieveRemoveYearAndPeriod() throws Exception {
        String[] pyp = new String[2];
        if (this.company.getLastDepreciationRunYear() == 0) {
            pyp[0] = "" + this.company.getCurrentBookYear();
            pyp[1] = "1";
        } else {
            int i2;
            int i1 = this.company.getLastDepreciationRunYear() - 1;
            if (BookYearBO.getPeriodStatus(this.company, i1, i2 = this.company.getNumberOfPeriods()) == 0) {
                pyp[0] = "" + this.company.getLastDepreciationRunYear();
                pyp[1] = "1";
            } else {
                pyp[0] = "" + i1;
                pyp[1] = "" + i2;
            }
        }
        return pyp;
    }

    public String[] validateRemoveYearAndPeriod(int wofYear, int wofPeriod) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        int status = BookYearBO.getPeriodStatus(this.company, wofYear, wofPeriod);
        if (status == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    @Override
    public String[] retrieveYearsAndPeriods() throws Exception {
        String[] yps = new String[4];
        return yps;
    }

    @Override
    public String[] validateFACYearAndPeriod(int facYear, int facPeriod) throws Exception {
        String[] messages = new String[2];
        return messages;
    }

    @Override
    public String createProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.getParameters(transactionBatch);
        String message = null;
        String transactionDescription = this.getTransactionDescription(transactionBatch);
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            for (Asset this.asset : this.retrieveAssets()) {
                message = this.createAnonymousTransaction(transactionBatch.getBatchId(), 1, transactionDescription);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private Collection retrieveAssets() throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        String filter = BOAdapter.addFilterTerm(null, "companyId = ?_companyId");
        filter = BOAdapter.addFilterTerm(filter, "credit = ?_credit");
        filter = BOAdapter.addFilterTerm(filter, "subAsset = ?_subAsset");
        filter = BOAdapter.addFilterTerm(filter, "state > ?_state");
        query.setFilter(filter);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", this.company.getId());
        parameters.put("_credit", Boolean.toString(false));
        parameters.put("_subAsset", Boolean.toString(true));
        parameters.put("_state", "2");
        query.setParameters(parameters);
        query.setOrdering("id");
        String typeId = null;
        AssetManager manager = AssetManagerFactory.getInstance(this.company.getDBData());
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (Asset this.asset : manager.getCollection(query)) {
            typeId = this.asset.getAssetType().getId();
            if (this.typeFrom.length() > 0 && typeId.compareTo(this.typeFrom) < 0 || this.typeTo.length() > 0 && typeId.compareTo(this.typeTo) > 0 || !this.includeMovementsIC && this.asset.getState() == 5 || !PeriodHelper.isAfter(this.remYear, this.remPeriod, this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod())) continue;
            assets.add(this.asset);
        }
        return assets;
    }

    private String createAnonymousTransaction(int batchId, int accountingPrinciple, String reasonDescription) throws Exception {
        Object[] objects;
        String message = null;
        if (this.assetIdsWithNotBookedTransactions == null) {
            this.getAssetIdsWithNotBookedTransactions();
        }
        if ((objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), 0, 0, reasonDescription, this.asset.getCora(), this.asset.getId(), accountingPrinciple, 9, 145, this.asset.getDisinvestmentYear(), this.asset.getDisinvestmentPeriod(), this.asset.getStartUseYear(), this.asset.getStartUsePeriod(), new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), null, "", "", "", "", "", this.retrieveJournalingState(accountingPrinciple, 9), 0, batchId, this.user, this.asset.getTypeId()))[0] == null) {
            message = (String)objects[1];
            return message;
        }
        Transaction anonymousTransaction = (Transaction)objects[0];
        anonymousTransaction.setDescription(reasonDescription);
        if (!this.assetIdsWithNotBookedTransactions.isEmpty()) {
            if (this.assetIdsWithNotBookedTransactions.contains(this.asset.getId())) {
                anonymousTransaction.setReasonCode(55);
            } else {
                TransactionQuery query = new TransactionQuery(this.company.getDBData(), this.asset);
                Collection transactions = query.fetchData(null, null, null, 9999);
                if (transactions != null && !transactions.isEmpty()) {
                    for (Transaction transaction : transactions) {
                        if (transaction.getMainTransactionType() != 2 || transaction.getTransactionType() != 30 && transaction.getTransactionType() != 50 && transaction.getTransactionType() != 140 || PeriodHelper.isAfter(this.remYear, this.remPeriod, transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization())) continue;
                        anonymousTransaction.setReasonCode(56);
                    }
                }
            }
        }
        return message;
    }

    private void getAssetIdsWithNotBookedTransactions() throws Exception {
        this.assetIdsWithNotBookedTransactions = new HashSet();
        for (Transaction transaction : TransactionBO.getTransactions(this.company.getCurrentTransactionBatch())) {
            String assetId = transaction.getAssetId();
            if (this.assetIdsWithNotBookedTransactions.contains(assetId)) continue;
            this.assetIdsWithNotBookedTransactions.add(assetId);
        }
    }

    @Override
    public String postProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.getParameters(transactionBatch);
        String message = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Transaction transaction = null;
            Iterator transactions = TransactionBO.getTransactions(transactionBatch).iterator();
            while (transactions.hasNext()) {
                transaction = (Transaction)transactions.next();
                if (transaction.getReasonCode() != 55 && transaction.getReasonCode() != 56) {
                    this.asset = transaction.getAsset();
                    transactions.remove();
                    transaction.delete();
                    message = MassRemoveBP.removeDependentObjects(this.asset);
                    if (message == null) {
                        this.asset.delete();
                        continue;
                    }
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                transactions.remove();
                transaction.delete();
            }
            transactionBatch.delete();
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    public static String removeDependentObjects(Asset asset) throws Exception {
        String message = null;
        if (FinancialDimensionHistoryBO.getLast(asset, 0, 0) != null) {
            message = FinancialDimensionHistoryBO.deleteAll(asset);
        }
        if (message == null && asset.getHasMemo()) {
            Object[] oa = MemoBO.get(asset);
            message = oa[0] == null ? (String)oa[1] : MemoBO.delete(asset, (Memo)oa[0]);
        }
        ValuationMainAccountQuery query = new ValuationMainAccountQuery(asset.getDBData(), asset.getCompanyId(), "A", asset.getId(), "1");
        Collection maSchemes = query.fetchData(null, null, null, 0);
        for (ValuationMainAccount maScheme : maSchemes) {
            message = ValuationMainAccountBO.delete(maScheme);
            if (message == null) continue;
            return message;
        }
        if (message == null) {
            Collection transactions = TransactionBO.getTransactions(asset);
            for (Transaction transaction : transactions) {
                IncomingFinancialTransaction ift;
                if (transaction.getIncomingFinancialTransactionId() == null || transaction.getIncomingFinancialTransactionId().trim().length() <= 0 || (ift = transaction.getIncomingFinancialTransaction()) == null) continue;
                BigDecimal amount = null;
                if (transaction.getMainTransactionType() == 1) {
                    amount = transaction.getAmount1();
                } else if (transaction.getMainTransactionType() == 2) {
                    amount = transaction.getAmount3().negate();
                }
                if (amount != null) {
                    ift.setUnAllocatedValue(ift.getUnAllocatedValue().add(amount));
                }
                ift.setDeletedTransactions(true);
            }
            TransactionBO.deleteTransactions(asset);
        }
        if (message == null) {
            Collection valuations = asset.getValuationsCollection(null);
            for (Valuation valuation : valuations) {
                ValuationBO.delete(valuation);
            }
        }
        return message;
    }

    @Override
    public void addParameters(TransactionBatch transactionBatch, String[][] selections) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.bean.setCompanyId(transactionBatch.getCompanyId());
        this.bean.setBatchId(transactionBatch.getBatchId());
        this.addParameter(TYPEFROM, selections);
        this.addParameter(TYPETO, selections);
        this.addParameter(REMPER_YEAR, selections);
        this.addParameter(REMPER_PER, selections);
        this.addParameter(INCLMOV_IC, selections);
    }

    private void addParameter(String parmName, String[][] selections) throws Exception {
        this.bean.setParameterName(parmName);
        for (int i = 0; i < selections.length; ++i) {
            if (!selections[i][0].equals(parmName)) continue;
            this.bean.setParameterValue(selections[i][1]);
            this.manager.create(this.bean);
            return;
        }
    }

    private void getParameters(TransactionBatch transactionBatch) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.facYear = transactionBatch.getEndYear();
        this.facPeriod = transactionBatch.getEndPeriod();
        this.finYear = transactionBatch.getFinYear();
        this.finPeriod = transactionBatch.getFinPeriod();
        this.typeFrom = this.getParameter(TYPEFROM);
        this.typeTo = this.getParameter(TYPETO);
        this.remYear = Integer.parseInt(this.getParameter(REMPER_YEAR));
        this.remPeriod = Integer.parseInt(this.getParameter(REMPER_PER));
        this.includeMovementsIC = false;
        if ("true".equals(this.getParameter(INCLMOV_IC).trim())) {
            this.includeMovementsIC = true;
        }
    }

    private String getParameter(String parmName) throws Exception {
        this.key.setParameterName(parmName);
        try {
            return this.manager.findByPrimaryKey(this.key).getParameterValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getParameter(TransactionBatch transactionBatch, String parmName) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.key.setParameterName(parmName);
        try {
            return this.manager.findByPrimaryKey(this.key).getParameterValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String[][] getExtraBatchDetails(TransactionBatch transactionBatch) throws Exception {
        String[][] details = new String[4][2];
        this.getParameters(transactionBatch);
        details[0][0] = "Label.AssetTypeFrom";
        details[0][1] = this.typeFrom;
        details[1][0] = "Label.AssetTypeTo";
        details[1][1] = this.typeTo;
        details[2][0] = "Label.WriteOffPeriod";
        details[2][1] = "" + this.remYear + "-" + this.remPeriod;
        details[3][0] = "Label.IncludeMovementsIC";
        details[3][1] = this.includeMovementsIC ? LanguageHelper.getString("nl.ibs.fac.language", "Yes") : LanguageHelper.getString("nl.ibs.fac.language", "No");
        return details;
    }

    @Override
    public String getTransactionDescription(TransactionBatch transactionBatch) throws Exception {
        StringBuffer result = new StringBuffer();
        this.getParameters(transactionBatch);
        result.append(LanguageHelper.getString("nl.ibs.fac.language", "WriteOffPeriod"));
        result.append(" ");
        result.append("" + this.remYear);
        result.append("-");
        result.append("" + this.remPeriod);
        return result.toString();
    }
}

