/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.HashMap;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.bp.MassCorrectionBP;
import nl.ibs.fac.bp.MassImportBP;
import nl.ibs.fac.bp.MassMovementBP;
import nl.ibs.fac.bp.MassRemoveBP;
import nl.ibs.fac.bp.MassWriteOffBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchManager;
import nl.ibs.fac.db.TransactionBatchManagerFactory;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public abstract class MassTransactionBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 4686207207324448369L;
    public static final String PROCTYPE = "PROCTYPE";
    public static final String FACPER_YEAR = "FACPERYEAR";
    public static final String FACPER_PER = "FACPERPER";
    public static final String FINPER_YEAR = "FINPERYEAR";
    public static final String FINPER_PER = "FINPERPER";
    protected static BigDecimal ZERO = new BigDecimal(0.0);

    public MassTransactionBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public abstract String[] retrieveYearsAndPeriods() throws Exception;

    public abstract String[] validateFACYearAndPeriod(int var1, int var2) throws Exception;

    public abstract void addParameters(TransactionBatch var1, String[][] var2) throws Exception;

    public abstract String[][] getExtraBatchDetails(TransactionBatch var1) throws Exception;

    public abstract String getTransactionDescription(TransactionBatch var1) throws Exception;

    public abstract String createProposal(TransactionBatch var1, String var2) throws Exception;

    public abstract String postProposal(TransactionBatch var1, String var2) throws Exception;

    public static MassTransactionBP getInstanceFor(TransactionBatch transactionBatch) throws Exception {
        Company company = (Company)CompanyBO.get(transactionBatch.getDBData(), transactionBatch.getCompanyId())[0];
        int numberOfPeriods = company.getNumberOfPeriods();
        MassTransactionBP massTransactionBP = null;
        if (transactionBatch.getMassTransactionProcessType() == 0) {
            massTransactionBP = new MassWriteOffBP(company, numberOfPeriods);
        } else if (transactionBatch.getMassTransactionProcessType() == 1) {
            massTransactionBP = new MassMovementBP(company, numberOfPeriods);
        } else if (transactionBatch.getMassTransactionProcessType() == 2) {
            massTransactionBP = new MassCorrectionBP(company, numberOfPeriods);
        } else if (transactionBatch.getMassTransactionProcessType() == 3) {
            massTransactionBP = new MassRemoveBP(company, numberOfPeriods);
        } else if (transactionBatch.getMassTransactionProcessType() == 4) {
            massTransactionBP = new MassImportBP(company, numberOfPeriods);
        } else if (transactionBatch.getMassTransactionProcessType() == 5) {
            massTransactionBP = new MassImportBP(company, numberOfPeriods);
        } else if (transactionBatch.getMassTransactionProcessType() == 6) {
            massTransactionBP = new MassImportBP(company, numberOfPeriods);
        }
        return massTransactionBP;
    }

    public static TransactionBatch getCurrentMassTransactionBatch(DBData dbData, String companyId) throws Exception {
        if (Log.debug()) {
            Log.debug((String)companyId);
        }
        ExecutableQuery query = QueryFactory.create(TransactionBatch.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = BOAdapter.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        filter = BOAdapter.addFilterTerm(filter, "batchCode = ?_batchCode");
        parameters.put("_batchCode", new Integer(3));
        filter = BOAdapter.addFilterTerm(filter, "state = ?_state");
        parameters.put("_state", new Integer(0));
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        TransactionBatchManager manager = TransactionBatchManagerFactory.getInstance(dbData);
        return manager.getFirstObject(query);
    }

    protected static String retrieve(String key, String[][] selections) throws Exception {
        String result = "";
        for (int i = 0; i < selections.length; ++i) {
            if (!selections[i][0].equals(key)) continue;
            result = selections[i][1];
            break;
        }
        return result;
    }
}

