/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Collection;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.StandardDepreciationCalculator;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;

public class ProofDisInvestmentBP
extends GenericTransactionBP {
    private static final long serialVersionUID = -3835044327233624306L;
    private boolean isFirstPeriodDisinvestment;
    private boolean isPartialDisinvestment;
    private int[] previousFacYP;
    private BigDecimal[] proofDisinvestmentValues;
    private BigDecimal lastAcquisitionValue;
    private BigDecimal additionalDepreciationValue;
    private BigDecimal acquisitionBalanceAP1;
    private int[] correctionPeriods;

    public ProofDisInvestmentBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public void calculateProofDisInvestmentValues(Asset asset, int facYear, int facPeriod, BigDecimal yieldValue, BigDecimal disInvestmentValue) throws Exception {
        this.asset = asset;
        this.facYear = facYear;
        this.facPeriod = facPeriod;
        this.isPartialDisinvestment = false;
        if (disInvestmentValue.doubleValue() != 0.0) {
            this.isPartialDisinvestment = true;
        }
        this.isFirstPeriodDisinvestment = false;
        if (PeriodHelper.equals(facYear, facPeriod, asset.getStartUseYear(), asset.getStartUsePeriod())) {
            this.isFirstPeriodDisinvestment = true;
        } else {
            this.previousFacYP = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, facYear, facPeriod);
        }
        this.correctionPeriods = new int[3];
        this.proofDisinvestmentValues = new BigDecimal[5];
        this.proofDisinvestmentValues[0] = yieldValue;
        for (Valuation valuation : asset.getValuationsCollection(null)) {
            if (!this.isFirstPeriodDisinvestment && PeriodHelper.isAfter(this.previousFacYP[0], this.previousFacYP[1], valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod())) {
                this.calculateAdditionalDepreciations(valuation, this.previousFacYP);
            }
            int index = 1;
            if (valuation.getAccountingPrinciple() == 2) {
                index = 3;
            }
            BigDecimal acquisitionBalance = new BigDecimal("0");
            BigDecimal depreciatedBalance = new BigDecimal("0");
            if (this.isFirstPeriodDisinvestment) {
                Transaction transaction = (Transaction)TransactionBO.get(this.company.getDBData(), this.company.getId(), valuation.getDocumentNr1stTransaction(), valuation.getSeqNr1stTransaction())[0];
                if (transaction != null) {
                    acquisitionBalance = transaction.getAmount1();
                    depreciatedBalance = transaction.getAmount2();
                    this.correctionPeriods[valuation.getAccountingPrinciple()] = valuation.getNumberOfDepreciatedPeriods() * -1;
                }
            } else {
                BigDecimal[] balanceValues = TransactionBO.calculateAcquisitionValue(asset, valuation.getAccountingPrinciple(), this.previousFacYP[0], this.previousFacYP[1]);
                acquisitionBalance = balanceValues[0];
                depreciatedBalance = balanceValues[1].add(TransactionBO.calculateDepreciatedTotal(asset, valuation.getAccountingPrinciple(), this.previousFacYP[0], this.previousFacYP[1])[0]);
                if (PeriodHelper.isBefore(this.previousFacYP[0], this.previousFacYP[1], valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod())) {
                    this.calculateCorrectionPeriods(valuation, this.previousFacYP);
                }
            }
            if (this.lastAcquisitionValue != null) {
                acquisitionBalance = this.lastAcquisitionValue;
                depreciatedBalance = depreciatedBalance.add(this.additionalDepreciationValue);
            }
            if (this.isPartialDisinvestment) {
                if (asset.getAssetType().getUseDifferentAcquisitionValues()) {
                    if (valuation.getAccountingPrinciple() == 1) {
                        this.acquisitionBalanceAP1 = acquisitionBalance;
                    }
                    if (valuation.getAccountingPrinciple() == 2) {
                        disInvestmentValue = disInvestmentValue.multiply(acquisitionBalance).divide(this.acquisitionBalanceAP1, 2, 4);
                    }
                }
                BigDecimal partialDepreciatedBalance = new BigDecimal("0");
                if (acquisitionBalance.doubleValue() != 0.0) {
                    partialDepreciatedBalance = depreciatedBalance.multiply(disInvestmentValue).divide(acquisitionBalance, 2, 4);
                }
                this.proofDisinvestmentValues[index] = disInvestmentValue.negate();
                this.proofDisinvestmentValues[index + 1] = partialDepreciatedBalance.negate();
                continue;
            }
            this.proofDisinvestmentValues[index] = acquisitionBalance.negate();
            this.proofDisinvestmentValues[index + 1] = depreciatedBalance.negate();
        }
    }

    private void calculateAdditionalDepreciations(Valuation valuation, int[] previousFacYP) throws Exception {
        this.lastAcquisitionValue = null;
        this.additionalDepreciationValue = new BigDecimal("0");
        StandardDepreciationCalculator calculator = new StandardDepreciationCalculator(this.processParameters.getFullInterestIn1stPeriod());
        Collection calculationValues = calculator.calculate(this.company.getDBData(), this.company, this.numberOfPeriods, false, previousFacYP[0], previousFacYP[1], valuation, null);
        if (!calculationValues.isEmpty()) {
            for (CalculationValue calculationValue : calculationValues) {
                if (calculationValue.getAcquisitionValue() != null) {
                    this.lastAcquisitionValue = calculationValue.getAcquisitionValue();
                }
                if (calculationValue.getDepreciationAmount() == null || calculationValue.isDepreciationBeyondEconomicLife()) continue;
                this.additionalDepreciationValue = this.additionalDepreciationValue.add(calculationValue.getDepreciationAmount());
                if (calculationValue.getDepreciationAmount().doubleValue() == 0.0 && calculationValue.getReasonCode() != 21) continue;
                int n = valuation.getAccountingPrinciple();
                this.correctionPeriods[n] = this.correctionPeriods[n] + 1;
            }
        }
    }

    private void calculateCorrectionPeriods(Valuation valuation, int[] previousFacYP) throws Exception {
        Collection transactions = TransactionBO.getAfterOrEquals(this.asset, this.facYear, this.facPeriod, valuation.getAccountingPrinciple());
        for (Transaction transaction : transactions) {
            if (transaction.getMainTransactionType() != 3 || transaction.getRevCode() > 0 || transaction.getTransactionType() != 70) continue;
            if (transaction.getAmount2().doubleValue() != 0.0 || transaction.getReasonCode() == 21) {
                int n = valuation.getAccountingPrinciple();
                this.correctionPeriods[n] = this.correctionPeriods[n] - 1;
                continue;
            }
            if (transaction.getTransactionType() != 71 && transaction.getTransactionType() != 72) continue;
            int n = valuation.getAccountingPrinciple();
            this.correctionPeriods[n] = this.correctionPeriods[n] - 1;
        }
    }

    public BigDecimal[] getProofDisInvestmentValues() throws Exception {
        return this.proofDisinvestmentValues;
    }

    public int[] getCorrectionPeriods() throws Exception {
        return this.correctionPeriods;
    }

    public int[] retrieveDisinvestmentPeriod() throws Exception {
        int[] yp = new int[]{this.facYear, this.facPeriod};
        return yp;
    }
}

