/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Vector;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class ValuationCorrectionBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 8617051945075791788L;
    private String originalDescription;
    private String description;
    private String description2;
    private Collection[] transactionsToBeReversed = new Collection[2];
    private int batchId;
    private Vector periodsToSkip;
    private int numberOfPeriodsToSubtract;

    public ValuationCorrectionBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public String[] retrieveYearsAndPeriods(Valuation valuation) throws Exception {
        String[] yps = new String[4];
        if (this.company.getLastDepreciationRunYear() != 0) {
            int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
            yps[0] = "" + nextPeriod[0];
            yps[1] = "" + nextPeriod[1];
        } else if (valuation.getStartDepreciationBookYear() != 0) {
            yps[0] = "" + valuation.getStartDepreciationBookYear();
            yps[1] = "" + valuation.getStartDepreciationPeriod();
        } else {
            yps[0] = "" + this.asset.getStartUseYear();
            yps[1] = "" + this.asset.getStartUsePeriod();
        }
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    public String[] validateFACYearAndPeriod(Valuation valuation, int facYear, int facPeriod) throws Exception {
        int status;
        int thePeriod;
        String[] messages = new String[2];
        int index = 0;
        int theYear = valuation.getStartDepreciationBookYear();
        if (PeriodHelper.isBefore(facYear, facPeriod, theYear, thePeriod = valuation.getStartDepreciationPeriod())) {
            messages[index] = "FACPeriodBeforeStartDepreciationPeriod";
            return messages;
        }
        if (valuation.getLastDepreciationBookYear() == 0) {
            if (PeriodHelper.isAfter(facYear, facPeriod, theYear, thePeriod)) {
                messages[index] = "FACPeriodAfterCurrentPeriod";
                return messages;
            }
        } else {
            int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod());
            theYear = nextPeriod[0];
            if (PeriodHelper.isAfter(facYear, facPeriod, theYear, thePeriod = nextPeriod[1])) {
                messages[index] = "FACPeriodAfterCurrentPeriod";
                return messages;
            }
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateResidualValue(Asset asset, Valuation valuation, BigDecimal residualValue, int facYear, int facPeriod, BigDecimal residualPercentage) throws Exception {
        String[] messages = new String[1];
        int index = 0;
        BigDecimal acquisitionTotal = PeriodHelper.isAfter(valuation.getLastAcquisitionBookYear(), valuation.getLastAcquisitionPeriod(), facYear, facPeriod) ? TransactionBO.calculateAcquisitionValue(asset, valuation.getAccountingPrinciple(), facYear, facPeriod)[0] : valuation.getPostedAcquisitionBalance();
        if (residualValue == null) {
            residualValue = acquisitionTotal.multiply(residualPercentage.divide(new BigDecimal("100"), 2, 4));
        }
        BigDecimal bookValue = acquisitionTotal.subtract(valuation.getPostedDepreciationBalance());
        if (!asset.getNegativeInvestment()) {
            if (residualValue.doubleValue() > bookValue.doubleValue()) {
                messages[0] = "ResidualValueGreaterThanBookValue";
                ++index;
            }
        } else if (residualValue.doubleValue() < bookValue.doubleValue()) {
            messages[0] = "ResidualValueLessThanBookValue";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String investigateTransactionsToBeReversed(Asset asset, int facYear, int facPeriod, Valuation valuation, int index) throws Exception {
        String message = null;
        this.transactionsToBeReversed[index] = TransactionBO.getAfterOrEquals(asset, facYear, facPeriod, valuation.getAccountingPrinciple());
        for (Transaction transactionToBeReversed : this.transactionsToBeReversed[index]) {
            if (transactionToBeReversed.getRevCode() > 0) continue;
            int transactionType = transactionToBeReversed.getTransactionType();
            if (transactionType == 130) {
                message = "ChangeNotAllowedBeforePartialDisinvestment";
                return message;
            }
            if (transactionType != 90 || transactionToBeReversed.getAmount2().doubleValue() == 0.0) continue;
            message = "ChangeNotAllowedBeforeExtraDepreciationInterest";
            return message;
        }
        return message;
    }

    public String updateValuations(Asset asset, Valuation[] valuations, int[] facYears, int[] facPeriods, int[] finYears, int[] finPeriods, boolean[] changeValuations, int[] depreciatableLifes, BigDecimal[] residualPercentages, BigDecimal[] residualValues, String description, int[] descriptionHelpers, String user, int batchId, int documentNr) throws Exception {
        String message = null;
        for (int i = 0; i < 2; ++i) {
            if (valuations[i] == null || !changeValuations[i] || (message = this.investigateTransactionsToBeReversed(asset, facYears[i], facPeriods[i], valuations[i], i)) == null) continue;
            return message;
        }
        this.originalDescription = description;
        this.asset = asset;
        this.user = user;
        this.documentNr = documentNr;
        this.seqNr = 0;
        this.post = true;
        this.batchId = batchId;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            for (int i = 0; i < 2 && valuations[i] != null; ++i) {
                if (!changeValuations[i]) continue;
                this.description = this.originalDescription == null || this.originalDescription.trim().length() == 0 ? (descriptionHelpers[i] == 1 ? LanguageHelper.getString("nl.ibs.fac.language", "ChangedDepreciationLife") : (descriptionHelpers[i] == 2 ? LanguageHelper.getString("nl.ibs.fac.language", "ChangedResidualValue") : LanguageHelper.getString("nl.ibs.fac.language", "ChangedMiscellaneous"))) : this.originalDescription;
                message = this.updateValuation(valuations[i], facYears[i], facPeriods[i], finYears[i], finPeriods[i], depreciatableLifes[i], residualPercentages[i], residualValues[i], i);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    public String updateValuation(Asset asset, Valuation valuation, int facYear, int facPeriod, int finYear, int finPeriod, int depreciatableLife, BigDecimal residualPercentage, BigDecimal residualValue, String description, String user, int batchId, int documentNr) throws Exception {
        String message = null;
        this.description = description;
        this.asset = asset;
        this.user = user;
        this.documentNr = documentNr;
        this.seqNr = 0;
        this.post = true;
        this.batchId = batchId;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            this.transactionsToBeReversed[0] = TransactionBO.getAfterOrEquals(asset, facYear, facPeriod, valuation.getAccountingPrinciple());
            message = this.updateValuation(valuation, facYear, facPeriod, finYear, finPeriod, depreciatableLife, residualPercentage, residualValue, 0);
            if (message != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    public String updateValuation(Valuation valuation, int facYear, int facPeriod, int finYear, int finPeriod, int depreciatableLife, BigDecimal residualPercentage, BigDecimal residualValue, int index) throws Exception {
        int[] yearPeriod = new int[]{valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod()};
        if (PeriodHelper.isAfter(facYear, facPeriod, yearPeriod[0], yearPeriod[1])) {
            String message = this.createAnonymousTransaction(valuation, depreciatableLife, residualPercentage, residualValue, facYear, facPeriod, finYear, finPeriod);
            return message;
        }
        String message = this.createAnonymousTransaction(valuation, depreciatableLife, residualPercentage, residualValue, facYear, facPeriod, finYear, finPeriod);
        if (message != null) {
            return message;
        }
        this.finYear = finYear;
        this.finPeriod = finPeriod;
        this.description2 = TransactionTypeEnum.getValue(60) + " " + facYear + "/" + facPeriod;
        message = this.reverseFutureTransactions(valuation, this.transactionsToBeReversed[index]);
        if (message != null) {
            return message;
        }
        int[] previousFacYP = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, facYear, facPeriod);
        if (PeriodHelper.isBefore(previousFacYP[0], previousFacYP[1], valuation.getStartDepreciationBookYear(), valuation.getStartDepreciationPeriod())) {
            valuation.setLastDepreciationBookYear(0);
            valuation.setLastDepreciationPeriod(0);
        } else {
            valuation.setLastDepreciationBookYear(previousFacYP[0]);
            valuation.setLastDepreciationPeriod(previousFacYP[1]);
        }
        valuation.setNumberOfDepreciatedPeriods(valuation.getNumberOfDepreciatedPeriods() - this.numberOfPeriodsToSubtract);
        if (this.use445Correction) {
            valuation.setCorrectionAmount445A(new BigDecimal("0.00"));
            valuation.setCorrectionAmount445B(new BigDecimal("0.00"));
        }
        if ((message = this.createAdditionalDepreciationTransactions(valuation, yearPeriod, this.description2, this.batchId, null, this.periodsToSkip)) != null) {
            return message;
        }
        return message;
    }

    private String createAnonymousTransaction(Valuation valuation, int depreciatableLife, BigDecimal residualPercentage, BigDecimal residualValue, int facYear, int facPeriod, int finYear, int finPeriod) throws Exception {
        String message = null;
        if (finYear == 0) {
            this.finBookYear = facYear;
            this.finBookPeriod = facPeriod;
        } else {
            this.finBookYear = finYear;
            this.finBookPeriod = finPeriod;
        }
        this.retrieveFinancialDimensions(facYear, facPeriod);
        int accountingPrinciple = valuation.getAccountingPrinciple();
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.description, this.asset.getCora(), this.asset.getId(), accountingPrinciple, 9, 60, facYear, facPeriod, this.finBookYear, this.finBookPeriod, new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(accountingPrinciple, 9), 0, this.batchId, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
        } else {
            Transaction anonymousTransaction = (Transaction)objects[0];
            if (this.documentNr == 0) {
                this.documentNr = anonymousTransaction.getDocumentNr();
            }
            anonymousTransaction.setState(1);
            anonymousTransaction.setDaybookId("" + valuation.getDepreciatableLife());
            anonymousTransaction.setVoucherId("" + depreciatableLife);
            anonymousTransaction.setMainAccount1("" + valuation.getResidualPercentage().multiply(new BigDecimal("100")).intValue());
            anonymousTransaction.setMainAccount2("" + residualPercentage.multiply(new BigDecimal("100")).intValue());
            anonymousTransaction.setMainAccount3("" + valuation.getResidualValue().multiply(new BigDecimal("100")).intValue());
            anonymousTransaction.setMainAccount4("" + residualValue.multiply(new BigDecimal("100")).intValue());
            valuation.setDepreciatableLife(depreciatableLife);
            valuation.setResidualPercentage(residualPercentage);
            valuation.setResidualValue(residualValue);
        }
        return message;
    }

    private String reverseFutureTransactions(Valuation valuation, Collection ttbr) throws Exception {
        this.periodsToSkip = new Vector();
        this.numberOfPeriodsToSubtract = 0;
        String message = null;
        for (Transaction transactionToBeReversed : ttbr) {
            if (transactionToBeReversed.getRevCode() > 0) continue;
            if (transactionToBeReversed.getMainTransactionType() == 9) {
                if (transactionToBeReversed.getTransactionType() != 60) continue;
                transactionToBeReversed.setInfoLevel(1);
                continue;
            }
            if (transactionToBeReversed.getMainTransactionType() != 3) continue;
            if (transactionToBeReversed.getTransactionType() == 71 || transactionToBeReversed.getTransactionType() == 72) {
                this.periodsToSkip.add("" + (transactionToBeReversed.getBookYear() * 100 + transactionToBeReversed.getPeriod()));
                continue;
            }
            ++this.numberOfPeriodsToSubtract;
            Object[] objects = this.createReversingTransaction(transactionToBeReversed, this.description2, this.batchId);
            if (objects[1] != null) {
                message = (String)objects[1];
                return message;
            }
            if (!this.post) continue;
            Transaction reversingTransaction = (Transaction)objects[0];
            this.documentNr = reversingTransaction.getDocumentNr();
            ValuationCorrectionBP.updatePostedDepreciationBalance(this.asset, valuation, reversingTransaction, false);
            reversingTransaction.setState(1);
        }
        return message;
    }
}

