/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.commands;

import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.commands.DepreciationProposalPostCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.DepreciationProposalErrorsToPDF;
import nl.ibs.fac.reports.DepreciationProposalToCSV;
import nl.ibs.fac.reports.DepreciationProposalToPDF;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public abstract class DepreciationProposalCreateCommand {
    public static final String CLASSNAME = DepreciationProposalCreateCommand.class.getName();
    public static final String BOOKYEARTO = "BookYearTo";
    public static final String PERIODTO = "PeriodTo";
    public static final String FINYEAR = "finYear";
    public static final String FINPERIOD = "finPeriod";
    public static final String AP1 = "AP1";
    public static final String AP2 = "AP2";
    public static final String POST = "Post";
    public static final String PRINT = "Print";
    public static final String FILETYPE = "FileType";

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            String message = DepreciationProposalCreateCommand.execute(args);
            if (message != null) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static String execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String message = null;
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        Log.info((String)map.toString());
        DBData dbData = BOAdapter.getDBData(map);
        String companyId = (String)map.get("Company");
        TransactionBatch transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(dbData, companyId);
        if (transactionBatch == null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            Log.error((String)message);
            return message;
        }
        if (transactionBatch.getState() != 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "invalid_state");
            Log.error((String)message);
            return message;
        }
        String[] args2 = new String[args.length + 2];
        System.arraycopy(args, 0, args2, 0, args.length);
        args2[args.length] = "batchId";
        args2[args.length + 1] = "" + transactionBatch.getBatchId();
        args = args2;
        selections = BatchJobHelper.getSelections(args);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        String value = (String)map.get("governmentActivated");
        boolean governmentActivated = Boolean.valueOf(value);
        DepreciationProposalBP depreciationProposalBP = new DepreciationProposalBP(company, company.retrieveNumberOfPeriods(), governmentActivated);
        value = (String)map.get(AP1);
        boolean ap1 = Boolean.valueOf(value);
        value = (String)map.get(AP2);
        boolean ap2 = Boolean.valueOf(value);
        message = depreciationProposalBP.addDepreciationTransactions(transactionBatch, ap1, ap2, Integer.parseInt((String)map.get(BOOKYEARTO)), Integer.parseInt((String)map.get(PERIODTO)), (String)map.get("User"));
        if (message != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return message;
        }
        boolean hasSevereErrors = DepreciationProposalErrorsToPDF.execute(args, ap1, ap2);
        if (!hasSevereErrors) {
            boolean post;
            boolean print = Boolean.valueOf((String)map.get(PRINT));
            if (print) {
                String fileType = (String)map.get(FILETYPE);
                if (fileType.equals("PDF")) {
                    DepreciationProposalToPDF.execute(args);
                } else {
                    DepreciationProposalToCSV.execute(args);
                }
            }
            if (post = Boolean.valueOf((String)map.get(POST)).booleanValue()) {
                return DepreciationProposalPostCommand.execute(args);
            }
        }
        return message;
    }
}

