/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.commands;

import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.commands.TransactionBatchBookCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public abstract class DepreciationProposalPostCommand {
    public static final String CLASSNAME = DepreciationProposalPostCommand.class.getName();

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            String message = DepreciationProposalPostCommand.execute(args);
            if (message != null) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static String execute(String[] args) throws Exception {
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String message = null;
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        Log.info((String)map.toString());
        String companyId = (String)map.get("Company");
        DBData dbData = BOAdapter.getDBData(map);
        TransactionBatch transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(dbData, companyId);
        if (transactionBatch == null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            Log.error((String)message);
            return message;
        }
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        String value = (String)map.get("governmentActivated");
        boolean governmentActivated = Boolean.valueOf(value);
        message = new DepreciationProposalBP(company, company.retrieveNumberOfPeriods(), governmentActivated).postCurrentDepreciationBatch(transactionBatch);
        if (message != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return message;
        }
        if (!map.containsKey("batchId")) {
            String[] args2 = new String[args.length + 2];
            System.arraycopy(args, 0, args2, 0, args.length);
            args2[args.length] = "batchId";
            args2[args.length + 1] = "" + transactionBatch.getBatchId();
            args = args2;
        }
        return TransactionBatchBookCommand.execute(args);
    }
}

