/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.commands;

import java.util.Collection;
import java.util.Map;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.bp.TransactionBatchBookBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.util.Stopwatch;

public abstract class TransactionBatchBookCommand {
    public static final String CLASSNAME = TransactionBatchBookCommand.class.getName();
    public static final String REFRESHMAINACCOUNTS = "RefreshMainAccounts";

    public static void main(String[] args) {
        Stopwatch sw = null;
        if (Log.debug()) {
            sw = new Stopwatch();
            sw.start();
        }
        try {
            String message = TransactionBatchBookCommand.execute(args);
            if (message != null) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            Log.error((Exception)e);
            System.exit(-1);
        }
        if (sw != null) {
            Log.debug((String)("Elapsed time: " + sw.stop(1) + " seconds"));
        }
        System.exit(0);
    }

    public static String execute(String[] args) throws Exception {
        LoginHelper loginHelper;
        TransactionBatchBookBP transactionBatchBookBP;
        Object[] result;
        if (Log.debug() && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                Log.debug((String)args[i]);
            }
        }
        String message = null;
        String[][] selections = BatchJobHelper.getSelections(args);
        Map map = BatchJobHelper.getSelections(selections);
        Log.info((String)map.toString());
        DBData dbData = BOAdapter.getDBData(map);
        String companyId = (String)map.get("Company");
        int batchId = Integer.parseInt((String)map.get("batchId"));
        TransactionBatch transactionBatch = (TransactionBatch)TransactionBatchBO.get(dbData, companyId, batchId)[0];
        if (transactionBatch == null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "batch_not_found");
            Log.error((String)message);
            return message;
        }
        if (transactionBatch.getState() == 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "invalid_state");
            Log.error((String)message);
            return message;
        }
        Collection transactions = TransactionBO.getTransactions(transactionBatch);
        if (transactions.isEmpty()) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "batch_is_empty");
            Log.error((String)message);
            return message;
        }
        Company company = (Company)CompanyBO.get(transactionBatch.getDBData(), transactionBatch.getCompanyId())[0];
        boolean refreshMainAccounts = false;
        if (map.containsKey(REFRESHMAINACCOUNTS)) {
            refreshMainAccounts = Boolean.valueOf((String)map.get(REFRESHMAINACCOUNTS));
        }
        if ((message = (String)(result = (transactionBatchBookBP = new TransactionBatchBookBP(company, transactionBatch)).prepareForPost(transactions, loginHelper = BatchJobHelper.getLoginHelper(map), refreshMainAccounts))[1]) != null) {
            Log.error((String)message);
            return message;
        }
        if (!((Boolean)result[0]).booleanValue()) {
            return null;
        }
        transactionBatch = transactionBatchBookBP.getTransactionBatch();
        result = TransactionBatchBookBP.createSelections(transactionBatch, loginHelper, (String)map.get("operationArea"), (String)map.get("dataLib"), (String)map.get("programLib"), (String)map.get("BookYear"));
        message = loginHelper.login();
        if (message != null) {
            message = LanguageHelper.getString("nl.ibs.fac.language", message);
            Log.error((String)message);
            return message;
        }
        BatchJobHelper.submitRPG(loginHelper, (String)result[1], (String)result[1], (String)map.get("object_lib"), (String[][])result[0], null);
        loginHelper.logout();
        return message;
    }
}

