/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.conversion;

import java.util.Collection;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public abstract class FacDB0121 {
    public static void execute(DBData dbData) throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setFilter("state = 5");
        Collection assets = AssetManagerFactory.getInstance(dbData).getCollection(query);
        Log.debug((String)("number of assets: " + assets.size()));
        if (assets.size() == 0) {
            return;
        }
        Collection valuations = null;
        Collection transactions = null;
        for (Asset asset : assets) {
            valuations = asset.getValuationsCollection(null);
            for (Valuation valuation : valuations) {
                transactions = TransactionBO.getTransactions(valuation, true);
                if (transactions.size() == 0) continue;
                for (Transaction transaction : transactions) {
                    if (transaction.getTransactionType() != 50 || transaction.getMainTransactionType() != 2) continue;
                    transaction.setAmount3(transaction.getAmount2().subtract(transaction.getAmount1()));
                }
            }
        }
    }
}

