/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db;

import java.lang.reflect.Method;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.conversion.AddAndSetPeriode;
import nl.ibs.fac.conversion.ChangeSkin;
import nl.ibs.fac.conversion.FacDB0120;
import nl.ibs.fac.conversion.FacDB0121;
import nl.ibs.fac.conversion.FacDB0123;
import nl.ibs.fac.conversion.FacDB0132;
import nl.ibs.fac.conversion.FacDB201402;
import nl.ibs.fac.conversion.SetCCSID;
import nl.ibs.fac.db.PersistenceMetaDataSet;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;
import nl.ibs.jsql.sql.DBManager;
import nl.ibs.jsql.sql.PersistenceMetaData;

public class FacDBManager
extends DBManager {
    private static final String LATEST_DATA_VERSION = "2025.01.001";
    private static final String NEW_VERSION = "install_new_version";
    private PersistenceMetaData[] pmds = null;

    @Override
    public PersistenceMetaData[] getPersistenceMetaDataArray() {
        if (this.pmds == null) {
            this.pmds = PersistenceMetaDataSet.getArray();
            try {
                Class<?> c = Class.forName("nl.ibs.fac.db.IndividualPersistenceMetaDataArray");
                Method m = c.getMethod("getPMDS", null);
                PersistenceMetaData[] pmds2 = (PersistenceMetaData[])m.invoke(c, null);
                PersistenceMetaData[] allPmds = new PersistenceMetaData[this.pmds.length + pmds2.length];
                System.arraycopy(this.pmds, 0, allPmds, 0, this.pmds.length);
                System.arraycopy(pmds2, 0, allPmds, this.pmds.length, pmds2.length);
                this.pmds = allPmds;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pmds;
    }

    @Override
    protected boolean skipConversion(DBConnectionPool pool) throws Exception {
        String dataVersion = this.getDataBaseVersion(pool);
        Log.warn((String)"\n\n\n\n");
        Log.warn((String)"***********************************");
        Log.warn((String)"* D A T A B A S E - M A N A G E R *");
        Log.warn((String)"***********************************");
        Log.warn((String)("Current database version: " + dataVersion));
        Log.warn((String)"Required database version: 2025.01.001");
        Log.warn((String)"Current program version: 2025.01.001");
        return dataVersion != null && LATEST_DATA_VERSION.compareTo(dataVersion) <= 0;
    }

    @Override
    protected String getNewDataBaseVersion() {
        return LATEST_DATA_VERSION;
    }

    private String getDataBaseVersion(DBConnectionPool pool) throws Exception {
        String version;
        DBConnection con = pool.getConnection();
        try {
            version = this.getCurrentDataBaseVersion();
            if (version != null && !version.toLowerCase().equals("null") && LATEST_DATA_VERSION.compareTo(version) < 0) {
                throw new Exception(LanguageHelper.getString("nl.ibs.fac.language", NEW_VERSION));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            pool.returnConnection(con);
        }
        return version;
    }

    @Override
    protected void preConvert(DBConnectionPool pool) throws Exception {
        String dataVersion = this.getDataBaseVersion(pool);
        if (dataVersion == null) {
            return;
        }
        if (dataVersion.compareTo("2019.01") < 0) {
            AddAndSetPeriode.execute(pool.getDBData());
        }
    }

    @Override
    protected void postConvert(DBConnectionPool pool) throws Exception {
        String dataVersion = this.getDataBaseVersion(pool);
        if (dataVersion == null) {
            return;
        }
        if (dataVersion.compareTo("2014.02") < 0) {
            SetCCSID.execute(pool.getDBData());
        }
    }

    @Override
    protected void finalize(DBConnectionPool pool) throws Exception {
        pool.disconnectAll();
        LoginHelper loginHelper = new LoginHelper(StartStopServlet.getSystem(), StartStopServlet.getDatabaseUser(), StartStopServlet.getDatabasePassword(), StartStopServlet.getLibrary());
        String message = loginHelper.login();
        if (message != null) {
            Log.error((String)message);
            return;
        }
        String command = "GRTOBJAUT OBJ(" + pool.getSchema() + ") OBJTYPE(*LIB) USER(*PUBLIC) AUT(*USE)";
        Log.info((String)command);
        Log.info((String)BatchJobHelper.runCommand(loginHelper, command)[0]);
        command = "GRTOBJAUT OBJ(" + pool.getSchema() + "/*ALL) OBJTYPE(*ALL) USER(*PUBLIC) AUT(*CHANGE)";
        Log.info((String)command);
        Log.info((String)BatchJobHelper.runCommand(loginHelper, command)[0]);
        command = "CHGJRN JRN(" + pool.getSchema() + "/QSQJRN) MNGRCV(*SYSTEM) DLTRCV(*YES)";
        Log.info((String)command);
        Log.info((String)BatchJobHelper.runCommand(loginHelper, command)[0]);
        command = "ADDRPYLE SEQNR(999) MSGID(CPA32B2) RPY(\u2018I\u2019) ";
        Log.info((String)command);
        Log.info((String)BatchJobHelper.runCommand(loginHelper, command)[0]);
        String dataVersion = this.getDataBaseVersion(pool);
        if (dataVersion == null) {
            return;
        }
        if (dataVersion.compareTo("01.20") < 0) {
            FacDB0120.execute(pool.getDBData());
        }
        if (dataVersion.compareTo("01.21") < 0) {
            FacDB0121.execute(pool.getDBData());
            command = "CALL PGM(" + BatchJobHelper.getObjectLibrary(loginHelper)[0] + "/FDB0121CL) PARM(" + BatchJobHelper.getObjectLibrary(loginHelper)[0] + " " + pool.getSchema() + ")";
            BatchJobHelper.runCommand(loginHelper, command);
        }
        if (dataVersion.compareTo("01.23") < 0) {
            FacDB0123.execute(pool.getDBData());
        }
        if (dataVersion.compareTo("01.31") < 0) {
            ChangeSkin.execute(pool.getDBData());
        }
        if (dataVersion.compareTo("01.32") < 0) {
            FacDB0132.execute(pool.getDBData());
        }
        if (dataVersion.compareTo("2014.02") < 0) {
            FacDB201402.execute(pool.getDBData());
        }
        loginHelper.logout();
    }
}

