/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.ListIterator;
import nl.ibs.fac.db.AnalysisCodeManagerFactory;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AnalysisGroupDataBean;
import nl.ibs.fac.db.AnalysisGroupManager;
import nl.ibs.fac.db.AnalysisGroupPK;
import nl.ibs.fac.db.impl.AnalysisGroup_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataAnalysisGroup;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.Cache;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.RemoveException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.ListIteratorImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.QueryTranslator;
import nl.ibs.vegas.ExecutableQuery;
import nl.ibs.vegas.meta.AttributeMeta;
import nl.ibs.vegas.meta.impl.CollectionRelationMetaImpl;
import nl.ibs.vegas.meta.impl.FieldMetaImpl;
import nl.ibs.vegas.persistence.Manager;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnalysisGroupManager_Impl
extends BusinessObjectManager
implements AnalysisGroupManager {
    private static final String APPLICATION = "fac";
    private static DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    private static AttributeAccessor generalAccessor = new AttributeAccessor();
    private static boolean verbose = Log.debug();
    private static PersistenceMetaData pmd = PersistenceMetaDataAnalysisGroup.getInstance();
    private static Hashtable instances = new Hashtable();
    private DBData dbd;
    static final String[] keys = new String[]{"companyId", "seqNr"};
    static final AttributeMeta[] attributes = new AttributeMeta[]{new FieldMetaImpl("companyId", "txt-company-id", "txt-company-id-short", "txt-company-id-description", "text", String.class, 7, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("seqNr", "txt-seq-nr", "txt-seq-nr-short", "txt-seq-nr-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("usage", "txt-usage", "txt-usage-short", "txt-usage-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("notUsed", "txt-not-used", "txt-not-used-short", "txt-not-used-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("name", "txt-name", "txt-name-short", "txt-name-description", "text", String.class, 35, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("shortName", "txt-short-name", "txt-short-name-short", "txt-short-name-description", "text", String.class, 15, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("type", "txt-type", "txt-type-short", "txt-type-description", "text", String.class, 1, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("length", "txt-length", "txt-length-short", "txt-length-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("decimals", "txt-decimals", "txt-decimals-short", "txt-decimals-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("autoNumber", "txt-auto-number", "txt-auto-number-short", "txt-auto-number-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("startValue", "txt-start-value", "txt-start-value-short", "txt-start-value-description", "number", Integer.TYPE, 9, 0, "0", "false", "false", "", "", false, false, null, null), new CollectionRelationMetaImpl("codes", "txt-codes", "txt-codes-short", "txt-codes-description", (Manager)AnalysisCodeManagerFactory.getInstance(), true)};

    private AnalysisGroupManager_Impl(DBData dbData) {
        this.dbd = dbData;
    }

    public static AnalysisGroupManager getInstance() {
        return AnalysisGroupManager_Impl.getInstance(DBData.getDefaultDBData(APPLICATION));
    }

    public static AnalysisGroupManager getInstance(DBData dbd) {
        if (dbd == null) {
            throw new IllegalArgumentException("Tried to instantiate a Manager it DBData = null!");
        }
        AnalysisGroupManager_Impl inst = (AnalysisGroupManager_Impl)instances.get(dbd);
        if (inst == null) {
            inst = new AnalysisGroupManager_Impl(dbd);
            instances.put(dbd, inst);
        }
        return inst;
    }

    public DBData getDBData() {
        return this.dbd;
    }

    @Override
    public AnalysisGroup create(AnalysisGroupDataBean bean) throws Exception {
        AnalysisGroup_Impl impl = new AnalysisGroup_Impl(this.dbd, bean);
        impl.assureStorage();
        return impl;
    }

    @Override
    public AnalysisGroup create(String _companyId, int _seqNr) throws Exception {
        AnalysisGroup_Impl obj = new AnalysisGroup_Impl(this.dbd, _companyId, _seqNr);
        obj.assureStorage();
        return obj;
    }

    private AnalysisGroupPK getPK(ResultSet rs) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        AnalysisGroupPK inst = new AnalysisGroupPK();
        inst.setCompanyId(rs.getString(pmd.getFieldName("CompanyId", provider)));
        inst.setSeqNr(rs.getInt(pmd.getFieldName("SeqNr", provider)));
        return inst;
    }

    @Override
    public AnalysisGroup findOrCreate(AnalysisGroupPK key) throws Exception {
        AnalysisGroup obj;
        try {
            obj = this.findByPrimaryKey(key);
        }
        catch (FinderException e) {
            obj = this.create(key.getCompanyId(), key.getSeqNr());
        }
        return obj;
    }

    @Override
    public void add(AnalysisGroupDataBean inst) throws Exception {
        AnalysisGroup_Impl impl = new AnalysisGroup_Impl(this.dbd, inst);
        impl.assureStorage();
    }

    @Override
    public void removeByPrimaryKey(AnalysisGroupPK key) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        AnalysisGroup cachedObject = this.getCachedObjectByPrimaryKey(key);
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate((BusinessObject_Impl)((Object)cachedObject)) : provider.getConnection();
        String pskey = "nl.ibs.fac.db.AnalysisGroup.removeByPrimaryKey";
        try {
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? AND " + pmd.getFieldName("SeqNr", provider) + "=?");
            }
            prep.setString(1, key.getCompanyId());
            prep.setInt(2, key.getSeqNr());
            int x = prep.executeUpdate();
            if (x == 0) {
                throw new RemoveException("Key not found");
            }
            if (cachedObject != null) {
                DBPersistenceManager.removeFromCache(cachedObject);
            }
        }
        catch (SQLException e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalysisGroup findByPrimaryKey(AnalysisGroupPK key) throws Exception {
        AnalysisGroup analysisGroup = this.getCachedObjectByPrimaryKey(key);
        if (analysisGroup != null) {
            return analysisGroup;
        }
        ResultSet rs = null;
        try {
            rs = this.getResultSet(key);
            AnalysisGroup analysisGroup2 = (AnalysisGroup)this.getBusinessObject(rs);
            return analysisGroup2;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public ResultSet getResultSet(AnalysisGroupPK key) throws Exception {
        ResultSet rs = null;
        String pskey = "nl.ibs.fac.db.AnalysisGroup.findByPrimaryKey1";
        Object inst = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " SELECT *  FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? AND " + pmd.getFieldName("SeqNr", provider) + "=?");
            }
            prep.setString(1, key.getCompanyId());
            prep.setInt(2, key.getSeqNr());
            prep.executeQuery();
            rs = prep.getResultSet();
            if (!rs.next()) {
                throw new FinderException("Key not found");
            }
        }
        catch (SQLException e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
        return rs;
    }

    public AnalysisGroup getCachedObjectByPrimaryKey(AnalysisGroupPK key) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache == null) {
            return null;
        }
        Object o = cache.get(new String("45488829_" + this.dbd.getDBId() + key.getCompanyId() + key.getSeqNr()));
        return (AnalysisGroup)o;
    }

    @Override
    public ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public int getSeqNrMax(String _companyId) throws Exception {
        ResultSet rs = null;
        int result = 0;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String pskey = "nl.ibs.fac.db.AnalysisGroup.getSeqNrMax_1737665094";
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " SELECT   MAX(" + pmd.getFieldName("SeqNr", provider) + ") FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? ", 0);
            }
            prep.setObject(1, (Object)_companyId, mapping.getJDBCTypeFor("String"));
            rs = prep.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
        return result;
    }

    @Override
    public int generalUpdate(String setClause, String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String update = "UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + QueryTranslator.translateObjectQuery(setClause + " WHERE " + whereClause, pmd, provider);
            int n = dbc.executeUpdate(update);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public int generalDelete(String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String delete = "DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + QueryTranslator.translateObjectQuery(whereClause, pmd, provider);
            int n = dbc.executeUpdate(delete);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public AnalysisGroup getFirstObject(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create();
        }
        int prevMax = query.getMaxObjects();
        query.setMaxObjects(1);
        try {
            AnalysisGroup analysisGroup = (AnalysisGroup)((QueryImplementation)query).execute(this, (short)0);
            return analysisGroup;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            query.setMaxObjects(prevMax);
        }
    }

    @Override
    public Collection getCollection(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Collection)queryImpl.execute(this, (short)-1);
    }

    public ListIterator getListIterator(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ListIterator)queryImpl.execute(this, (short)-2);
    }

    @Override
    public Document getDocument(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Document)queryImpl.execute(this, (short)-3);
    }

    @Override
    public DocumentFragment getDocumentFragment(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (DocumentFragment)queryImpl.execute(this, (short)-4);
    }

    @Override
    public ArrayList getDocumentFragmentArrayList(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ArrayList)queryImpl.execute(this, (short)-5);
    }

    @Override
    protected Collection getCollection(ResultSet rs) throws Exception {
        ArrayListImpl result = new ArrayListImpl();
        while (rs.next()) {
            ((ArrayList)result).add(this.getBusinessObject(rs));
        }
        return result;
    }

    @Override
    protected Document getDocument(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        Element root = document.getDocumentElement();
        this.collectResultElements(resultSet, root, this.getConnectionProvider());
        return document;
    }

    @Override
    protected DocumentFragment getDocumentFragment(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.collectResultElements(resultSet, documentFragment, this.getConnectionProvider());
        return documentFragment;
    }

    @Override
    protected ArrayList getDocumentFragmentArrayList(ResultSet resultSet) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        Document document = domImplementation.createDocument("", "data", null);
        ArrayListImpl arrayList = new ArrayListImpl();
        while (resultSet.next()) {
            DocumentFragment documentFragment = document.createDocumentFragment();
            Node rec = documentFragment.appendChild(document.createElement("analysisgroup"));
            AnalysisGroupManager_Impl.addBOFieldsToElement(resultSet, rec, provider);
            ((ArrayList)arrayList).add(documentFragment);
        }
        return arrayList;
    }

    @Override
    protected ListIterator getListIterator(ResultSet rs) throws Exception {
        ListIteratorImpl result = new ListIteratorImpl();
        while (rs.next()) {
            result.add(this.getBusinessObject(rs));
        }
        result.pointer = 0;
        return result;
    }

    @Override
    protected Object getBusinessObject(ResultSet rs) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache != null) {
            ConnectionProvider provider = this.getConnectionProvider();
            Object o = cache.get(new String("45488829_" + this.dbd.getDBId() + rs.getObject(pmd.getFieldName("CompanyId", provider)) + rs.getObject(pmd.getFieldName("SeqNr", provider))));
            if (o != null) {
                return o;
            }
        }
        return DBPersistenceManager.cache(this.createBusinessObject(rs));
    }

    private Object createBusinessObject(ResultSet rs) throws Exception {
        return new AnalysisGroup_Impl(this.dbd, rs);
    }

    private void collectResultElements(ResultSet rs, Node root, ConnectionProvider provider) throws Exception {
        Document doc = root.getOwnerDocument();
        while (rs.next()) {
            Node rec = root.appendChild(doc.createElement("analysisgroup"));
            AnalysisGroupManager_Impl.addBOFieldsToElement(rs, rec, provider);
        }
    }

    public static void addBOFieldsToElement(ResultSet rs, Node rec, ConnectionProvider provider) throws Exception {
        DBMapping mapping = provider.getDBMapping();
        Document doc = rec.getOwnerDocument();
        Object o = null;
        String s = null;
        s = rs.getString(pmd.getFieldName("CompanyId", provider));
        if (s != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("companyid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("SeqNr", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("seqnr")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("Usage", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("usage")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("NotUsed", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("notused")).appendChild(doc.createTextNode(s));
        }
        if ((s = rs.getString(pmd.getFieldName("Name", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("name")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("ShortName", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("shortname")).appendChild(doc.createCDATASection(s));
        }
        if ((s = rs.getString(pmd.getFieldName("Type", provider))) != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("type")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("Length", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("length")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("Decimals", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("decimals")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("AutoNumber", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("autonumber")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("StartValue", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("startvalue")).appendChild(doc.createTextNode(s));
        }
    }

    public ExecutableQuery getExecutableQuery() {
        return QueryFactory.create(this);
    }

    public String[] getKeyNames() {
        return keys;
    }

    public AttributeMeta[] getAttributes() {
        return attributes;
    }

    public Class getClassType() {
        return AnalysisGroup.class;
    }

    public String getNameField() {
        return "seqNr";
    }

    public String getDescriptionField() {
        return "seqNr";
    }

    public String getTextKey() {
        return "txt-analysis-group";
    }

    public String getTextKeyShort() {
        return "txt-analysis-group-short";
    }

    public String getTextKeyDescription() {
        return "txt-analysis-group-description";
    }

    public AttributeMeta getAttribute(String name) {
        if (attributes == null || name == null) {
            return null;
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (!name.equals(attributes[i].getName())) continue;
            return attributes[i];
        }
        return null;
    }
}

