/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.fac.db.ApplicationSetting;
import nl.ibs.fac.db.ApplicationSettingDataBean;
import nl.ibs.fac.db.impl.ApplicationSettingManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataApplicationSetting;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;

public class ApplicationSetting_Impl
implements ApplicationSetting,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataApplicationSetting.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String name;
    protected String value;

    protected ApplicationSetting_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected ApplicationSetting_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    protected ApplicationSetting_Impl(DBData _dbd, String _name) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setName(_name);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected ApplicationSetting_Impl(DBData _dbd, ApplicationSettingDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.ApplicationSettingDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate ApplicationSetting with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.ApplicationSettingDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setName(bean.getName());
            this.setValue(bean.getValue());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public ApplicationSetting_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.name = rs.getString(pmd.getFieldName("name", provider));
        this.value = rs.getString(pmd.getFieldName("value", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        return this.getName();
    }

    @Override
    public String getName() throws Exception {
        this.assureStorage();
        return this.name;
    }

    @Override
    public String getValue() throws Exception {
        return this.value;
    }

    public void setName(String _name) throws Exception {
        if (_name == null) {
            _name = "";
        }
        if (_name.equals(this.getName())) {
            return;
        }
        this.preSet();
        this.name = _name;
        this.autoUpdate();
    }

    @Override
    public void setValue(String _value) throws Exception {
        if (_value == null) {
            _value = "";
        }
        if (_value.equals(this.getValue())) {
            return;
        }
        this.preSet();
        this.value = _value;
        this.autoUpdate();
    }

    private void initializeTheImplementationClass() throws Exception {
        this.name = "";
        this.value = "";
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.name = this.name;
        this.currentDBImage.value = this.value;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("ApplicationSetting is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            ((ApplicationSettingManager_Impl)ApplicationSettingManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(this.getName());
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            rs = ((ApplicationSettingManager_Impl)ApplicationSettingManager_Impl.getInstance(this.dbd)).getResultSet((String)this.getPrimaryKey());
            this.loadData(rs);
        }
        catch (FinderException e) {
            throw new DeletedException("Deleted by other user");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("1141550438_" + this.dbd.getDBId() + this.name).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public ApplicationSettingDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public ApplicationSettingDataBean getApplicationSettingDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private ApplicationSettingDataBean getDataBean(ApplicationSettingDataBean bean) throws Exception {
        if (bean == null) {
            bean = new ApplicationSettingDataBean();
        }
        bean.setName(this.getName());
        bean.setValue(this.getValue());
        return bean;
    }

    public boolean equals(Object object) {
        try {
            if (object == null || !(object instanceof ApplicationSetting_Impl)) {
                return false;
            }
            ApplicationSetting_Impl bo = (ApplicationSetting_Impl)object;
            if (bo.getName() == null ? this.getName() != null : !bo.getName().equals(this.getName())) {
                return false;
            }
            if (bo.getClass() != this.getClass()) {
                return false;
            }
            return bo.getDBId() == this.getDBId();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void update(ApplicationSettingDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(ApplicationSettingDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setName(bean.getName());
            this.setValue(bean.getValue());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "ApplicationSetting is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.ApplicationSetting.save");
        try {
            PreparedStatement prep = dbc.getPreparedStatement(key.toString());
            if (prep == null) {
                prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("name", provider) + " = ? , " + pmd.getFieldName("value", provider) + " = ?  WHERE " + pmd.getFieldName("name", provider) + " = ?  AND  " + pmd.getFieldName("value", provider) + " = ? ");
            }
            int parmIndex = 1;
            prep.setObject(parmIndex++, (Object)this.name, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)this.value, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)image.name, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)image.value, mapping.getJDBCTypeFor("String"));
            int n = prep.executeUpdate();
            if (n == 0) {
                this.rollback(true);
                throw new UpdateException("ApplicationSetting modified by other user!", this);
            }
            this.updateDBImage();
            this.dirty = false;
            this.stored = true;
            if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
            }
        }
        catch (Exception e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.ApplicationSetting.insert");
            if (prep == null) {
                prep = dbc.getPreparedStatement("nl.ibs.fac.db.ApplicationSetting.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("name", provider) + ", " + pmd.getFieldName("value", provider) + ") VALUES (?,?)");
            }
            prep.setObject(1, (Object)this.name, mapping.getJDBCTypeFor("String"));
            prep.setObject(2, (Object)this.value, mapping.getJDBCTypeFor("String"));
            prep.executeUpdate();
            this.updateDBImage();
            this.dirty = false;
            DBPersistenceManager.cache(this);
            if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
            }
        }
        catch (CreateException e) {
            this.stored = false;
            throw e;
        }
        catch (Exception e) {
            this.stored = false;
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.name = this.currentDBImage.name;
            this.transactionImage.dbImage.value = this.currentDBImage.value;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.name = this.transactionImage.dbImage.name;
        this.currentDBImage.value = this.transactionImage.dbImage.value;
        if (includeBOFields) {
            this.name = this.transactionImage.dbImage.name;
            this.value = this.transactionImage.dbImage.value;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            for (int x = 0; x < list.size(); ++x) {
                if (!((BusinessObject_Impl)list.get(x)).isDeleted()) continue;
                list.remove(x--);
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }

    private static final class DBImage
    implements Serializable {
        private String name;
        private String value;

        private DBImage() {
        }
    }
}

