/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import nl.ibs.fac.db.BookYear;
import nl.ibs.fac.db.BookYearDataBean;
import nl.ibs.fac.db.BookYearPK;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.impl.BookYearManager_Impl;
import nl.ibs.fac.db.impl.CompanyManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataBookYear;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;

public class BookYear_Impl
implements BookYear,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataBookYear.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String companyId;
    protected int bookYear;
    protected int periodTo;
    protected int periodFrom;
    protected int lastVoucherId;
    protected boolean aggregated;

    protected BookYear_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected BookYear_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BookYear_Impl(DBData _dbd, String _companyId, int _bookYear) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(_companyId);
            this.setBookYear(_bookYear);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected BookYear_Impl(DBData _dbd, BookYearDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.BookYearDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate BookYear with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.BookYearDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setCompanyId(bean.getCompanyId());
            this.setBookYear(bean.getBookYear());
            this.setPeriodTo(bean.getPeriodTo());
            this.setPeriodFrom(bean.getPeriodFrom());
            this.setLastVoucherId(bean.getLastVoucherId());
            this.setAggregated(bean.getAggregated());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public BookYear_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.companyId = rs.getString(pmd.getFieldName("CompanyId", provider));
        this.bookYear = rs.getInt(pmd.getFieldName("BookYear", provider));
        this.periodTo = rs.getInt(pmd.getFieldName("PeriodTo", provider));
        this.periodFrom = rs.getInt(pmd.getFieldName("PeriodFrom", provider));
        this.lastVoucherId = rs.getInt(pmd.getFieldName("lastVoucherId", provider));
        this.aggregated = rs.getBoolean(pmd.getFieldName("Aggregated", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        BookYearPK key = new BookYearPK();
        key.setCompanyId(this.getCompanyId());
        key.setBookYear(this.getBookYear());
        return key;
    }

    @Override
    public String getCompanyId() throws Exception {
        this.assureStorage();
        return this.companyId;
    }

    @Override
    public int getBookYear() throws Exception {
        this.assureStorage();
        return this.bookYear;
    }

    @Override
    public int getPeriodTo() throws Exception {
        return this.periodTo;
    }

    @Override
    public int getPeriodFrom() throws Exception {
        return this.periodFrom;
    }

    @Override
    public int getLastVoucherId() throws Exception {
        return this.lastVoucherId;
    }

    @Override
    public boolean getAggregated() throws Exception {
        return this.aggregated;
    }

    @Override
    public Company getOwnedByCompanyAsBookYears() throws Exception {
        if (this.isCachedRelation("ownedByCompanyAsBookYears")) {
            return (Company)this.getCachedRelationObject("ownedByCompanyAsBookYears");
        }
        if (this.getCompanyId() == null) {
            return null;
        }
        try {
            return (Company)this.addCachedRelationObject("ownedByCompanyAsBookYears", ((CompanyManager_Impl)CompanyManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getCompanyId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        Company owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByCompanyAsBookYears();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setCompanyId(String _companyId) throws Exception {
        if (_companyId == null) {
            _companyId = "";
        }
        if (_companyId.equals(this.getCompanyId())) {
            return;
        }
        this.preSet();
        this.companyId = _companyId;
        this.autoUpdate();
    }

    public void setBookYear(int _bookYear) throws Exception {
        if (_bookYear == this.getBookYear()) {
            return;
        }
        this.preSet();
        this.bookYear = _bookYear;
        this.autoUpdate();
    }

    @Override
    public void setPeriodTo(int _periodTo) throws Exception {
        if (_periodTo == this.getPeriodTo()) {
            return;
        }
        this.preSet();
        this.periodTo = _periodTo;
        this.autoUpdate();
    }

    @Override
    public void setPeriodFrom(int _periodFrom) throws Exception {
        if (_periodFrom == this.getPeriodFrom()) {
            return;
        }
        this.preSet();
        this.periodFrom = _periodFrom;
        this.autoUpdate();
    }

    @Override
    public void setLastVoucherId(int _lastVoucherId) throws Exception {
        if (_lastVoucherId == this.getLastVoucherId()) {
            return;
        }
        this.preSet();
        this.lastVoucherId = _lastVoucherId;
        this.autoUpdate();
    }

    @Override
    public void setAggregated(boolean _aggregated) throws Exception {
        if (_aggregated == this.getAggregated()) {
            return;
        }
        this.preSet();
        this.aggregated = _aggregated;
        this.autoUpdate();
    }

    private void initializeTheImplementationClass() throws Exception {
        this.companyId = "";
        this.bookYear = 0;
        this.periodTo = 0;
        this.periodFrom = 0;
        this.lastVoucherId = 0;
        this.aggregated = false;
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.companyId = this.companyId;
        this.currentDBImage.bookYear = this.bookYear;
        this.currentDBImage.periodTo = this.periodTo;
        this.currentDBImage.periodFrom = this.periodFrom;
        this.currentDBImage.lastVoucherId = this.lastVoucherId;
        this.currentDBImage.aggregated = this.aggregated;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("BookYear is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            BookYearPK key = new BookYearPK();
            key.setCompanyId(this.getCompanyId());
            key.setBookYear(this.getBookYear());
            ((BookYearManager_Impl)BookYearManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            rs = ((BookYearManager_Impl)BookYearManager_Impl.getInstance(this.dbd)).getResultSet((BookYearPK)this.getPrimaryKey());
            this.loadData(rs);
        }
        catch (FinderException e) {
            throw new DeletedException("Deleted by other user");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("-361328436_" + this.dbd.getDBId() + this.companyId + this.bookYear).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public BookYearDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public BookYearDataBean getBookYearDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private BookYearDataBean getDataBean(BookYearDataBean bean) throws Exception {
        if (bean == null) {
            bean = new BookYearDataBean();
        }
        bean.setCompanyId(this.getCompanyId());
        bean.setBookYear(this.getBookYear());
        bean.setPeriodTo(this.getPeriodTo());
        bean.setPeriodFrom(this.getPeriodFrom());
        bean.setLastVoucherId(this.getLastVoucherId());
        bean.setAggregated(this.getAggregated());
        return bean;
    }

    public boolean equals(Object object) {
        try {
            if (object == null || !(object instanceof BookYear_Impl)) {
                return false;
            }
            BookYear_Impl bo = (BookYear_Impl)object;
            if (bo.getCompanyId() == null ? this.getCompanyId() != null : !bo.getCompanyId().equals(this.getCompanyId())) {
                return false;
            }
            if (bo.getBookYear() != this.getBookYear()) {
                return false;
            }
            if (bo.getClass() != this.getClass()) {
                return false;
            }
            return bo.getDBId() == this.getDBId();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void update(BookYearDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(BookYearDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setCompanyId(bean.getCompanyId());
            this.setBookYear(bean.getBookYear());
            this.setPeriodTo(bean.getPeriodTo());
            this.setPeriodFrom(bean.getPeriodFrom());
            this.setLastVoucherId(bean.getLastVoucherId());
            this.setAggregated(bean.getAggregated());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "BookYear is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.BookYear.save");
        try {
            PreparedStatement prep = dbc.getPreparedStatement(key.toString());
            if (prep == null) {
                prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("CompanyId", provider) + " = ? , " + pmd.getFieldName("BookYear", provider) + " = ? , " + pmd.getFieldName("PeriodTo", provider) + " = ? , " + pmd.getFieldName("PeriodFrom", provider) + " = ? , " + pmd.getFieldName("lastVoucherId", provider) + " = ? , " + pmd.getFieldName("Aggregated", provider) + " = ?  WHERE " + pmd.getFieldName("CompanyId", provider) + " = ?  AND  " + pmd.getFieldName("BookYear", provider) + " = ?  AND  " + pmd.getFieldName("PeriodTo", provider) + " = ?  AND  " + pmd.getFieldName("PeriodFrom", provider) + " = ?  AND  " + pmd.getFieldName("lastVoucherId", provider) + " = ?  AND  " + pmd.getFieldName("Aggregated", provider) + " = ? ");
            }
            int parmIndex = 1;
            prep.setObject(parmIndex++, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Integer(this.bookYear), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)new Integer(this.periodTo), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)new Integer(this.periodFrom), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)new Integer(this.lastVoucherId), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)new Boolean(this.aggregated), mapping.getJDBCTypeFor("boolean"));
            prep.setObject(parmIndex++, (Object)image.companyId, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Integer(image.bookYear), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)new Integer(image.periodTo), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)new Integer(image.periodFrom), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)new Integer(image.lastVoucherId), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)new Boolean(image.aggregated), mapping.getJDBCTypeFor("boolean"));
            int n = prep.executeUpdate();
            if (n == 0) {
                this.rollback(true);
                throw new UpdateException("BookYear modified by other user!", this);
            }
            this.updateDBImage();
            this.dirty = false;
            this.stored = true;
            if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
            }
        }
        catch (Exception e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.BookYear.insert");
            if (prep == null) {
                prep = dbc.getPreparedStatement("nl.ibs.fac.db.BookYear.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("CompanyId", provider) + ", " + pmd.getFieldName("BookYear", provider) + ", " + pmd.getFieldName("PeriodTo", provider) + ", " + pmd.getFieldName("PeriodFrom", provider) + ", " + pmd.getFieldName("lastVoucherId", provider) + ", " + pmd.getFieldName("Aggregated", provider) + ") VALUES (?,?,?,?,?,?)");
            }
            prep.setObject(1, (Object)this.companyId, mapping.getJDBCTypeFor("String"));
            prep.setObject(2, (Object)new Integer(this.bookYear), mapping.getJDBCTypeFor("int"));
            prep.setObject(3, (Object)new Integer(this.periodTo), mapping.getJDBCTypeFor("int"));
            prep.setObject(4, (Object)new Integer(this.periodFrom), mapping.getJDBCTypeFor("int"));
            prep.setObject(5, (Object)new Integer(this.lastVoucherId), mapping.getJDBCTypeFor("int"));
            prep.setObject(6, (Object)new Boolean(this.aggregated), mapping.getJDBCTypeFor("boolean"));
            prep.executeUpdate();
            this.updateDBImage();
            this.dirty = false;
            DBPersistenceManager.cache(this);
            if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
            }
        }
        catch (CreateException e) {
            this.stored = false;
            throw e;
        }
        catch (Exception e) {
            this.stored = false;
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.companyId = this.currentDBImage.companyId;
            this.transactionImage.dbImage.bookYear = this.currentDBImage.bookYear;
            this.transactionImage.dbImage.periodTo = this.currentDBImage.periodTo;
            this.transactionImage.dbImage.periodFrom = this.currentDBImage.periodFrom;
            this.transactionImage.dbImage.lastVoucherId = this.currentDBImage.lastVoucherId;
            this.transactionImage.dbImage.aggregated = this.currentDBImage.aggregated;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.companyId = this.transactionImage.dbImage.companyId;
        this.currentDBImage.bookYear = this.transactionImage.dbImage.bookYear;
        this.currentDBImage.periodTo = this.transactionImage.dbImage.periodTo;
        this.currentDBImage.periodFrom = this.transactionImage.dbImage.periodFrom;
        this.currentDBImage.lastVoucherId = this.transactionImage.dbImage.lastVoucherId;
        this.currentDBImage.aggregated = this.transactionImage.dbImage.aggregated;
        if (includeBOFields) {
            this.companyId = this.transactionImage.dbImage.companyId;
            this.bookYear = this.transactionImage.dbImage.bookYear;
            this.periodTo = this.transactionImage.dbImage.periodTo;
            this.periodFrom = this.transactionImage.dbImage.periodFrom;
            this.lastVoucherId = this.transactionImage.dbImage.lastVoucherId;
            this.aggregated = this.transactionImage.dbImage.aggregated;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            for (int x = 0; x < list.size(); ++x) {
                if (!((BusinessObject_Impl)list.get(x)).isDeleted()) continue;
                list.remove(x--);
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }

    private static final class DBImage
    implements Serializable {
        private String companyId;
        private int bookYear;
        private int periodTo;
        private int periodFrom;
        private int lastVoucherId;
        private boolean aggregated;

        private DBImage() {
        }
    }
}

