/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.db.InterestBookYear;
import nl.ibs.fac.db.InterestBookYearDataBean;
import nl.ibs.fac.db.InterestBookYearPK;
import nl.ibs.fac.db.InterestPeriod;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.impl.InterestBookYearManager_Impl;
import nl.ibs.fac.db.impl.InterestPeriodManager_Impl;
import nl.ibs.fac.db.impl.InterestTableManager_Impl;
import nl.ibs.fac.db.impl.PersistenceMetaDataInterestBookYear;
import nl.ibs.fac.db.impl.PersistenceMetaDataInterestPeriod;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.CreateException;
import nl.ibs.jsql.exception.DeletedException;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.UpdateException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class InterestBookYear_Impl
implements InterestBookYear,
BusinessObject_Impl,
DBTransactionListener {
    private static final String APPLICATION = "fac";
    private static final PersistenceMetaData pmd = PersistenceMetaDataInterestBookYear.getInstance();
    private static final AttributeAccessor generalAccessor = new AttributeAccessor();
    protected static final boolean verbose = Log.debug();
    protected static final DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    protected static final boolean autoUpdate = true;
    protected static final boolean cacheRelations = DBConfig.getCacheObjectRelations();
    protected static final boolean deferUpdates = DBConfig.getDeferUpdates();
    protected boolean updateDefered;
    protected boolean holdUpdate;
    protected boolean dirty;
    protected boolean stored;
    protected boolean deleted;
    protected boolean underConstruction;
    protected boolean participatingInTransaction;
    protected int hashCode;
    protected transient HashMap relationalCache;
    private TransactionImage transactionImage;
    private DBImage currentDBImage;
    protected DBData dbd;
    protected String interestTableId;
    protected int bookYear;
    protected BigDecimal recalculationPercentage;

    protected InterestBookYear_Impl() throws Exception {
        this(DBData.getDefaultDBData(APPLICATION));
    }

    protected InterestBookYear_Impl(DBData _dbd) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InterestBookYear_Impl(DBData _dbd, String _interestTableId, int _bookYear) throws Exception {
        this.dbd = _dbd;
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setInterestTableId(_interestTableId);
            this.setBookYear(_bookYear);
        }
        finally {
            this.underConstruction = false;
        }
    }

    protected InterestBookYear_Impl(DBData _dbd, InterestBookYearDataBean bean) throws Exception {
        this.dbd = _dbd;
        if (!bean.getClass().getName().equals("nl.ibs.fac.db.InterestBookYearDataBean")) {
            throw new IllegalArgumentException("JSQL: Tried to instantiate InterestBookYear with " + bean.getClass().getName() + "!! Use nl.ibs.fac.db.InterestBookYearDataBean instead !");
        }
        this.initializeTheImplementationClass();
        try {
            this.underConstruction = true;
            this.setInterestTableId(bean.getInterestTableId());
            this.setBookYear(bean.getBookYear());
            this.setRecalculationPercentage(bean.getRecalculationPercentage());
        }
        finally {
            this.underConstruction = false;
        }
    }

    public InterestBookYear_Impl(DBData _dbd, ResultSet rs) throws Exception {
        this.dbd = _dbd;
        this.loadData(rs);
        this.stored = true;
    }

    public void loadData(ResultSet rs) throws Exception {
        this.initializeTheImplementationClass();
        ConnectionProvider provider = this.getConnectionProvider();
        this.interestTableId = rs.getString(pmd.getFieldName("InterestTableId", provider));
        this.bookYear = rs.getInt(pmd.getFieldName("BookYear", provider));
        this.recalculationPercentage = rs.getBigDecimal(pmd.getFieldName("RecalculationPercentage", provider));
        this.currentDBImage = null;
    }

    protected ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public Object getPrimaryKey() throws Exception {
        InterestBookYearPK key = new InterestBookYearPK();
        key.setInterestTableId(this.getInterestTableId());
        key.setBookYear(this.getBookYear());
        return key;
    }

    @Override
    public String getInterestTableId() throws Exception {
        this.assureStorage();
        return this.interestTableId;
    }

    @Override
    public int getBookYear() throws Exception {
        this.assureStorage();
        return this.bookYear;
    }

    @Override
    public BigDecimal getRecalculationPercentage() throws Exception {
        return this.recalculationPercentage;
    }

    @Override
    public InterestPeriod getInterestPeriodsObject(Query query) throws Exception {
        if (!this.stored) {
            return null;
        }
        String relationFilter = "interestTableId = ?interestTableId AND bookYear = ?bookYear";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("interestTableId", this.getInterestTableId());
        queryImpl.setParameter("bookYear", this.getBookYear());
        queryImpl.setRelationFilter("interestTableId = ?interestTableId AND bookYear = ?bookYear");
        return InterestPeriodManager_Impl.getInstance(this.dbd).getFirstObject(query);
    }

    @Override
    public Collection getInterestPeriodsCollection(Query query) throws Exception {
        boolean nullQuery;
        boolean bl = nullQuery = query == null;
        if (nullQuery && this.isCachedRelation("InterestPeriodsCollection")) {
            return (Collection)this.getCachedRelationObject("InterestPeriodsCollection");
        }
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "interestTableId = ?interestTableId AND bookYear = ?bookYear";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("interestTableId", this.getInterestTableId());
        queryImpl.setParameter("bookYear", this.getBookYear());
        queryImpl.setRelationFilter("interestTableId = ?interestTableId AND bookYear = ?bookYear");
        if (nullQuery) {
            return (Collection)this.addCachedRelationObject("InterestPeriodsCollection", InterestPeriodManager_Impl.getInstance(this.dbd).getCollection(query));
        }
        return InterestPeriodManager_Impl.getInstance(this.dbd).getCollection(query);
    }

    @Override
    public Document getInterestPeriodsDocument(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null);
        }
        String relationFilter = "interestTableId = ?interestTableId AND bookYear = ?bookYear";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("interestTableId", this.getInterestTableId());
        queryImpl.setParameter("bookYear", this.getBookYear());
        queryImpl.setRelationFilter("interestTableId = ?interestTableId AND bookYear = ?bookYear");
        return InterestPeriodManager_Impl.getInstance(this.dbd).getDocument(query);
    }

    @Override
    public DocumentFragment getInterestPeriodsDocumentFragment(Query query) throws Exception {
        if (!this.stored) {
            return domImplementation.createDocument("", "data", null).createDocumentFragment();
        }
        String relationFilter = "interestTableId = ?interestTableId AND bookYear = ?bookYear";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("interestTableId", this.getInterestTableId());
        queryImpl.setParameter("bookYear", this.getBookYear());
        queryImpl.setRelationFilter("interestTableId = ?interestTableId AND bookYear = ?bookYear");
        return InterestPeriodManager_Impl.getInstance(this.dbd).getDocumentFragment(query);
    }

    @Override
    public ArrayList getInterestPeriodsDocumentFragmentArrayList(Query query) throws Exception {
        if (!this.stored) {
            return new ArrayList();
        }
        String relationFilter = "interestTableId = ?interestTableId AND bookYear = ?bookYear";
        if (query == null) {
            query = QueryFactory.create();
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        queryImpl.setParameter("interestTableId", this.getInterestTableId());
        queryImpl.setParameter("bookYear", this.getBookYear());
        queryImpl.setRelationFilter("interestTableId = ?interestTableId AND bookYear = ?bookYear");
        return InterestPeriodManager_Impl.getInstance(this.dbd).getDocumentFragmentArrayList(query);
    }

    @Override
    public InterestTable getOwnedByInterestTableAsInterestBookYears() throws Exception {
        if (this.isCachedRelation("ownedByInterestTableAsInterestBookYears")) {
            return (InterestTable)this.getCachedRelationObject("ownedByInterestTableAsInterestBookYears");
        }
        if (this.getInterestTableId() == null) {
            return null;
        }
        try {
            return (InterestTable)this.addCachedRelationObject("ownedByInterestTableAsInterestBookYears", ((InterestTableManager_Impl)InterestTableManager_Impl.getInstance(this.dbd)).findByPrimaryKey(this.getInterestTableId()));
        }
        catch (FinderException fe) {
            return null;
        }
    }

    @Override
    public BusinessObject ownedByBusinessObject() throws Exception {
        InterestTable owningBusinessObject = null;
        owningBusinessObject = this.getOwnedByInterestTableAsInterestBookYears();
        if (owningBusinessObject != null) {
            return owningBusinessObject;
        }
        return owningBusinessObject;
    }

    public void setInterestTableId(String _interestTableId) throws Exception {
        if (_interestTableId == null) {
            _interestTableId = "";
        }
        if (_interestTableId.equals(this.getInterestTableId())) {
            return;
        }
        this.preSet();
        this.interestTableId = _interestTableId;
        this.autoUpdate();
    }

    public void setBookYear(int _bookYear) throws Exception {
        if (_bookYear == this.getBookYear()) {
            return;
        }
        this.preSet();
        this.bookYear = _bookYear;
        this.autoUpdate();
    }

    @Override
    public void setRecalculationPercentage(BigDecimal _recalculationPercentage) throws Exception {
        if (_recalculationPercentage == null) {
            _recalculationPercentage = new BigDecimal("0.000").setScale(3, 6);
        }
        if (_recalculationPercentage.equals(this.getRecalculationPercentage())) {
            return;
        }
        this.preSet();
        this.recalculationPercentage = _recalculationPercentage;
        this.autoUpdate();
    }

    @Override
    public void addInterestPeriods(Collection collection) throws Exception {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.addInterestPeriods((InterestPeriod)it.next());
        }
    }

    @Override
    public void addInterestPeriods(InterestPeriod object) throws Exception {
        if (object != null) {
            if (!PersistenceMetaDataInterestPeriod.getInstance().isPersistable(object)) {
                throw new Exception("Tried to attach to a InterestBookYear an InterestPeriod that is not valid implementation class!!");
            }
            if (generalAccessor.getObjectAttribute(object, "interestTableId") != null) {
                throw new Exception("Tried to attach to a InterestBookYear a InterestPeriod that is allready owned (by a InterestBookYear");
            }
            this.assureStorage();
            object.preSet();
            generalAccessor.setAttribute((Object)object, "interestTableId", this.getInterestTableId());
            generalAccessor.setAttribute((Object)object, "bookYear", this.getBookYear());
            ((BusinessObject_Impl)((Object)object)).save();
            ((BusinessObject_Impl)((Object)object)).addCachedRelationObject("ownedByInterestBookYearAsInterestPeriods", this);
        }
        this.clearCachedRelation("InterestPeriodsCollection");
    }

    @Override
    public void removeInterestPeriods(Collection collection) throws Exception {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.removeInterestPeriods((InterestPeriod)it.next());
        }
    }

    @Override
    public void removeInterestPeriods(InterestPeriod object) throws Exception {
        if (object != null) {
            object.delete();
            this.clearCachedRelation("InterestPeriodsCollection");
            ((BusinessObject_Impl)((Object)object)).clearCachedRelation("ownedByInterestBookYearAsInterestPeriods");
        }
    }

    private void initializeTheImplementationClass() throws Exception {
        this.interestTableId = "";
        this.bookYear = 0;
        this.recalculationPercentage = new BigDecimal("0.000").setScale(3, 6);
    }

    protected void updateDBImage() throws Exception {
        if (this.currentDBImage == null) {
            this.currentDBImage = new DBImage();
        }
        this.currentDBImage.interestTableId = this.interestTableId;
        this.currentDBImage.bookYear = this.bookYear;
        this.currentDBImage.recalculationPercentage = this.recalculationPercentage;
        this.updateTransactionImage();
    }

    private void autoUpdate() throws Exception {
        if (this.underConstruction) {
            return;
        }
        if (this.deleted) {
            throw new InvalidStateException("InterestBookYear is deleted!");
        }
        this.dirty = true;
        if (!this.deferUpdate() && !this.holdUpdate) {
            this.save();
        }
    }

    @Override
    public void assureStorage() throws Exception {
        if (this.stored || this.updateDefered) {
            return;
        }
        boolean pre = this.holdUpdate;
        this.holdUpdate = false;
        this.autoUpdate();
        this.holdUpdate = pre;
    }

    @Override
    public void delete() throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.stored) {
            ConnectionProvider provider = this.getConnectionProvider();
            if (!this.participatingInTransaction && provider instanceof AtomicDBTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
                this.updateDefered = false;
            }
            InterestBookYearPK key = new InterestBookYearPK();
            key.setInterestTableId(this.getInterestTableId());
            key.setBookYear(this.getBookYear());
            ((InterestBookYearManager_Impl)InterestBookYearManager_Impl.getInstance(this.dbd)).removeByPrimaryKey(key);
        }
        this.deleted = true;
    }

    @Override
    public void refreshData() throws Exception {
        this.save();
        this.relationalCache = null;
        ResultSet rs = null;
        try {
            rs = ((InterestBookYearManager_Impl)InterestBookYearManager_Impl.getInstance(this.dbd)).getResultSet((InterestBookYearPK)this.getPrimaryKey());
            this.loadData(rs);
        }
        catch (FinderException e) {
            throw new DeletedException("Deleted by other user");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                this.hashCode = new String("-298292202_" + this.dbd.getDBId() + this.interestTableId + this.bookYear).hashCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.hashCode;
    }

    @Override
    public InterestBookYearDataBean getDataBean() throws Exception {
        return this.getDataBean(null);
    }

    @Override
    public InterestBookYearDataBean getInterestBookYearDataBean() throws Exception {
        return this.getDataBean(null);
    }

    private InterestBookYearDataBean getDataBean(InterestBookYearDataBean bean) throws Exception {
        if (bean == null) {
            bean = new InterestBookYearDataBean();
        }
        bean.setInterestTableId(this.getInterestTableId());
        bean.setBookYear(this.getBookYear());
        bean.setRecalculationPercentage(this.getRecalculationPercentage());
        return bean;
    }

    public boolean equals(Object object) {
        try {
            if (object == null || !(object instanceof InterestBookYear_Impl)) {
                return false;
            }
            InterestBookYear_Impl bo = (InterestBookYear_Impl)object;
            if (bo.getInterestTableId() == null ? this.getInterestTableId() != null : !bo.getInterestTableId().equals(this.getInterestTableId())) {
                return false;
            }
            if (bo.getBookYear() != this.getBookYear()) {
                return false;
            }
            if (bo.getClass() != this.getClass()) {
                return false;
            }
            return bo.getDBId() == this.getDBId();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void update(InterestBookYearDataBean bean) throws Exception {
        this.set(bean);
    }

    public void set(InterestBookYearDataBean bean) throws Exception {
        this.preSet();
        boolean pre = this.holdUpdate;
        try {
            this.holdUpdate = true;
            this.setInterestTableId(bean.getInterestTableId());
            this.setBookYear(bean.getBookYear());
            this.setRecalculationPercentage(bean.getRecalculationPercentage());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.holdUpdate = pre;
        }
        this.autoUpdate();
    }

    @Override
    public void save() throws Exception {
        if (this.deleted) {
            throw new InvalidStateException(-1, "InterestBookYear is deleted!");
        }
        if (!this.stored) {
            this.insert();
        } else if (this.dirty) {
            this.update();
        }
        this.updateDefered = false;
    }

    private void update() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        DBImage image = this.currentDBImage;
        StringBuffer key = new StringBuffer("nl.ibs.fac.db.InterestBookYear.save");
        try {
            PreparedStatement prep = dbc.getPreparedStatement(key.toString());
            if (prep == null) {
                prep = dbc.getPreparedStatement(key.toString(), " UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + pmd.getFieldName("InterestTableId", provider) + " = ? , " + pmd.getFieldName("BookYear", provider) + " = ? , " + pmd.getFieldName("RecalculationPercentage", provider) + " = ?  WHERE " + pmd.getFieldName("InterestTableId", provider) + " = ?  AND  " + pmd.getFieldName("BookYear", provider) + " = ?  AND  " + pmd.getFieldName("RecalculationPercentage", provider) + " = ? ");
            }
            int parmIndex = 1;
            prep.setObject(parmIndex++, (Object)this.interestTableId, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Integer(this.bookYear), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)this.recalculationPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
            prep.setObject(parmIndex++, (Object)image.interestTableId, mapping.getJDBCTypeFor("String"));
            prep.setObject(parmIndex++, (Object)new Integer(image.bookYear), mapping.getJDBCTypeFor("int"));
            prep.setObject(parmIndex++, (Object)image.recalculationPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
            int n = prep.executeUpdate();
            if (n == 0) {
                this.rollback(true);
                throw new UpdateException("InterestBookYear modified by other user!", this);
            }
            this.updateDBImage();
            this.dirty = false;
            this.stored = true;
            if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
            }
        }
        catch (Exception e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    private void insert() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        this.stored = true;
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate(this) : provider.getConnection();
        try {
            PreparedStatement prep = dbc.getPreparedStatement("nl.ibs.fac.db.InterestBookYear.insert");
            if (prep == null) {
                prep = dbc.getPreparedStatement("nl.ibs.fac.db.InterestBookYear.insert", "INSERT INTO " + provider.getPrefix() + pmd.getTableName(provider) + " ( " + pmd.getFieldName("InterestTableId", provider) + ", " + pmd.getFieldName("BookYear", provider) + ", " + pmd.getFieldName("RecalculationPercentage", provider) + ") VALUES (?,?,?)");
            }
            prep.setObject(1, (Object)this.interestTableId, mapping.getJDBCTypeFor("String"));
            prep.setObject(2, (Object)new Integer(this.bookYear), mapping.getJDBCTypeFor("int"));
            prep.setObject(3, (Object)this.recalculationPercentage, mapping.getJDBCTypeFor("BigDecimal"), 3);
            prep.executeUpdate();
            this.updateDBImage();
            this.dirty = false;
            DBPersistenceManager.cache(this);
            if (provider instanceof AtomicDBTransaction && !this.participatingInTransaction) {
                ((AtomicDBTransaction)provider).addListener(this);
                this.participatingInTransaction = true;
            }
        }
        catch (CreateException e) {
            this.stored = false;
            throw e;
        }
        catch (Exception e) {
            this.stored = false;
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public void preSet() throws Exception {
        if (this.underConstruction) {
            return;
        }
        this.validateProvider();
        if (this.currentDBImage == null && this.stored) {
            this.updateDBImage();
        }
        this.dirty = true;
    }

    private void validateProvider() throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if (provider instanceof AtomicDBTransaction && !((AtomicDBTransaction)provider).isActive()) {
            throw new Exception("Current transaction set but not active! Start transaction before modifying BusinessObjects!");
        }
    }

    protected void updateTransactionImage() throws Exception {
        this.updateTransactionImage(false);
    }

    protected void updateTransactionImage(boolean forse) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        if ((this.transactionImage == null || forse) && provider instanceof AtomicDBTransaction) {
            if (this.transactionImage == null) {
                this.transactionImage = new TransactionImage();
            }
            if (this.transactionImage.dbImage == null) {
                this.transactionImage.dbImage = new DBImage();
            }
            this.transactionImage.dbImage.interestTableId = this.currentDBImage.interestTableId;
            this.transactionImage.dbImage.bookYear = this.currentDBImage.bookYear;
            this.transactionImage.dbImage.recalculationPercentage = this.currentDBImage.recalculationPercentage;
            this.transactionImage.stored = this.stored;
            this.transactionImage.deleted = this.deleted;
        }
    }

    @Override
    public void rollback(boolean includeBOFields) throws Exception {
        if (this.relationalCache != null) {
            this.relationalCache.clear();
        }
        this.updateDefered = false;
        if (this.transactionImage == null) {
            return;
        }
        this.currentDBImage.interestTableId = this.transactionImage.dbImage.interestTableId;
        this.currentDBImage.bookYear = this.transactionImage.dbImage.bookYear;
        this.currentDBImage.recalculationPercentage = this.transactionImage.dbImage.recalculationPercentage;
        if (includeBOFields) {
            this.interestTableId = this.transactionImage.dbImage.interestTableId;
            this.bookYear = this.transactionImage.dbImage.bookYear;
            this.recalculationPercentage = this.transactionImage.dbImage.recalculationPercentage;
        }
        this.stored = this.transactionImage.stored;
        this.deleted = this.transactionImage.deleted;
        this.participatingInTransaction = false;
        if (!this.stored) {
            DBPersistenceManager.removeFromCache(this);
        }
    }

    @Override
    public void commit() throws Exception {
        if (this.deleted) {
            DBPersistenceManager.removeFromCache(this);
        } else {
            this.updateTransactionImage(true);
        }
        this.participatingInTransaction = false;
        this.updateDefered = false;
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public int getDBId() {
        return this.dbd.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.dbd;
    }

    protected boolean deferUpdate() throws Exception {
        ConnectionProvider provider;
        if (!deferUpdates) {
            return false;
        }
        if (!this.updateDefered && (provider = this.getConnectionProvider()) instanceof AtomicDBTransaction) {
            ((AtomicDBTransaction)provider).setDeferedForUpdate(this);
            this.updateDefered = true;
        }
        return this.updateDefered;
    }

    protected boolean isCachedRelation(String relation) {
        return this.relationalCache == null ? false : this.relationalCache.containsKey(relation);
    }

    @Override
    public Object addCachedRelationObject(String relation, Object object) {
        if (!cacheRelations) {
            return object;
        }
        if (this.relationalCache == null) {
            this.relationalCache = new HashMap();
        }
        if (object instanceof ArrayListImpl) {
            ((ArrayListImpl)object).fixate();
        }
        this.relationalCache.put(relation, object);
        return object;
    }

    protected Object getCachedRelationObject(String relation) {
        if (this.relationalCache == null) {
            return null;
        }
        Object o = this.relationalCache.get(relation);
        if (o instanceof BusinessObject_Impl) {
            return ((BusinessObject_Impl)o).isDeleted() ? null : o;
        }
        if (o instanceof ArrayListImpl) {
            ArrayList list = ((ArrayListImpl)o).getBaseCopy();
            for (int x = 0; x < list.size(); ++x) {
                if (!((BusinessObject_Impl)list.get(x)).isDeleted()) continue;
                list.remove(x--);
            }
            return list;
        }
        return o;
    }

    @Override
    public void clearCachedRelation(String relation) {
        if (this.relationalCache != null) {
            this.relationalCache.remove(relation);
        }
    }

    private static final class TransactionImage
    implements Serializable {
        private DBImage dbImage;
        boolean stored;
        boolean deleted;

        private TransactionImage() {
        }
    }

    private static final class DBImage
    implements Serializable {
        private String interestTableId;
        private int bookYear;
        private BigDecimal recalculationPercentage;

        private DBImage() {
        }
    }
}

