/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.db.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.ListIterator;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.ProcessParametersDataBean;
import nl.ibs.fac.db.ProcessParametersManager;
import nl.ibs.fac.db.impl.PersistenceMetaDataProcessParameters;
import nl.ibs.fac.db.impl.ProcessParameters_Impl;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.Cache;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.Query;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;
import nl.ibs.jsql.exception.JSQLException;
import nl.ibs.jsql.exception.RemoveException;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.ListIteratorImpl;
import nl.ibs.jsql.impl.QueryImplementation;
import nl.ibs.jsql.sql.AttributeAccessor;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.QueryTranslator;
import nl.ibs.vegas.ExecutableQuery;
import nl.ibs.vegas.meta.AttributeMeta;
import nl.ibs.vegas.meta.impl.FieldMetaImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProcessParametersManager_Impl
extends BusinessObjectManager
implements ProcessParametersManager {
    private static final String APPLICATION = "fac";
    private static DOMImplementation domImplementation = DBConfig.getDOMImplementation();
    private static AttributeAccessor generalAccessor = new AttributeAccessor();
    private static boolean verbose = Log.debug();
    private static PersistenceMetaData pmd = PersistenceMetaDataProcessParameters.getInstance();
    private static Hashtable instances = new Hashtable();
    private DBData dbd;
    static final String[] keys = new String[]{"companyId"};
    static final AttributeMeta[] attributes = new AttributeMeta[]{new FieldMetaImpl("companyId", "txt-company-id", "txt-company-id-short", "txt-company-id-description", "text", String.class, 7, 0, null, "false", "false", "", "", false, false, null, null), new FieldMetaImpl("defaultValueInBookPeriod", "txt-default-value-in-book-period", "txt-default-value-in-book-period-short", "txt-default-value-in-book-period-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("journalizeCurrentAssets", "txt-journalize-current-assets", "txt-journalize-current-assets-short", "txt-journalize-current-assets-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("autoUpdateBlockedPeriods", "txt-auto-update-blocked-periods", "txt-auto-update-blocked-periods-short", "txt-auto-update-blocked-periods-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("useCorrectionCodeDC", "txt-use-correction-code-dc", "txt-use-correction-code-dc-short", "txt-use-correction-code-dc-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("standardVoucherDate", "txt-standard-voucher-date", "txt-standard-voucher-date-short", "txt-standard-voucher-date-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("warningForDifferentType", "txt-warning-for-different-type", "txt-warning-for-different-type-short", "txt-warning-for-different-type-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("warningForDifferentDimensions", "txt-warning-for-different-dimensions", "txt-warning-for-different-dimensions-short", "txt-warning-for-different-dimensions-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("autoConfirmIFT", "txt-auto-confirm-i-ft", "txt-auto-confirm-i-ft-short", "txt-auto-confirm-i-ft-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("voucherDateIFTT", "txt-voucher-date-i-f-tt", "txt-voucher-date-i-f-tt-short", "txt-voucher-date-i-f-tt-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("summarizeOnKey", "txt-summarize-on-key", "txt-summarize-on-key-short", "txt-summarize-on-key-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("voucherDateDIR", "txt-voucher-date-d-ir", "txt-voucher-date-d-ir-short", "txt-voucher-date-d-ir-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("startMonth", "txt-start-month", "txt-start-month-short", "txt-start-month-description", "number", Integer.TYPE, 2, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("calendarYearCorrection", "txt-calendar-year-correction", "txt-calendar-year-correction-short", "txt-calendar-year-correction-description", "number", Integer.TYPE, 1, 0, "0", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("fullInterestIn1stPeriod", "txt-full-interest-in1st-period", "txt-full-interest-in1st-period-short", "txt-full-interest-in1st-period-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("useDifferentAcquisitionValues", "txt-use-different-acquisition-values", "txt-use-different-acquisition-values-short", "txt-use-different-acquisition-values-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("assetIdInDescription", "txt-asset-id-in-description", "txt-asset-id-in-description-short", "txt-asset-id-in-description-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("useRCTableForMOVIC", "txt-use-r-c-table-for-m-o-v--ic", "txt-use-r-c-table-for-m-o-v--ic-short", "txt-use-r-c-table-for-m-o-v--ic-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("use445Correction", "txt-use445-correction", "txt-use445-correction-short", "txt-use445-correction-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("balanceAccountsOnIndividualLevel", "txt-balance-accounts-on-individual-level", "txt-balance-accounts-on-individual-level-short", "txt-balance-accounts-on-individual-level-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("gLBookValueRegistration", "txt-g-l-book-value-registration", "txt-g-l-book-value-registration-short", "txt-g-l-book-value-registration-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("isTestCompany", "txt-is-test-company", "txt-is-test-company-short", "txt-is-test-company-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("depreciateBeyondEconomicLife", "txt-depreciate-beyond-economic-life", "txt-depreciate-beyond-economic-life-short", "txt-depreciate-beyond-economic-life-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null), new FieldMetaImpl("assetDescriptionInDescription", "txt-asset-description-in-description", "txt-asset-description-in-description-short", "txt-asset-description-in-description-description", "boolean", Boolean.TYPE, 0, 0, "false", "false", "false", "", "", false, false, null, null)};

    private ProcessParametersManager_Impl(DBData dbData) {
        this.dbd = dbData;
    }

    public static ProcessParametersManager getInstance() {
        return ProcessParametersManager_Impl.getInstance(DBData.getDefaultDBData(APPLICATION));
    }

    public static ProcessParametersManager getInstance(DBData dbd) {
        if (dbd == null) {
            throw new IllegalArgumentException("Tried to instantiate a Manager it DBData = null!");
        }
        ProcessParametersManager_Impl inst = (ProcessParametersManager_Impl)instances.get(dbd);
        if (inst == null) {
            inst = new ProcessParametersManager_Impl(dbd);
            instances.put(dbd, inst);
        }
        return inst;
    }

    public DBData getDBData() {
        return this.dbd;
    }

    @Override
    public ProcessParameters create(ProcessParametersDataBean bean) throws Exception {
        ProcessParameters_Impl impl = new ProcessParameters_Impl(this.dbd, bean);
        impl.assureStorage();
        return impl;
    }

    @Override
    public ProcessParameters create(String _companyId) throws Exception {
        ProcessParameters_Impl obj = new ProcessParameters_Impl(this.dbd, _companyId);
        obj.assureStorage();
        return obj;
    }

    private String getPK(ResultSet rs) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        String inst = rs.getString(pmd.getFieldName("CompanyId", provider));
        return inst;
    }

    @Override
    public ProcessParameters findOrCreate(String _companyId) throws Exception {
        ProcessParameters obj;
        try {
            obj = this.findByPrimaryKey(_companyId);
        }
        catch (FinderException e) {
            obj = this.create(_companyId);
        }
        return obj;
    }

    @Override
    public void add(ProcessParametersDataBean inst) throws Exception {
        ProcessParameters_Impl impl = new ProcessParameters_Impl(this.dbd, inst);
        impl.assureStorage();
    }

    @Override
    public void removeByPrimaryKey(String _companyId) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        ProcessParameters cachedObject = this.getCachedObjectByPrimaryKey(_companyId);
        DBConnection dbc = provider instanceof AtomicDBTransaction ? ((AtomicDBTransaction)provider).getConnectionForUpdate((BusinessObject_Impl)((Object)cachedObject)) : provider.getConnection();
        String pskey = "nl.ibs.fac.db.ProcessParameters.removeByPrimaryKey";
        try {
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=?");
            }
            prep.setString(1, _companyId);
            int x = prep.executeUpdate();
            if (x == 0) {
                throw new RemoveException("Key not found");
            }
            if (cachedObject != null) {
                DBPersistenceManager.removeFromCache(cachedObject);
            }
        }
        catch (SQLException e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessParameters findByPrimaryKey(String _companyId) throws Exception {
        ProcessParameters processParameters = this.getCachedObjectByPrimaryKey(_companyId);
        if (processParameters != null) {
            return processParameters;
        }
        ResultSet rs = null;
        try {
            rs = this.getResultSet(_companyId);
            ProcessParameters processParameters2 = (ProcessParameters)this.getBusinessObject(rs);
            return processParameters2;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                }
            }
        }
    }

    public ResultSet getResultSet(String _companyId) throws Exception {
        ResultSet rs = null;
        String pskey = "nl.ibs.fac.db.ProcessParameters.findByPrimaryKey1";
        Object inst = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " SELECT *  FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=?");
            }
            prep.setString(1, _companyId);
            prep.executeQuery();
            rs = prep.getResultSet();
            if (!rs.next()) {
                throw new FinderException("Key not found");
            }
        }
        catch (SQLException e) {
            if (!(e instanceof JSQLException)) {
                Log.error((String)e.getMessage());
            }
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
        return rs;
    }

    public ProcessParameters getCachedObjectByPrimaryKey(String _companyId) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache == null) {
            return null;
        }
        Object o = cache.get(new String("1323839091_" + this.dbd.getDBId() + _companyId));
        return (ProcessParameters)o;
    }

    @Override
    public ConnectionProvider getConnectionProvider() throws Exception {
        return DBPersistenceManager.getConnectionProvider(this.dbd);
    }

    @Override
    public PersistenceMetaData getPersistenceMetaData() {
        return pmd;
    }

    public Collection getOwnedProcessParameters(Company company) throws Exception {
        ResultSet rs = null;
        Collection result = null;
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String pskey = "nl.ibs.fac.db.ProcessParameters.getOwnedProcessParameters_0_for_Company.ProcessParameters";
            PreparedStatement prep = dbc.getPreparedStatement(pskey);
            if (prep == null) {
                prep = dbc.getPreparedStatement(pskey, " SELECT   *  FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + pmd.getFieldName("CompanyId", provider) + "=? ", 0);
            }
            prep.setObject(1, generalAccessor.getObjectAttribute(company, "id"), mapping.getJDBCTypeFor("String"));
            rs = prep.executeQuery();
            result = this.getCollection(rs);
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            provider.returnConnection(dbc);
        }
        return result;
    }

    @Override
    public int generalUpdate(String setClause, String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String update = "UPDATE " + provider.getPrefix() + pmd.getTableName(provider) + " SET " + QueryTranslator.translateObjectQuery(setClause + " WHERE " + whereClause, pmd, provider);
            int n = dbc.executeUpdate(update);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public int generalDelete(String whereClause) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        DBMapping mapping = provider.getDBMapping();
        DBConnection dbc = provider.getConnection();
        try {
            String delete = "DELETE FROM " + provider.getPrefix() + pmd.getTableName(provider) + " WHERE " + QueryTranslator.translateObjectQuery(whereClause, pmd, provider);
            int n = dbc.executeUpdate(delete);
            return n;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            throw e;
        }
        finally {
            provider.returnConnection(dbc);
        }
    }

    @Override
    public ProcessParameters getFirstObject(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create();
        }
        int prevMax = query.getMaxObjects();
        query.setMaxObjects(1);
        try {
            ProcessParameters processParameters = (ProcessParameters)((QueryImplementation)query).execute(this, (short)0);
            return processParameters;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            query.setMaxObjects(prevMax);
        }
    }

    @Override
    public Collection getCollection(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Collection)queryImpl.execute(this, (short)-1);
    }

    public ListIterator getListIterator(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ListIterator)queryImpl.execute(this, (short)-2);
    }

    @Override
    public Document getDocument(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (Document)queryImpl.execute(this, (short)-3);
    }

    @Override
    public DocumentFragment getDocumentFragment(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (DocumentFragment)queryImpl.execute(this, (short)-4);
    }

    @Override
    public ArrayList getDocumentFragmentArrayList(Query query) throws Exception {
        if (query == null) {
            query = QueryFactory.create(this, null, null, 1000);
        }
        QueryImplementation queryImpl = (QueryImplementation)query;
        return (ArrayList)queryImpl.execute(this, (short)-5);
    }

    @Override
    protected Collection getCollection(ResultSet rs) throws Exception {
        ArrayListImpl result = new ArrayListImpl();
        while (rs.next()) {
            ((ArrayList)result).add(this.getBusinessObject(rs));
        }
        return result;
    }

    @Override
    protected Document getDocument(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        Element root = document.getDocumentElement();
        this.collectResultElements(resultSet, root, this.getConnectionProvider());
        return document;
    }

    @Override
    protected DocumentFragment getDocumentFragment(ResultSet resultSet) throws Exception {
        Document document = domImplementation.createDocument("", "data", null);
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.collectResultElements(resultSet, documentFragment, this.getConnectionProvider());
        return documentFragment;
    }

    @Override
    protected ArrayList getDocumentFragmentArrayList(ResultSet resultSet) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        Document document = domImplementation.createDocument("", "data", null);
        ArrayListImpl arrayList = new ArrayListImpl();
        while (resultSet.next()) {
            DocumentFragment documentFragment = document.createDocumentFragment();
            Node rec = documentFragment.appendChild(document.createElement("processparameters"));
            ProcessParametersManager_Impl.addBOFieldsToElement(resultSet, rec, provider);
            ((ArrayList)arrayList).add(documentFragment);
        }
        return arrayList;
    }

    @Override
    protected ListIterator getListIterator(ResultSet rs) throws Exception {
        ListIteratorImpl result = new ListIteratorImpl();
        while (rs.next()) {
            result.add(this.getBusinessObject(rs));
        }
        result.pointer = 0;
        return result;
    }

    @Override
    protected Object getBusinessObject(ResultSet rs) throws Exception {
        Cache cache = DBPersistenceManager.getCache();
        if (cache != null) {
            ConnectionProvider provider = this.getConnectionProvider();
            Object o = cache.get(new String("1323839091_" + this.dbd.getDBId() + rs.getObject(pmd.getFieldName("CompanyId", provider))));
            if (o != null) {
                return o;
            }
        }
        return DBPersistenceManager.cache(this.createBusinessObject(rs));
    }

    private Object createBusinessObject(ResultSet rs) throws Exception {
        return new ProcessParameters_Impl(this.dbd, rs);
    }

    private void collectResultElements(ResultSet rs, Node root, ConnectionProvider provider) throws Exception {
        Document doc = root.getOwnerDocument();
        while (rs.next()) {
            Node rec = root.appendChild(doc.createElement("processparameters"));
            ProcessParametersManager_Impl.addBOFieldsToElement(rs, rec, provider);
        }
    }

    public static void addBOFieldsToElement(ResultSet rs, Node rec, ConnectionProvider provider) throws Exception {
        DBMapping mapping = provider.getDBMapping();
        Document doc = rec.getOwnerDocument();
        Object o = null;
        String s = null;
        s = rs.getString(pmd.getFieldName("CompanyId", provider));
        if (s != null && (s = s.trim()).length() > 0) {
            rec.appendChild(doc.createElement("companyid")).appendChild(doc.createCDATASection(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("DefaultValueInBookPeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("defaultvalueinbookperiod")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("JournalizeCurrentAssets", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("journalizecurrentassets")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("AutoUpdateBlockedPeriods", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("autoupdateblockedperiods")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("UseCorrectionCodeDC", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("usecorrectioncodedc")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("StandardVoucherDate", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("standardvoucherdate")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("WarningForDifferentType", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("warningfordifferenttype")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("WarningForDifferentDimensions", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("warningfordifferentdimensions")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("AutoConfirmIFT", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("autoconfirmift")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("VoucherDateIFTT", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("voucherdateiftt")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("SummarizeOnKey", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("summarizeonkey")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("VoucherDateDIR", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("voucherdatedir")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("StartMonth", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("startmonth")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("CalendarYearCorrection", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("calendaryearcorrection")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("FullInterestIn1stPeriod", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("fullinterestin1stperiod")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("UseDifferentAcquisitionValues", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("usedifferentacquisitionvalues")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("AssetIdInDescription", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("assetidindescription")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("UseRCTableForMOV_IC", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("userctableformov_ic")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("Use445Correction", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("use445correction")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("BalanceAccountsOnIndividualLevel", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("balanceaccountsonindividuallevel")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("GLBookValueRegistration", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("glbookvalueregistration")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("IsTestCompany", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("istestcompany")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("DepreciateBeyondEconomicLife", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("depreciatebeyondeconomiclife")).appendChild(doc.createTextNode(s));
        }
        if ((o = rs.getObject(pmd.getFieldName("AssetDescriptionInDescription", provider))) != null && (s = String.valueOf(o).trim()).length() > 0) {
            rec.appendChild(doc.createElement("assetdescriptionindescription")).appendChild(doc.createTextNode(s));
        }
    }

    public ExecutableQuery getExecutableQuery() {
        return QueryFactory.create(this);
    }

    public String[] getKeyNames() {
        return keys;
    }

    public AttributeMeta[] getAttributes() {
        return attributes;
    }

    public Class getClassType() {
        return ProcessParameters.class;
    }

    public String getNameField() {
        return "companyId";
    }

    public String getDescriptionField() {
        return "companyId";
    }

    public String getTextKey() {
        return "txt-process-parameters";
    }

    public String getTextKeyShort() {
        return "txt-process-parameters-short";
    }

    public String getTextKeyDescription() {
        return "txt-process-parameters-description";
    }

    public AttributeMeta getAttribute(String name) {
        if (attributes == null || name == null) {
            return null;
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (!name.equals(attributes[i].getName())) continue;
            return attributes[i];
        }
        return null;
    }
}

